/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CGIClientException;
import com.sas.rmi.CGICommandHandler;
import com.sas.rmi.CGIHandler;
import com.sas.rmi.CGIServerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

final class CGIForwardCommand
implements CGICommandHandler {
    CGIForwardCommand() {
    }

    @Override
    public String getName() {
        return "forward";
    }

    @Override
    public void execute(String param) throws CGIClientException, CGIServerException {
        String line;
        DataInputStream socketIn;
        Socket socket;
        int port;
        if (!CGIHandler.RequestMethod.equals("POST")) {
            throw new CGIClientException("can only forward POST requests");
        }
        try {
            port = Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            throw new CGIClientException("invalid port number: " + param);
        }
        if (port <= 0 || port > 65535) {
            throw new CGIClientException("invalid port: " + port);
        }
        if (port < 1024) {
            throw new CGIClientException("permission denied for port: " + port);
        }
        try {
            socket = new Socket(InetAddress.getLocalHost(), port);
        }
        catch (IOException e) {
            throw new CGIServerException("could not connect to local port");
        }
        DataInputStream clientIn = new DataInputStream(System.in);
        byte[] buffer = new byte[CGIHandler.ContentLength];
        try {
            clientIn.readFully(buffer);
        }
        catch (EOFException e) {
            throw new CGIClientException("unexpected EOF reading request body");
        }
        catch (IOException e) {
            throw new CGIClientException("error reading request body");
        }
        try {
            DataOutputStream socketOut = new DataOutputStream(socket.getOutputStream());
            socketOut.writeBytes("POST / HTTP/1.0\r\n");
            socketOut.writeBytes("Content-length: " + CGIHandler.ContentLength + "\r\n\r\n");
            socketOut.write(buffer);
            socketOut.flush();
        }
        catch (IOException e) {
            throw new CGIServerException("error writing to server");
        }
        try {
            socketIn = new DataInputStream(socket.getInputStream());
        }
        catch (IOException e) {
            throw new CGIServerException("error reading from server");
        }
        String key = "Content-length:".toLowerCase();
        boolean contentLengthFound = false;
        int responseContentLength = -1;
        do {
            try {
                line = socketIn.readLine();
            }
            catch (IOException e) {
                throw new CGIServerException("error reading from server");
            }
            if (line == null) {
                throw new CGIServerException("unexpected EOF reading server response");
            }
            if (!line.toLowerCase().startsWith(key)) continue;
            if (contentLengthFound) {
                // empty if block
            }
            responseContentLength = Integer.parseInt(line.substring(key.length()).trim());
            contentLengthFound = true;
        } while (line.length() != 0 && line.charAt(0) != '\r' && line.charAt(0) != '\n');
        if (!contentLengthFound || responseContentLength < 0) {
            throw new CGIServerException("missing or invalid content length in server response");
        }
        buffer = new byte[responseContentLength];
        try {
            socketIn.readFully(buffer);
        }
        catch (EOFException e) {
            throw new CGIServerException("unexpected EOF reading server response");
        }
        catch (IOException e) {
            throw new CGIServerException("error reading from server");
        }
        System.out.println("Status: 200 OK");
        System.out.println("Content-type: application/octet-stream");
        System.out.println("");
        try {
            System.out.write(buffer);
        }
        catch (IOException e) {
            throw new CGIServerException("error writing response");
        }
        System.out.flush();
    }
}

