/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.BrokerConfiguration;
import com.sas.rmi.BrokerConnector;
import com.sas.rmi.Connection;
import com.sas.rmi.PoolQueue;
import com.sas.rmi.ServerFactory;
import java.util.Vector;

public class BrokerPool {
    private BrokerConfiguration m_config;
    ServerFactory m_factory;
    PoolQueue m_queue = null;
    boolean m_debug = false;

    public BrokerPool(ServerFactory factory) {
        this.m_factory = factory;
    }

    public void setDebug(boolean value) {
        this.m_debug = value;
    }

    public void setConfig(BrokerConfiguration config) {
        this.m_config = config;
        this.fireBrokerEvent(this, "Creating new pool for " + this.getPoolDescription());
        this.update(config);
    }

    public void setConfig(Connection context) {
        this.m_config = new BrokerConfiguration();
        this.m_config.setConnection(context);
        this.m_config.setSessions(2);
        this.fireBrokerEvent(this, "Creating new pool for " + this.getPoolDescription());
        this.update(this.m_config);
    }

    public BrokerConfiguration getConfig() {
        return this.m_config;
    }

    public void update(BrokerConfiguration config) {
        this.m_config.setSessions(config.getSessions());
        this.m_config.setSessionTimeout(config.getSessionTimeout());
        this.fireBrokerEvent(this, "Updating session count to " + config.getSessions() + " for " + this.getPoolDescription());
        if (this.m_config.getSessionTimeout() != 300) {
            this.fireBrokerEvent(this, "Session timeout for " + this.getPoolDescription() + " is " + this.m_config.getSessionTimeout() + " seconds");
        }
    }

    public int getMaxSessions() {
        return this.m_config.getSessions();
    }

    public boolean equals(BrokerConfiguration config) {
        return this.doesHostUserPasswordEqual(config.getConnection().getHost(), config.getConnection().getCommand(), config.getConnection().getUsername(), config.getConnection().getPassword());
    }

    public boolean doesHostUserPasswordEqual(String host, String command, String user, String password) {
        if (!this.equals(this.m_config.getConnection().getHost(), host)) {
            return false;
        }
        if (!this.equals(this.m_config.getConnection().getCommand(), command)) {
            return false;
        }
        if (!this.equals(this.m_config.getConnection().getUsername(), user)) {
            return false;
        }
        return this.equals(this.m_config.getConnection().getPassword(), password);
    }

    public boolean doesHostEqual(String host, String command) {
        if (this.m_config.getConnection().getHost() == null || host == null) {
            return true;
        }
        if (!this.equals(this.m_config.getConnection().getHost(), host)) {
            return false;
        }
        return this.equals(this.m_config.getConnection().getCommand(), command);
    }

    public boolean doesUserPasswordEqual(String user, String password) {
        if (this.m_config.getConnection().getUsername() == null || user == null) {
            return true;
        }
        if (!this.equals(this.m_config.getConnection().getUsername(), user)) {
            return false;
        }
        return this.equals(this.m_config.getConnection().getPassword(), password);
    }

    private boolean equals(String s1, String s2) {
        boolean rc = false;
        if (s1 == null) {
            if (s2 == null) {
                rc = true;
            } else if (s2.length() == 0) {
                rc = true;
            }
        } else if (s2 != null) {
            rc = s1.equals(s2);
        } else if (s1.length() == 0) {
            rc = true;
        }
        return rc;
    }

    public Vector getFactories() {
        return this.m_factory.getFactories();
    }

    public void fireBrokerEvent(Object source, String msg) {
        this.m_factory.fireBrokerEvent(source, msg);
    }

    public void createFactoryThread() {
        this.createFactoryThread(0);
    }

    public void createFactoryThread(int delaySeconds) {
        if (this.m_queue != null && !this.m_queue.isAlive()) {
            this.m_queue = null;
        }
        if (this.m_queue == null) {
            this.m_queue = new PoolQueue();
            this.m_queue.setDebug(this.m_debug);
            this.m_queue.setup(this, 1, delaySeconds);
            this.m_queue.start();
        } else {
            this.m_queue.setPoolSize(this.m_queue.getPoolSize() + 1);
        }
    }

    public int getQueueSize() {
        int n = 0;
        if (this.m_queue != null) {
            n = this.m_queue.getPoolSize();
        }
        return n;
    }

    public void clearQueue() {
        if (this.m_queue != null) {
            this.m_queue.setPoolSize(0);
            this.m_queue.stop();
            this.m_queue = null;
        }
    }

    public void setQueueSize(int value) {
        if (this.m_queue != null) {
            this.m_queue.setPoolSize(value);
        }
    }

    public String getPoolDescription() {
        String s = "";
        s = this.m_config.getConnection().getHost() == null ? s + "(localhost)" : s + this.m_config.getConnection().getHost();
        if (this.m_config.getConnection().getUsername() != null) {
            s = s + "[" + this.m_config.getConnection().getUsername() + "]";
        }
        return s;
    }

    public BrokerConnector getConnector() {
        return this.m_factory.getConnector();
    }

    public String toString() {
        return this.m_config.getConnection().getHost() + "," + this.m_config.getConnection().getUsername() + "," + this.m_config.getSessions();
    }
}

