/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.BrokerEvent;
import com.sas.rmi.BrokerEventListener;
import com.sas.rmi.BrokerInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.Rocf;
import com.sas.security.BaseSecuritySupport;
import java.io.DataInputStream;
import java.net.Socket;
import java.util.Vector;

public class BrokerEventClient
implements Runnable {
    private Thread m_thread;
    private Vector m_eventListeners;
    private Socket m_socket;
    private String m_host;
    private Rocf m_rocf;
    private BrokerInterface m_broker;

    public BrokerEventClient(String host) {
        this.m_host = host;
    }

    public void setup() throws Exception {
        this.m_rocf = new Rocf();
        Connection c = new Connection();
        c.setAccessMethod(Connection.ACCESS_METHOD_RMI);
        c.setHost(this.m_host);
        this.m_broker = (BrokerInterface)this.m_rocf.newInstance("com.sas.rmi.Broker", c);
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
        if (this.m_socket != null) {
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_rocf != null) {
            this.m_rocf.stop();
        }
    }

    @Override
    public void run() {
        if (this.m_broker == null) {
            System.out.println("BrokerEventClient not setup");
            return;
        }
        try {
            int port = 0;
            this.m_socket = new Socket(this.m_host, port);
            this.process();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void process() {
        try {
            DataInputStream in = new DataInputStream(this.m_socket.getInputStream());
            while (true) {
                int type = in.readInt();
                String msg = in.readUTF();
                this.fireBrokerEvent(msg, type);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addBrokerEventListener(BrokerEventListener l) {
        if (this.m_eventListeners == null) {
            this.m_eventListeners = new Vector();
        }
        this.m_eventListeners.addElement(l);
    }

    public void removeBrokerEventListener(BrokerEventListener l) {
        if (this.m_eventListeners != null) {
            this.m_eventListeners.removeElement(l);
            if (this.m_eventListeners.size() == 0) {
                this.m_eventListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBrokerEvent(String msg, int type) {
        if (this.m_eventListeners != null) {
            Vector listeners;
            BrokerEventClient brokerEventClient = this;
            synchronized (brokerEventClient) {
                listeners = (Vector)this.m_eventListeners.clone();
            }
            BrokerEvent e = new BrokerEvent(this, msg, type);
            for (int i = 0; i < listeners.size(); ++i) {
                BrokerEventListener l = (BrokerEventListener)listeners.elementAt(i);
                if (l == null) continue;
                l.brokerEvent(e);
            }
        }
    }
}

