/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.BrokerConfiguration;
import com.sas.rmi.BrokerInterface;
import com.sas.rmi.BrokerProperties;
import com.sas.rmi.Connection;
import com.sas.rmi.FactoryThread;
import com.sas.rmi.ServerFactory;
import com.sas.rmi.ServerMain;
import java.io.IOException;

public class Broker
implements BrokerInterface,
ServerMain {
    private ServerFactory m_factory = null;
    private String[] m_args;

    @Override
    public void serverMain(String[] args) {
        this.m_args = args;
        this.startFactory();
    }

    @Override
    public BrokerProperties getConnection(Connection context) throws IOException {
        this.startFactory();
        BrokerProperties props = null;
        while (props == null) {
            FactoryThread f = this.m_factory.getFactoryThread(context);
            props = this.getConnection(f);
            if (props != null) continue;
            this.m_factory.freeFactoryThread(f, true);
        }
        return props;
    }

    private BrokerProperties getConnection(FactoryThread f) throws IOException {
        BrokerProperties props = null;
        int elapsed = 0;
        int slice = 100;
        while ((long)elapsed < f.getTimeoutMillis() && props == null) {
            if (f.getIsReady()) {
                props = f.getConnection();
                continue;
            }
            try {
                Thread.sleep(slice);
                elapsed += slice;
            }
            catch (InterruptedException interruptedException) {}
        }
        return props;
    }

    @Override
    public void updateConfiguration(BrokerConfiguration config) throws IOException {
        this.startFactory();
        this.m_factory.updateConfiguration(config);
    }

    @Override
    public void freeConnection(BrokerProperties props) {
        this.startFactory();
        this.m_factory.freeFactoryThread(props);
    }

    private void startFactory() {
        if (this.m_factory == null) {
            this.m_factory = new ServerFactory(this.m_args);
            this.m_factory.setDebug(true);
            this.m_factory.start();
        }
    }

    @Override
    public int getEventServerPort() {
        this.startFactory();
        return this.m_factory.getEventServerPort();
    }
}

