/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.server.wq;

import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.RemoteObjectRB;
import com.sas.net.server.AfAccessInterface;
import com.sas.net.server.FileSystemBrowserInterface;
import com.sas.net.server.OutputDeliveryInterface;
import com.sas.net.server.RemoteSasException;
import com.sas.net.server.SubmitInterface;
import com.sas.net.server.WorkspaceInterface;
import com.sas.net.server.wq.WQAfAccess;
import com.sas.net.server.wq.WQFileSystemBrowser;
import com.sas.net.server.wq.WQSession;
import com.sas.net.server.wq.WQSubmit;
import com.sas.net.sharenet.ShareNetConnection;
import com.sas.spedo.SpedoManagerInterface;
import com.sas.spedo.wq.WQSpedoManager;
import com.sas.text.Message;
import java.sql.Connection;
import java.sql.SQLException;

public class WQWorkspace
implements WorkspaceInterface {
    private ConnectClient client = null;
    private WQSubmit wqSubmit = null;
    private WQAfAccess wqAfAccess = null;
    private WQFileSystemBrowser wqFileSystemBrowser = null;
    private WQSession parent = null;
    private Connection connection = null;
    private SpedoManagerInterface wqSpedoManager = null;

    protected WQWorkspace(WQSession parent, ConnectClient client) {
        this.client = client;
        this.parent = parent;
    }

    @Override
    public synchronized SubmitInterface getLanguageObject() throws RemoteSasException {
        this.isObjectReleased();
        if (this.wqSubmit == null) {
            this.wqSubmit = new WQSubmit(this, this.client);
        }
        return this.wqSubmit;
    }

    @Override
    public synchronized AfAccessInterface getAfAccessObject() throws RemoteSasException {
        this.isObjectReleased();
        if (this.wqAfAccess == null) {
            this.wqAfAccess = new WQAfAccess(this, this.client);
        }
        return this.wqAfAccess;
    }

    @Override
    public synchronized Connection getSqlObject() throws RemoteSasException {
        block4: {
            this.isObjectReleased();
            try {
                if (this.connection != null && !this.connection.isClosed()) break block4;
                try {
                    this.connection = this.client.getSharenet();
                }
                catch (ConnectException e) {
                    throw new RemoteSasException(e);
                }
            }
            catch (SQLException se) {
                throw new RemoteSasException(se);
            }
        }
        return this.connection;
    }

    @Override
    public SpedoManagerInterface getSpedoManagerObject() throws RemoteSasException {
        this.isObjectReleased();
        if (this.wqSpedoManager == null) {
            try {
                ShareNetConnection shareNetConnection = (ShareNetConnection)this.getSqlObject();
                this.wqSpedoManager = new WQSpedoManager(shareNetConnection);
            }
            catch (Exception e) {
                throw new RemoteSasException(e);
            }
        }
        return this.wqSpedoManager;
    }

    @Override
    public synchronized FileSystemBrowserInterface getFileSystemBrowserObject() throws RemoteSasException {
        this.isObjectReleased();
        if (this.wqFileSystemBrowser == null) {
            this.wqFileSystemBrowser = new WQFileSystemBrowser(this, this.client);
        }
        return this.wqFileSystemBrowser;
    }

    @Override
    public OutputDeliveryInterface getOutputDeliveryObject() throws RemoteSasException {
        this.isObjectReleased();
        throw new RemoteSasException("not yet implemented");
    }

    @Override
    public synchronized void release() throws RemoteSasException {
        if (this.client == null) {
            return;
        }
        this.parent.removeWorkspace(this);
        if (this.wqSubmit != null) {
            this.wqSubmit.release();
        }
        if (this.wqAfAccess != null) {
            this.wqAfAccess.release();
        }
        try {
            if (this.parent.owner) {
                this.client.disconnect();
            }
            this.client = null;
        }
        catch (ConnectException e) {
            this.client = null;
            throw new RemoteSasException(e);
        }
    }

    protected void removeLanguageObject() {
        this.wqSubmit = null;
    }

    protected void removeAfAccessObject() {
        this.wqAfAccess = null;
    }

    protected void removeFileSystemBrowserObject() {
        this.wqFileSystemBrowser = null;
    }

    private void isObjectReleased() throws RemoteSasException {
        if (this.client == null) {
            String messageIndex = "RemObj.R70.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new RemoteSasException(message);
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }
}

