/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.server.wq;

import com.sas.lang.RunnableQueue;
import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.RemoteObjectRB;
import com.sas.net.server.RemoteSasException;
import com.sas.net.server.SubmitInterface;
import com.sas.net.server.SubmitNotificationInterface;
import com.sas.net.server.SubmitOutput;
import com.sas.net.server.wq.WQSubmitOutput;
import com.sas.net.server.wq.WQWorkspace;
import com.sas.text.Message;
import java.util.StringTokenizer;
import java.util.Vector;

public class WQSubmit
implements SubmitInterface {
    private static final String delim = "\n";
    private static final String blankLine = "";
    private WQWorkspace parent = null;
    private ConnectClient client = null;
    private RunnableQueue submitQueue = null;

    protected WQSubmit(WQWorkspace parent, ConnectClient client) {
        this.client = client;
        this.parent = parent;
        this.submitQueue = new RunnableQueue();
    }

    @Override
    public synchronized SubmitOutput submit(String sasCode) throws RemoteSasException {
        this.isObjectReleased();
        SubmitTask submitTask = new SubmitTask(this.client, sasCode);
        this.submitQueue.enqueueTask((Runnable)submitTask);
        try {
            while (!submitTask.isDone()) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            throw new RemoteSasException(ie);
        }
        RemoteSasException exception = submitTask.getException();
        if (exception != null) {
            throw exception;
        }
        return submitTask.getSubmitOutput();
    }

    @Override
    public synchronized void submitBackground(String sasCode, SubmitNotificationInterface callback) throws RemoteSasException {
        this.isObjectReleased();
        SubmitTask submitTask = new SubmitTask(this.client, sasCode, callback);
        this.submitQueue.enqueueTask((Runnable)submitTask);
    }

    @Override
    public synchronized String[] getLog() throws RemoteSasException {
        this.isObjectReleased();
        String log = this.client.getLogLines();
        return WQSubmit.stringToStringArray(log);
    }

    @Override
    public synchronized String[] getList() throws RemoteSasException {
        this.isObjectReleased();
        String list = this.client.getListLines();
        return WQSubmit.stringToStringArray(list);
    }

    @Override
    public String[] getSubmit() throws RemoteSasException {
        this.isObjectReleased();
        String edit = this.client.getEditLines();
        return WQSubmit.stringToStringArray(edit);
    }

    @Override
    public synchronized void clearLog() throws RemoteSasException {
        this.isObjectReleased();
        this.client.clearLogLines();
    }

    @Override
    public synchronized void clearList() throws RemoteSasException {
        this.isObjectReleased();
        this.client.clearListLines();
    }

    @Override
    public synchronized void clearSubmit() throws RemoteSasException {
        this.isObjectReleased();
        this.client.clearEditLines();
    }

    @Override
    public synchronized void release() throws RemoteSasException {
        if (this.client == null) {
            return;
        }
        this.client = null;
        this.parent.removeLanguageObject();
        this.submitQueue.shutDown();
    }

    private void isObjectReleased() throws RemoteSasException {
        if (this.client == null) {
            String messageIndex = "RemObj.R66.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new RemoteSasException(message);
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    protected static String[] stringToStringArray(String s) {
        Vector<String> tempLines = new Vector<String>();
        StringTokenizer t = new StringTokenizer(s, delim, true);
        boolean useBlankLine = true;
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.equals(delim)) {
                if (useBlankLine) {
                    tempLines.addElement(blankLine);
                    continue;
                }
                useBlankLine = true;
                continue;
            }
            tempLines.addElement(token);
            useBlankLine = false;
        }
        int tempLineCount = tempLines.size();
        String[] lines = new String[tempLineCount];
        for (int i = 0; i < tempLineCount; ++i) {
            lines[i] = (String)tempLines.elementAt(i);
        }
        return lines;
    }

    private class SubmitTask
    implements Runnable {
        private ConnectClient client = null;
        private String sasCode = null;
        private SubmitNotificationInterface callback = null;
        private SubmitOutput submitOutput = null;
        private RemoteSasException exception = null;
        private boolean done = false;

        protected SubmitTask(ConnectClient client, String sasCode) {
            this(client, sasCode, null);
        }

        protected SubmitTask(ConnectClient client, String sasCode, SubmitNotificationInterface callback) {
            this.client = client;
            this.sasCode = sasCode;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WQSubmit wQSubmit = WQSubmit.this;
            synchronized (wQSubmit) {
                try {
                    String oldLog = this.client.getLogLines();
                    String oldList = this.client.getListLines();
                    this.client.rsubmit(this.sasCode);
                    String newLog = this.client.getLogLines();
                    String newList = this.client.getListLines();
                    String difLog = newLog.substring(oldLog.length());
                    String difList = newList.substring(oldList.length());
                    String[] logLines = WQSubmit.stringToStringArray(difLog);
                    String[] listLines = WQSubmit.stringToStringArray(difList);
                    this.submitOutput = new WQSubmitOutput(logLines, listLines);
                    if (this.callback != null) {
                        this.callback.submitComplete(this.submitOutput);
                    }
                }
                catch (ConnectException e) {
                    this.exception = new RemoteSasException(e);
                    if (this.callback != null) {
                        this.callback.submitFailed(this.exception);
                    }
                }
                finally {
                    this.done = true;
                    if (this.callback == null) {
                        WQSubmit.this.notifyAll();
                    }
                }
            }
        }

        protected SubmitOutput getSubmitOutput() {
            return this.submitOutput;
        }

        protected RemoteSasException getException() {
            return this.exception;
        }

        protected boolean isDone() {
            return this.done;
        }
    }
}

