/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.server.wq;

import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.RemoteObjectRB;
import com.sas.net.connect.TelnetConnectClient;
import com.sas.net.connect.TunneledConnectClient;
import com.sas.net.server.RemoteSasException;
import com.sas.net.server.SessionInterface;
import com.sas.net.server.WorkspaceInterface;
import com.sas.net.server.wq.WQWorkspace;
import com.sas.text.Message;
import java.util.Properties;
import java.util.Vector;

public class WQSession
implements SessionInterface {
    protected Properties properties = null;
    protected Vector workspaceList = new Vector();
    protected ConnectClient readyClient = null;
    protected int majorVersion = 0;
    protected int minorVersion = 0;
    protected boolean owner = true;

    public WQSession(Properties properties) throws RemoteSasException {
        this.properties = (Properties)properties.clone();
        this.getClient();
        try {
            this.majorVersion = this.readyClient.getMajorSasVersion();
            this.minorVersion = this.readyClient.getMinorSasVersion();
        }
        catch (ConnectException e) {
            throw new RemoteSasException(e);
        }
    }

    public WQSession(ConnectClient client) throws RemoteSasException {
        this.properties = new Properties();
        this.readyClient = client;
        try {
            this.majorVersion = this.readyClient.getMajorSasVersion();
            this.minorVersion = this.readyClient.getMinorSasVersion();
        }
        catch (ConnectException e) {
            throw new RemoteSasException(e);
        }
    }

    @Override
    public synchronized WorkspaceInterface getNewWorkspace() throws RemoteSasException {
        this.isObjectReleased();
        WQWorkspace wqWorkspace = null;
        if (this.readyClient == null) {
            this.getClient();
        }
        wqWorkspace = new WQWorkspace(this, this.readyClient);
        this.workspaceList.addElement(wqWorkspace);
        this.readyClient = null;
        return wqWorkspace;
    }

    @Override
    public synchronized int getMajorSasVersion() throws RemoteSasException {
        this.isObjectReleased();
        return this.majorVersion;
    }

    @Override
    public synchronized int getMinorSasVersion() throws RemoteSasException {
        this.isObjectReleased();
        return this.minorVersion;
    }

    @Override
    public synchronized void release() throws RemoteSasException {
        if (this.properties == null) {
            return;
        }
        this.properties = null;
        if (this.readyClient != null && this.owner) {
            try {
                this.readyClient.disconnect();
                this.readyClient = null;
            }
            catch (ConnectException e) {
                this.readyClient = null;
                throw new RemoteSasException(e);
            }
        }
        while (!this.workspaceList.isEmpty()) {
            WQWorkspace wqWorkspace = (WQWorkspace)this.workspaceList.elementAt(0);
            wqWorkspace.release();
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    protected synchronized void removeWorkspace(WQWorkspace wqWorkspace) {
        this.workspaceList.removeElement(wqWorkspace);
    }

    protected void getClient() throws RemoteSasException {
        this.isObjectReleased();
        Object client = null;
        try {
            String routerUrl = this.properties.getProperty("routerUrl");
            String prompt1 = this.properties.getProperty("prompt1");
            client = routerUrl != null && routerUrl.length() > 0 ? new TunneledConnectClient(this.properties) : (prompt1 != null && prompt1.length() > 0 ? new TelnetConnectClient(this.properties) : new ConnectClient());
        }
        catch (ConnectException j) {
            throw new RemoteSasException(j);
        }
        try {
            String host = this.properties.getProperty("host");
            String port = this.properties.getProperty("port", "23");
            client.connect(host, Integer.parseInt(port));
        }
        catch (ConnectException j) {
            throw new RemoteSasException(j);
        }
        this.readyClient = client;
    }

    private void isObjectReleased() throws RemoteSasException {
        if (this.properties == null) {
            String messageIndex = "RemObj.R62.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new RemoteSasException(message);
        }
    }
}

