/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.server.wq;

import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.RemoteObjectRB;
import com.sas.net.server.FileSystemBrowserInterface;
import com.sas.net.server.RemoteSasException;
import com.sas.net.server.wq.WQWorkspace;
import com.sas.text.Message;

public class WQFileSystemBrowser
implements FileSystemBrowserInterface {
    private WQWorkspace parent = null;
    private ConnectClient client = null;

    protected WQFileSystemBrowser(WQWorkspace parent, ConnectClient client) {
        this.parent = parent;
        this.client = client;
    }

    @Override
    public byte[] getFile(String name, boolean binary) throws RemoteSasException {
        return this.downloadFile("'" + name + "'", binary);
    }

    @Override
    public byte[] getFileRef(String fileref, boolean binary) throws RemoteSasException {
        return this.downloadFile(fileref, binary);
    }

    @Override
    public synchronized void release() throws RemoteSasException {
        if (this.client == null) {
            return;
        }
        this.client = null;
        this.parent.removeFileSystemBrowserObject();
    }

    private synchronized byte[] downloadFile(String name, boolean binary) throws RemoteSasException {
        if (this.client == null) {
            String messageIndex = "RemObj.R61.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new RemoteSasException(message);
        }
        String localName = "temp";
        StringBuffer download = new StringBuffer();
        download.append("/* Code submitted to support file download */\n");
        download.append(";run;\n");
        download.append("proc download\n");
        download.append("\tinfile=" + name + "\n");
        download.append("\toutfile='" + localName + "'\n");
        if (binary) {
            download.append("\tbinary\n");
        }
        download.append("\t;\n");
        download.append("run;\n");
        download.append("/* End of code submitted to support file download */");
        try {
            this.client.rsubmit(download.toString());
            return this.client.getDownloadData(localName);
        }
        catch (ConnectException e) {
            throw new RemoteSasException(e);
        }
    }
}

