/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.jdbc;

import com.sas.collection.ContentsChangedListener;
import com.sas.collection.OrderedListCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.net.jdbc._rprxJ2TableList;
import com.sas.net.server.RemoteSasException;
import com.sas.net.server.WorkspaceInterface;
import com.sas.util.ApplyInterface;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;

public class FinalJ2TableList
extends _rprxJ2TableList {
    private OrderedListCollection list = new OrderedListCollection();
    private transient WorkspaceInterface workspace = null;
    private transient Connection sqlConnection = null;
    private String catalog = null;
    private String schemaPattern = null;
    private String tableNamePattern = null;
    private String[] types = null;

    @Override
    public void _RemoteObject_setup(com.sas.rmi.Connection ctxt) {
        try {
            this.workspace = (WorkspaceInterface)ctxt._getWorkspace();
            this.sqlConnection = this.workspace.getSqlObject();
        }
        catch (RemoteSasException e) {
            this.workspace = null;
            this.sqlConnection = null;
            e.printStackTrace();
        }
    }

    public void initialize() {
        super.initialize();
    }

    @Override
    public void setCatalog(String catalog) {
        if (Util.equal((Object)this.catalog, (Object)catalog)) {
            return;
        }
        String temp = this.catalog;
        this.catalog = catalog;
        this.resubmitQuery();
        this.firePropertyChange("catalog", temp, catalog);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setSchemaPattern(String schemaPattern) {
        if (Util.equal((Object)this.schemaPattern, (Object)schemaPattern)) {
            return;
        }
        String temp = this.schemaPattern;
        this.schemaPattern = schemaPattern;
        this.resubmitQuery();
        this.firePropertyChange("schemaPattern", temp, schemaPattern);
    }

    @Override
    public String getSchemaPattern() {
        return this.schemaPattern;
    }

    @Override
    public void setTableNamePattern(String tableNamePattern) {
        if (Util.equal((Object)this.tableNamePattern, (Object)tableNamePattern)) {
            return;
        }
        String temp = this.tableNamePattern;
        this.tableNamePattern = tableNamePattern;
        this.resubmitQuery();
        this.firePropertyChange("tableNamePattern", temp, tableNamePattern);
    }

    @Override
    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    @Override
    public void setTypes(String[] types) {
        if (Strings.equals((String[])this.types, (String[])types)) {
            return;
        }
        String[] temp = this.types;
        this.types = this.cloneStringArray(types);
        this.resubmitQuery();
        this.firePropertyChange("types", temp, types);
    }

    @Override
    public String[] getTypes() {
        return this.types;
    }

    @Override
    public void resubmitQuery() {
        if (this.list.count() > 0) {
            this.list.removeAll();
        }
        try {
            DatabaseMetaData metaData = this.sqlConnection.getMetaData();
            ResultSet tables = metaData.getTables(this.catalog, this.schemaPattern, this.tableNamePattern, this.types);
            while (tables.next()) {
                String tableName = tables.getString(3);
                this.list.add((Object)tableName);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        return this.list.equals(orderedCollection);
    }

    @Override
    public Object get(int index) {
        return this.list.get(index);
    }

    @Override
    public int getIndex(Object element, int startIndex) {
        return this.list.getIndex(element, startIndex);
    }

    @Override
    public Enumeration getItems(int start, int end) {
        return this.list.getItems(start, end);
    }

    @Override
    public int getLastIndex(Object element, int startIndex) {
        return this.list.getLastIndex(element, startIndex);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FinalJ2TableList clone = (FinalJ2TableList)super.clone();
        clone.list = (OrderedListCollection)this.list.clone();
        return clone;
    }

    @Override
    public boolean contains(Object element) {
        return this.list.contains(element);
    }

    @Override
    public void apply(ApplyInterface action) {
        this.list.apply(action);
    }

    @Override
    public int count() {
        return this.list.count();
    }

    @Override
    public Enumeration getItems() {
        return this.list.getItems();
    }

    @Override
    public void addContentsChangedListener(ContentsChangedListener listener) {
        this.list.addContentsChangedListener(listener);
    }

    @Override
    public void removeContentsChangedListener(ContentsChangedListener listener) {
        this.list.removeContentsChangedListener(listener);
    }

    private String[] cloneStringArray(String[] a) {
        if (a == null) {
            return null;
        }
        String[] b = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
        return b;
    }
}

