/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.MissingValues;
import com.sas.collection.hlist.ArrayItem;
import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.ListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.net.connect.ArgumentRecord;
import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.RemoteObjectExtension;
import com.sas.net.connect.RemoteObjectRB;
import com.sas.text.Message;
import java.util.Vector;

public class RemoteObject {
    public static final int typDouble = 0;
    public static final int typFloat = 1;
    public static final int typLong = 2;
    public static final int typInt = 3;
    public static final int typString = 4;
    public static final int typMissing = 5;
    public static final int typList = 6;
    public static final int typDoubleArray = 7;
    public static final int typFloatArray = 8;
    public static final int typLongArray = 9;
    public static final int typIntArray = 10;
    public static final int typStringArray = 11;
    public static final int typShortArray = 12;
    public static final int typCharArray = 13;
    public static final int typByteArray = 14;
    public static final int typBooleanArray = 15;
    public static final int typShort = 16;
    public static final int typChar = 17;
    public static final int typByte = 18;
    public static final int typBoolean = 19;
    public static final int typDoubleArray2D = 20;
    public static final int typFloatArray2D = 21;
    public static final int typLongArray2D = 22;
    public static final int typIntArray2D = 23;
    public static final int typStringArray2D = 24;
    public static final int typShortArray2D = 25;
    public static final int typCharArray2D = 26;
    public static final int typByteArray2D = 27;
    public static final int typBooleanArray2D = 28;
    public static final int Input = 10;
    public static final int Update = 11;
    public static final int Output = 12;
    public int SASV8 = 35;
    private int SASVersion;
    private Double handle = null;
    private String name = null;
    private ConnectClient client = null;
    private RemoteObjectExtension ext = null;
    private Vector args = null;
    private HListInterface returnArgs = null;
    private int returnArgIndex = 0;
    private boolean owner = true;

    public RemoteObject(ConnectClient client, Double handle) throws ConnectException {
        this.client = client;
        this.handle = handle;
        this.ext = (RemoteObjectExtension)client.getExtension(RemoteObjectExtension.class.getName());
        this.owner = false;
        this.SASVersion = client.getMver();
    }

    public void clearArguments() {
        if (this.args != null) {
            this.args.removeAllElements();
        } else {
            this.args = new Vector();
        }
        this.returnArgs = null;
        this.returnArgIndex = 0;
    }

    public void addNumberArgument(double number, int attrib) throws ConnectException {
        this.addDoubleArgument(number, attrib);
    }

    public void addDoubleArgument(double number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "AddDoubleArgument");
        this.args.addElement(new ArgumentRecord(number, 0, attrib, this.SASVersion));
    }

    public void addFloatArgument(float number, int attrib) throws ConnectException {
        this.addDoubleArgument(number, attrib);
    }

    public void addLongArgument(long number, int attrib) throws ConnectException {
        this.addDoubleArgument(number, attrib);
    }

    public void addIntArgument(int number, int attrib) throws ConnectException {
        this.addDoubleArgument(number, attrib);
    }

    public void addShortArgument(short number, int attrib) throws ConnectException {
        this.addDoubleArgument(number, attrib);
    }

    public void addCharArgument(char number, int attrib) throws ConnectException {
        this.addDoubleArgument(number, attrib);
    }

    public void addByteArgument(byte number, int attrib) throws ConnectException {
        this.addDoubleArgument(number, attrib);
    }

    public void addBooleanArgument(boolean number, int attrib) throws ConnectException {
        this.addDoubleArgument(number ? 1.0 : 0.0, attrib);
    }

    public void addMissingArgument(MissingValues value, int attrib) throws ConnectException {
        if (attrib == 12 && value == null) {
            value = MissingValues.Dot;
        }
        RemoteObject.validateCall(this.args, attrib, "addMissingArgument");
        this.args.addElement(new ArgumentRecord(value, 5, attrib, this.SASVersion));
    }

    public void addCharacterArgument(String string, int attrib) throws ConnectException {
        this.addStringArgument(string, attrib);
    }

    public void addStringArgument(String string, int attrib) throws ConnectException {
        if (attrib == 12 && string == null) {
            string = new String();
        }
        RemoteObject.validateCall(this.args, attrib, "addCharacterArgument");
        this.args.addElement(new ArgumentRecord(string, 4, attrib, this.SASVersion));
    }

    public void addNumberArrayArgument(double[] number, int attrib) throws ConnectException {
        this.addDoubleArrayArgument(number, attrib);
    }

    public void addDoubleArrayArgument(double[] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addNumberArrayArgument");
        this.args.addElement(new ArgumentRecord(number, 7, attrib, this.SASVersion));
    }

    public void addFloatArrayArgument(float[] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addFloatArrayArgument");
        this.args.addElement(new ArgumentRecord(number, 8, attrib, this.SASVersion));
    }

    public void addLongArrayArgument(long[] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addLongArrayArgument");
        this.args.addElement(new ArgumentRecord(number, 9, attrib, this.SASVersion));
    }

    public void addIntArrayArgument(int[] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addIntArrayArgument");
        this.args.addElement(new ArgumentRecord(number, 10, attrib, this.SASVersion));
    }

    public void addShortArrayArgument(short[] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addShortArrayArgument");
        this.args.addElement(new ArgumentRecord(number, 12, attrib, this.SASVersion));
    }

    public void addCharArrayArgument(char[] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addCharArrayArgument");
        this.args.addElement(new ArgumentRecord(number, 13, attrib, this.SASVersion));
    }

    public void addByteArrayArgument(byte[] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addByteArrayArgument");
        this.args.addElement(new ArgumentRecord(number, 14, attrib, this.SASVersion));
    }

    public void addBooleanArrayArgument(boolean[] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addBooleanArrayArgument");
        this.args.addElement(new ArgumentRecord(number, 15, attrib, this.SASVersion));
    }

    public void addCharacterArrayArgument(String[] string, int attrib) throws ConnectException {
        this.addStringArrayArgument(string, attrib);
    }

    public void addStringArrayArgument(String[] string, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addCharacterArrayArgument");
        this.args.addElement(new ArgumentRecord(string, 11, attrib, this.SASVersion));
    }

    public void addListArgument(HListInterface hList, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addCharacterArrayArgument");
        this.args.addElement(new ArgumentRecord(hList, 6, attrib, this.SASVersion));
    }

    public void addDoubleArray2DArgument(double[][] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addDoubleArray2DArgument");
        this.args.addElement(new ArgumentRecord(number, 20, attrib, this.SASVersion));
    }

    public void addFloatArray2DArgument(float[][] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addFloatArray2DArgument");
        this.args.addElement(new ArgumentRecord(number, 20, attrib, this.SASVersion));
    }

    public void addLongArray2DArgument(long[][] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addLongArray2DArgument");
        this.args.addElement(new ArgumentRecord(number, 20, attrib, this.SASVersion));
    }

    public void addIntArray2DArgument(int[][] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addIntArray2DArgument");
        this.args.addElement(new ArgumentRecord(number, 20, attrib, this.SASVersion));
    }

    public void addShortArray2DArgument(short[][] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addShortArray2DArgument");
        this.args.addElement(new ArgumentRecord(number, 20, attrib, this.SASVersion));
    }

    public void addCharArray2DArgument(char[][] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addCharArray2DArgument");
        this.args.addElement(new ArgumentRecord(number, 20, attrib, this.SASVersion));
    }

    public void addByteArray2DArgument(byte[][] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addByteArray2DArgument");
        this.args.addElement(new ArgumentRecord(number, 20, attrib, this.SASVersion));
    }

    public void addBooleanArray2DArgument(boolean[][] number, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addBooleanArray2DArgument");
        this.args.addElement(new ArgumentRecord(number, 20, attrib, this.SASVersion));
    }

    public void addStringArray2DArgument(String[][] string, int attrib) throws ConnectException {
        RemoteObject.validateCall(this.args, attrib, "addCharacterArray2DArgument");
        this.args.addElement(new ArgumentRecord(string, 24, attrib, this.SASVersion));
    }

    public void addCharacterArray2DArgument(String[][] string, int attrib) throws ConnectException {
        this.addStringArray2DArgument(string, attrib);
    }

    public void invokeRemoteMethod(String methodName) throws ConnectException {
        this.ext.invokeRemoteMethod(this, methodName);
        this.updateArguments(this.returnArgs, this.args);
    }

    public double getNumberArgument() {
        return this.getDoubleArgument();
    }

    public double getDoubleArgument() {
        return ((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).returnValue;
    }

    public float getFloatArgument() {
        return (float)this.getDoubleArgument();
    }

    public long getLongArgument() {
        return (long)this.getDoubleArgument();
    }

    public int getIntArgument() {
        return (int)this.getDoubleArgument();
    }

    public short getShortArgument() {
        return (short)this.getDoubleArgument();
    }

    public char getCharArgument() {
        return (char)this.getDoubleArgument();
    }

    public byte getByteArgument() {
        return (byte)this.getDoubleArgument();
    }

    public boolean getBooleanArgument() {
        return this.getDoubleArgument() != 0.0;
    }

    public MissingValues getMissingArgument() {
        return (MissingValues)((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public String getCharacterArgument() {
        return this.getStringArgument();
    }

    public String getStringArgument() {
        return (String)((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public double[] getNumberArrayArgument() {
        return this.getDoubleArrayArgument();
    }

    public double[] getDoubleArrayArgument() {
        return (double[])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public float[] getFloatArrayArgument() {
        return (float[])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public long[] getLongArrayArgument() {
        return (long[])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public int[] getIntArrayArgument() {
        return (int[])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public short[] getShortArrayArgument() {
        return (short[])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public char[] getCharArrayArgument() {
        return (char[])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public byte[] getByteArrayArgument() {
        return (byte[])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public boolean[] getBooleanArrayArgument() {
        return (boolean[])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public String[] getCharacterArrayArgument() {
        return this.getStringArrayArgument();
    }

    public String[] getStringArrayArgument() {
        return (String[])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public HListInterface getListArgument() {
        return (HListInterface)((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public double[][] getDoubleArray2DArgument() {
        return (double[][])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public float[][] getFloatArray2DArgument() {
        return (float[][])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public long[][] getLongArray2DArgument() {
        return (long[][])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public int[][] getIntArray2DArgument() {
        return (int[][])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public short[][] getShortArray2DArgument() {
        return (short[][])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public char[][] getCharArray2DArgument() {
        return (char[][])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public byte[][] getByteArray2DArgument() {
        return (byte[][])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public boolean[][] getBooleanArray2DArgument() {
        return (boolean[][])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public String[][] getStringArray2DArgument() {
        return (String[][])((ArgumentRecord)this.args.elementAt((int)this.returnArgIndex++)).originalReference;
    }

    public void destroy() throws ConnectException {
        if (this.owner) {
            this.ext.destroyRemoteInstance(this);
        }
        this.client = null;
        this.handle = null;
        this.ext = null;
    }

    public Double getHandle() {
        return this.handle;
    }

    public boolean isOwner() {
        return this.owner;
    }

    protected RemoteObject(ConnectClient client, String name, Double handle) throws ConnectException {
        this.client = client;
        this.name = name;
        this.handle = handle;
        this.ext = (RemoteObjectExtension)client.getExtension(RemoteObjectExtension.class.getName());
    }

    protected String getName() {
        return new String(this.name);
    }

    protected int getAttributeCount() {
        return this.args.size();
    }

    protected Vector getAttributes() {
        Vector<Integer> argAttributes = new Vector<Integer>();
        int count = this.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            argAttributes.addElement(new Integer(((ArgumentRecord)this.args.elementAt((int)i)).attribute));
        }
        return argAttributes;
    }

    protected HListInterface getArguments() {
        HList list = new HList();
        int count = this.getArgumentCount();
        for (int i = 0; i < count; ++i) {
            list.add((Object)((ArgumentRecord)this.args.elementAt((int)i)).hListItem, i);
        }
        return list;
    }

    protected int getArgumentCount() {
        return this.args.size();
    }

    protected void setArguments(HListInterface returnArgs) {
        this.returnArgs = returnArgs;
    }

    private static void validateCall(Vector args, int attrib, String name) throws ConnectException {
        if (args == null) {
            String messageIndex = "RemObj.R02.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex, (Object)name);
            throw new ConnectException(message);
        }
        if (attrib < 10 || attrib > 12) {
            String messageIndex = "RemObj.R03.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex, (Object)name);
            throw new ConnectException(message);
        }
    }

    private void updateArguments(HListInterface returnArgs, Vector args) throws ConnectException {
        int count = args.size();
        int j = 0;
        block17: for (int i = 0; i < count; ++i) {
            ArgumentRecord argRec = (ArgumentRecord)args.elementAt(i);
            if (argRec.attribute == 10) continue;
            HListItem item = returnArgs.getItem(j++);
            switch (argRec.originalType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    argRec.returnValue = ((DoubleItem)item).getValue();
                    continue block17;
                }
                case 4: {
                    argRec.originalReference = ((StringItem)item).getValue();
                    continue block17;
                }
                case 5: {
                    argRec.originalReference = ((DoubleItem)item).getMissingValue();
                    continue block17;
                }
                case 6: {
                    RemoteObject.updateList(item, argRec);
                    continue block17;
                }
                case 7: {
                    this.updateDoubleArray(item, argRec);
                    continue block17;
                }
                case 8: {
                    RemoteObject.updateFloatArray(item, argRec);
                    continue block17;
                }
                case 9: {
                    RemoteObject.updateLongArray(item, argRec);
                    continue block17;
                }
                case 10: {
                    RemoteObject.updateIntArray(item, argRec);
                    continue block17;
                }
                case 12: {
                    RemoteObject.updateShortArray(item, argRec);
                    continue block17;
                }
                case 13: {
                    RemoteObject.updateCharArray(item, argRec);
                    continue block17;
                }
                case 14: {
                    RemoteObject.updateByteArray(item, argRec);
                    continue block17;
                }
                case 15: {
                    RemoteObject.updateBooleanArray(item, argRec);
                    continue block17;
                }
                case 11: {
                    this.updateStringArray(item, argRec);
                    continue block17;
                }
                case 20: {
                    this.updateDoubleArray2D(item, argRec);
                    continue block17;
                }
                case 24: {
                    this.updateStringArray2D(item, argRec);
                }
            }
        }
    }

    private static void updateList(HListItem item, ArgumentRecord argRec) {
        HListInterface newList = ((ListItem)item).getValue();
        if (argRec.attribute == 12 || argRec.originalReference == null) {
            argRec.originalReference = newList;
            return;
        }
        HListInterface oldList = (HListInterface)argRec.originalReference;
        oldList.removeAll();
        if (newList == null) {
            argRec.originalReference = null;
            return;
        }
        int count = newList.count();
        for (int i = 0; i < count; ++i) {
            oldList.add((Object)newList.getItem(i));
        }
    }

    private void updateStringArray(HListItem item, ArgumentRecord argRec) throws ConnectException {
        if (this.SASVersion >= this.SASV8) {
            ArrayItem arrayItem = (ArrayItem)item;
            String[] str = (String[])arrayItem.getValue();
            if (str == null) {
                argRec.originalReference = null;
                return;
            }
            if (argRec.attribute == 12) {
                argRec.originalReference = str;
            }
        } else {
            HListInterface newList = ((ListItem)item).getValue();
            if (newList == null) {
                argRec.originalReference = null;
                return;
            }
            int count = newList.count();
            if (argRec.attribute == 12) {
                argRec.originalReference = new String[count];
            }
            String[] oldArray = (String[])argRec.originalReference;
            for (int i = 0; i < count; ++i) {
                HListItem listItem = newList.getItem(i);
                if (listItem instanceof StringItem) {
                    oldArray[i] = ((StringItem)listItem).getValue();
                    continue;
                }
                RemoteObject.unexpectedType();
            }
        }
    }

    private void updateDoubleArray(HListItem item, ArgumentRecord argRec) throws ConnectException {
        if (this.SASVersion >= this.SASV8) {
            ArrayItem arrayItem = (ArrayItem)item;
            double[] dou = (double[])arrayItem.getValue();
            if (dou == null) {
                argRec.originalReference = null;
                return;
            }
            if (argRec.attribute == 12) {
                argRec.originalReference = dou;
            }
        } else {
            HListInterface newList = ((ListItem)item).getValue();
            if (newList == null) {
                argRec.originalReference = null;
                return;
            }
            int count = newList.count();
            if (argRec.attribute == 12) {
                argRec.originalReference = new double[count];
            }
            double[] oldArray = (double[])argRec.originalReference;
            for (int i = 0; i < count; ++i) {
                HListItem listItem = newList.getItem(i);
                if (listItem instanceof DoubleItem) {
                    oldArray[i] = ((DoubleItem)listItem).getValue();
                    continue;
                }
                RemoteObject.unexpectedType();
            }
        }
    }

    private static void updateFloatArray(HListItem item, ArgumentRecord argRec) throws ConnectException {
        HListInterface newList = ((ListItem)item).getValue();
        if (newList == null) {
            argRec.originalReference = null;
            return;
        }
        int count = newList.count();
        if (argRec.attribute == 12) {
            argRec.originalReference = new float[count];
        }
        float[] oldArray = (float[])argRec.originalReference;
        for (int i = 0; i < count; ++i) {
            HListItem listItem = newList.getItem(i);
            if (listItem instanceof DoubleItem) {
                oldArray[i] = (float)((DoubleItem)listItem).getValue();
                continue;
            }
            RemoteObject.unexpectedType();
        }
    }

    private static void updateLongArray(HListItem item, ArgumentRecord argRec) throws ConnectException {
        HListInterface newList = ((ListItem)item).getValue();
        if (newList == null) {
            argRec.originalReference = null;
            return;
        }
        int count = newList.count();
        if (argRec.attribute == 12) {
            argRec.originalReference = new long[count];
        }
        long[] oldArray = (long[])argRec.originalReference;
        for (int i = 0; i < count; ++i) {
            HListItem listItem = newList.getItem(i);
            if (listItem instanceof DoubleItem) {
                oldArray[i] = (long)((DoubleItem)listItem).getValue();
                continue;
            }
            RemoteObject.unexpectedType();
        }
    }

    private static void updateIntArray(HListItem item, ArgumentRecord argRec) throws ConnectException {
        HListInterface newList = ((ListItem)item).getValue();
        if (newList == null) {
            argRec.originalReference = null;
            return;
        }
        int count = newList.count();
        if (argRec.attribute == 12) {
            argRec.originalReference = new int[count];
        }
        int[] oldArray = (int[])argRec.originalReference;
        for (int i = 0; i < count; ++i) {
            HListItem listItem = newList.getItem(i);
            if (listItem instanceof DoubleItem) {
                oldArray[i] = (int)((DoubleItem)listItem).getValue();
                continue;
            }
            RemoteObject.unexpectedType();
        }
    }

    private static void updateShortArray(HListItem item, ArgumentRecord argRec) throws ConnectException {
        HListInterface newList = ((ListItem)item).getValue();
        if (newList == null) {
            argRec.originalReference = null;
            return;
        }
        int count = newList.count();
        if (argRec.attribute == 12) {
            argRec.originalReference = new short[count];
        }
        short[] oldArray = (short[])argRec.originalReference;
        for (int i = 0; i < count; ++i) {
            HListItem listItem = newList.getItem(i);
            if (listItem instanceof DoubleItem) {
                oldArray[i] = (short)((DoubleItem)listItem).getValue();
                continue;
            }
            RemoteObject.unexpectedType();
        }
    }

    private static void updateCharArray(HListItem item, ArgumentRecord argRec) throws ConnectException {
        HListInterface newList = ((ListItem)item).getValue();
        if (newList == null) {
            argRec.originalReference = null;
            return;
        }
        int count = newList.count();
        if (argRec.attribute == 12) {
            argRec.originalReference = new char[count];
        }
        char[] oldArray = (char[])argRec.originalReference;
        for (int i = 0; i < count; ++i) {
            HListItem listItem = newList.getItem(i);
            if (listItem instanceof DoubleItem) {
                oldArray[i] = (char)((DoubleItem)listItem).getValue();
                continue;
            }
            RemoteObject.unexpectedType();
        }
    }

    private static void updateByteArray(HListItem item, ArgumentRecord argRec) throws ConnectException {
        HListInterface newList = ((ListItem)item).getValue();
        if (newList == null) {
            argRec.originalReference = null;
            return;
        }
        int count = newList.count();
        if (argRec.attribute == 12) {
            argRec.originalReference = new byte[count];
        }
        byte[] oldArray = (byte[])argRec.originalReference;
        for (int i = 0; i < count; ++i) {
            HListItem listItem = newList.getItem(i);
            if (listItem instanceof DoubleItem) {
                oldArray[i] = (byte)((DoubleItem)listItem).getValue();
                continue;
            }
            RemoteObject.unexpectedType();
        }
    }

    private static void updateBooleanArray(HListItem item, ArgumentRecord argRec) throws ConnectException {
        HListInterface newList = ((ListItem)item).getValue();
        if (newList == null) {
            argRec.originalReference = null;
            return;
        }
        int count = newList.count();
        if (argRec.attribute == 12) {
            argRec.originalReference = new boolean[count];
        }
        boolean[] oldArray = (boolean[])argRec.originalReference;
        for (int i = 0; i < count; ++i) {
            HListItem listItem = newList.getItem(i);
            if (listItem instanceof DoubleItem) {
                oldArray[i] = ((DoubleItem)listItem).getValue() != 0.0;
                continue;
            }
            RemoteObject.unexpectedType();
        }
    }

    private void updateDoubleArray2D(HListItem item, ArgumentRecord argRec) throws ConnectException {
        if (this.SASVersion >= this.SASV8) {
            ArrayItem arrayItem = (ArrayItem)item;
            double[][] dou = (double[][])arrayItem.getValue();
            if (dou == null) {
                argRec.originalReference = null;
                return;
            }
            if (argRec.attribute == 12) {
                argRec.originalReference = dou;
            }
        } else {
            HListInterface newList = ((ListItem)item).getValue();
            if (newList == null) {
                argRec.originalReference = null;
                return;
            }
            int count = newList.count();
            if (argRec.attribute == 12) {
                argRec.originalReference = new double[count];
            }
            double[] oldArray = (double[])argRec.originalReference;
            for (int i = 0; i < count; ++i) {
                HListItem listItem = newList.getItem(i);
                if (listItem instanceof DoubleItem) {
                    oldArray[i] = ((DoubleItem)listItem).getValue();
                    continue;
                }
                RemoteObject.unexpectedType();
            }
        }
    }

    private void updateStringArray2D(HListItem item, ArgumentRecord argRec) throws ConnectException {
        if (this.SASVersion >= this.SASV8) {
            ArrayItem arrayItem = (ArrayItem)item;
            String[][] str = (String[][])arrayItem.getValue();
            if (str == null) {
                argRec.originalReference = null;
                return;
            }
            if (argRec.attribute == 12) {
                argRec.originalReference = str;
            }
        } else {
            HListInterface newList = ((ListItem)item).getValue();
            if (newList == null) {
                argRec.originalReference = null;
                return;
            }
            int count = newList.count();
            if (argRec.attribute == 12) {
                argRec.originalReference = new String[count];
            }
            String[] oldArray = (String[])argRec.originalReference;
            for (int i = 0; i < count; ++i) {
                HListItem listItem = newList.getItem(i);
                if (listItem instanceof StringItem) {
                    oldArray[i] = ((StringItem)listItem).getValue();
                    continue;
                }
                RemoteObject.unexpectedType();
            }
        }
    }

    private static void unexpectedType() throws ConnectException {
        String messageIndex = "RemObj.R04.ex.txt";
        String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
        String message = Message.format((String)messagePattern, (Object)messageIndex);
        throw new ConnectException(message);
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }
}

