/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.MissingValues;
import com.sas.collection.hlist.ArrayItem;
import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.ListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.RemoteObjectRB;
import com.sas.text.Message;

public class ArgumentRecord {
    public HListItem hListItem = null;
    public Object originalReference = null;
    public int originalType = 0;
    public double returnValue = 0.0;
    public int attribute = 0;
    public Object listVersion;
    public static int SASV8 = 35;
    private int SASVersion;

    protected ArgumentRecord(Object ref, int type, int attrib, int SASVersion) throws ConnectException {
        this(ref, 0.0, type, attrib, SASVersion);
    }

    protected ArgumentRecord(double val, int type, int attrib, int SASVersion) throws ConnectException {
        this(null, val, type, attrib, SASVersion);
    }

    private ArgumentRecord(Object ref, double val, int type, int attrib, int SVersion) throws ConnectException {
        this.originalReference = ref;
        this.originalType = type;
        this.attribute = attrib;
        this.SASVersion = SVersion;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.hListItem = new DoubleItem(val);
                break;
            }
            case 4: {
                this.hListItem = new StringItem((String)ref);
                break;
            }
            case 5: {
                this.hListItem = new DoubleItem((MissingValues)ref);
                break;
            }
            case 6: {
                this.hListItem = new ListItem((HListInterface)ref);
                break;
            }
            case 7: {
                this.hListItem = this.doubleArrayToList((double[])ref);
                break;
            }
            case 8: {
                this.hListItem = this.floatArrayToList((float[])ref);
                break;
            }
            case 9: {
                this.hListItem = this.longArrayToList((long[])ref);
                break;
            }
            case 10: {
                this.hListItem = this.intArrayToList((int[])ref);
                break;
            }
            case 12: {
                this.hListItem = this.shortArrayToList((short[])ref);
                break;
            }
            case 13: {
                this.hListItem = this.charArrayToList((char[])ref);
                break;
            }
            case 14: {
                this.hListItem = this.byteArrayToList((byte[])ref);
                break;
            }
            case 15: {
                this.hListItem = this.booleanArrayToList((boolean[])ref);
                break;
            }
            case 11: {
                this.hListItem = this.stringArrayToList((String[])ref);
                break;
            }
            case 20: {
                this.hListItem = this.doubleArray2DToList((double[][])ref);
                break;
            }
            case 21: {
                this.hListItem = this.floatArray2DToList((float[][])ref);
                break;
            }
            case 22: {
                this.hListItem = this.longArray2DToList((long[][])ref);
                break;
            }
            case 23: {
                this.hListItem = this.intArray2DToList((int[][])ref);
                break;
            }
            case 25: {
                this.hListItem = this.shortArray2DToList((short[][])ref);
                break;
            }
            case 26: {
                this.hListItem = this.charArray2DToList((char[][])ref);
                break;
            }
            case 27: {
                this.hListItem = this.byteArray2DToList((byte[][])ref);
                break;
            }
            case 28: {
                this.hListItem = this.booleanArray2DToList((boolean[][])ref);
                break;
            }
            case 24: {
                this.hListItem = this.stringArray2DToList((String[][])ref);
            }
        }
    }

    private HListItem doubleArrayToList(double[] arr) {
        if (this.SASVersion >= SASV8) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        HList list = null;
        if (arr != null) {
            list = new HList();
            for (int i = 0; i < arr.length; ++i) {
                list.add((Object)new DoubleItem(arr[i]));
            }
        }
        return new ListItem((HListInterface)list);
    }

    private HListItem floatArrayToList(float[] arr) {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        HList list = null;
        if (arr != null) {
            list = new HList();
            for (int i = 0; i < arr.length; ++i) {
                list.add((Object)new DoubleItem((double)arr[i]));
            }
        }
        return new ListItem((HListInterface)list);
    }

    private HListItem longArrayToList(long[] arr) {
        HList list = null;
        if (arr != null) {
            list = new HList();
            for (int i = 0; i < arr.length; ++i) {
                list.add((Object)new DoubleItem((double)arr[i]));
            }
        }
        return new ListItem((HListInterface)list);
    }

    private HListItem intArrayToList(int[] arr) {
        HList list = null;
        if (arr != null) {
            list = new HList();
            for (int i = 0; i < arr.length; ++i) {
                list.add((Object)new DoubleItem((double)arr[i]));
            }
        }
        return new ListItem((HListInterface)list);
    }

    private HListItem shortArrayToList(short[] arr) {
        HList list = null;
        if (arr != null) {
            list = new HList();
            for (int i = 0; i < arr.length; ++i) {
                list.add((Object)new DoubleItem((double)arr[i]));
            }
        }
        return new ListItem((HListInterface)list);
    }

    private HListItem charArrayToList(char[] arr) {
        HList list = null;
        if (arr != null) {
            list = new HList();
            for (int i = 0; i < arr.length; ++i) {
                list.add((Object)new DoubleItem((double)arr[i]));
            }
        }
        return new ListItem((HListInterface)list);
    }

    private HListItem byteArrayToList(byte[] arr) {
        HList list = null;
        if (arr != null) {
            list = new HList();
            for (int i = 0; i < arr.length; ++i) {
                list.add((Object)new DoubleItem((double)arr[i]));
            }
        }
        return new ListItem((HListInterface)list);
    }

    private HListItem booleanArrayToList(boolean[] arr) {
        HList list = null;
        if (arr != null) {
            list = new HList();
            for (int i = 0; i < arr.length; ++i) {
                list.add((Object)new DoubleItem(arr[i] ? 1.0 : 0.0));
            }
        }
        return new ListItem((HListInterface)list);
    }

    private HListItem stringArrayToList(String[] arr) {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        HList list = null;
        if (arr != null) {
            list = new HList();
            for (int i = 0; i < arr.length; ++i) {
                list.add((Object)new StringItem(arr[i]));
            }
        }
        return new ListItem((HListInterface)list);
    }

    private HListItem doubleArray2DToList(double[][] arr) throws ConnectException {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        throw this.no2dArrays();
    }

    private HListItem floatArray2DToList(float[][] arr) throws ConnectException {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        throw this.no2dArrays();
    }

    private HListItem longArray2DToList(long[][] arr) throws ConnectException {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        throw this.no2dArrays();
    }

    private HListItem intArray2DToList(int[][] arr) throws ConnectException {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        throw this.no2dArrays();
    }

    private HListItem shortArray2DToList(short[][] arr) throws ConnectException {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        throw this.no2dArrays();
    }

    private HListItem charArray2DToList(char[][] arr) throws ConnectException {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        throw this.no2dArrays();
    }

    private HListItem byteArray2DToList(byte[][] arr) throws ConnectException {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        throw this.no2dArrays();
    }

    private HListItem booleanArray2DToList(boolean[][] arr) throws ConnectException {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        throw this.no2dArrays();
    }

    private HListItem stringArray2DToList(String[][] arr) throws ConnectException {
        if (this.SASVersion >= 35) {
            ArrayItem arrayItem = null;
            arrayItem = arr == null ? new ArrayItem() : new ArrayItem((Object)arr);
            return arrayItem;
        }
        throw this.no2dArrays();
    }

    private ConnectException no2dArrays() {
        String messageIndex = "RemObj.R76.ex.txt";
        String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
        String message = Message.format((String)messagePattern, (Object)messageIndex);
        return new ConnectException(message);
    }
}

