/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net;

import com.sas.ComponentException;
import com.sas.net.AppletResourceLocator;
import com.sas.net.BaseResourceLocator;
import com.sas.net.ClassResourceLocator;
import com.sas.net.ContextResourceLocator;
import com.sas.net.FileResourceLocator;
import com.sas.net.RB;
import com.sas.net.ResourceLocatorInterface;
import com.sas.swing.property.PropertyEditorHost;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.ResourceCopier;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ResourceLocatorInterfaceCustomizerPanel
extends SwingCustomizerPanel
implements ActionListener,
FocusListener,
PropertyChangeListener {
    public static final String RB_KEY = "ResourceLocatorInterfaceCustomizerPanel.";
    ResourceLocatorInterface resourceLocator;
    public JPanel firstColumn;
    public JPanel secondColumn;
    protected boolean shouldCopy;
    protected boolean promptForCopy;
    protected boolean promptForReplace;
    protected int pathTypeOptions;
    JLabel pathTypeLabel;
    JLabel resourcePathLabel;
    JLabel classLabel;
    JLabel contextLabel;
    JTextField source;
    JTextField context;
    JButton sourceButton;
    JComboBox pathType;
    Class relativeClass;
    DefaultComboBoxModel pathTypeModel;
    FileFilter fileDialogFilter;
    PropertyEditorHost relativeClassHost;
    boolean settingSource = false;
    boolean pathTypeAction = false;
    private boolean isWebEIS = false;
    static String prevDirectory;
    String useContext;
    String useDocumentRelative;
    String useAppletRelative;
    String useClassRelative;
    String useAbsolutePath;
    String useURL;
    public static final int APPLET_RELATIVE = 1;
    public static final int URL = 2;
    public static final int ABSOLUTE = 4;
    public static final int DOCUMENT_RELATIVE = 8;
    public static final int CLASS_RELATIVE = 16;
    private static final int CONTEXT = 32;
    public static final int WEBAF = 23;
    public static final int WEBEIS = 14;
    public static final int WEBAFDEV = 17;

    public ResourceLocatorInterfaceCustomizerPanel(String tabName) {
        super(tabName);
        this.setDefaultValues();
    }

    public ResourceLocatorInterfaceCustomizerPanel() {
        this("");
    }

    public void setPathTypeOptions(int mode) {
        this.pathTypeModel.removeAllElements();
        this.pathTypeOptions = mode;
        if ((mode & 1) != 0) {
            this.pathTypeModel.addElement(this.useAppletRelative);
        }
        if ((mode & 2) != 0) {
            this.pathTypeModel.addElement(this.useURL);
        }
        if ((mode & 4) != 0) {
            this.pathTypeModel.addElement(this.useAbsolutePath);
        }
        if ((mode & 8) != 0) {
            this.pathTypeModel.addElement(this.useDocumentRelative);
        }
        if ((mode & 0x10) != 0) {
            this.pathTypeModel.addElement(this.useClassRelative);
        }
        if ((mode & 0x20) != 0) {
            this.pathTypeModel.addElement(this.useContext);
        }
    }

    public int getPathTypeOptions() {
        return this.pathTypeOptions;
    }

    protected void browseAction(JTextField comp) {
        int returnVal;
        Frame parentFrame = Util.getParentAWTFrame((Component)this);
        File fileSelect = null;
        try {
            String path = comp.getText();
            if (path != null && path.startsWith("file:")) {
                path = path.substring(6);
            }
            if (path != null && path.length() > 0 && this.resourceLocator instanceof AppletResourceLocator) {
                path = ((AppletResourceLocator)this.resourceLocator).getAbsolutePath();
            }
            if ((fileSelect = new File(path)).getParent() != null) {
                prevDirectory = fileSelect.getParent();
            }
        }
        catch (NullPointerException e) {
            prevDirectory = null;
        }
        if (this.resourceLocator instanceof AppletResourceLocator && prevDirectory == null) {
            prevDirectory = ((AppletResourceLocator)this.resourceLocator).getProjectDirectory();
        }
        if (prevDirectory == null) {
            prevDirectory = ((BaseResourceLocator)this.resourceLocator).getProjectDirectory();
        }
        JFileChooser openPicture = new JFileChooser(prevDirectory);
        openPicture.setAcceptAllFileFilterUsed(false);
        openPicture.setFileFilter(this.fileDialogFilter);
        if (fileSelect != null) {
            openPicture.setSelectedFile(fileSelect);
        }
        if ((returnVal = parentFrame != null ? openPicture.showOpenDialog(parentFrame) : openPicture.showOpenDialog(new JFrame())) == 0) {
            prevDirectory = openPicture.getCurrentDirectory().getAbsolutePath();
            comp.setText(openPicture.getSelectedFile().getAbsolutePath());
            this.sourceChange(comp.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object eSource = e.getSource();
        if (eSource == this.sourceButton) {
            this.browseAction(this.source);
        } else if (eSource == this.source && !this.settingSource) {
            this.sourceChange(this.source.getText());
        } else if (eSource == this.pathType && !this.pathTypeAction) {
            try {
                this.pathTypeAction = true;
                String selectedItem = (String)this.pathType.getSelectedItem();
                if (selectedItem == null) {
                    return;
                }
                URL url = null;
                try {
                    url = this.resourceLocator.getResource();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.sourceButton.setVisible(true);
                this.sourceButton.setEnabled(true);
                this.classLabel.setVisible(false);
                this.relativeClassHost.setVisible(false);
                if (this.relativeClassHost.getPropertyEditor() != null) {
                    this.relativeClassHost.getPropertyEditor().removePropertyChangeListener(this);
                    this.relativeClassHost.getPropertyEditor().setValue(null);
                }
                this.contextLabel.setVisible(false);
                this.context.setVisible(false);
                ResourceLocatorInterface oldValue = this.resourceLocator;
                String resourceName = this.resourceLocator.getResourceName();
                if (selectedItem.equals(this.useClassRelative)) {
                    this.sourceButton.setVisible(false);
                    this.classLabel.setVisible(true);
                    this.relativeClassHost.setVisible(true);
                    Class<?> relClass = null;
                    if (this.resourceLocator instanceof AppletResourceLocator) {
                        if (((AppletResourceLocator)this.resourceLocator).getApplet() != null) {
                            relClass = ((AppletResourceLocator)this.resourceLocator).getApplet().getClass();
                        }
                    } else if (this.resourceLocator instanceof ContextResourceLocator || this.resourceLocator instanceof FileResourceLocator || this.resourceLocator instanceof BaseResourceLocator) {
                        // empty if block
                    }
                    this.resourceLocator = new ClassResourceLocator("");
                    if (relClass != null) {
                        ((ClassResourceLocator)this.resourceLocator).setRelativeClass(relClass);
                    }
                    try {
                        this.relativeClassHost.setProperty((Object)this.resourceLocator, "relativeClass");
                    }
                    catch (IntrospectionException introspectionException) {
                        // empty catch block
                    }
                    if (this.relativeClassHost.getPropertyEditor() != null) {
                        this.relativeClassHost.getPropertyEditor().addPropertyChangeListener(this);
                    }
                } else if (selectedItem.equals(this.useAppletRelative)) {
                    if (this.resourceLocator instanceof AppletResourceLocator) {
                        ((AppletResourceLocator)this.resourceLocator).setDocumentBaseRelative(false);
                    } else if (this.resourceLocator instanceof ContextResourceLocator) {
                        this.resourceLocator = new AppletResourceLocator();
                    } else if (this.resourceLocator instanceof FileResourceLocator) {
                        this.resourceLocator = new AppletResourceLocator();
                        if (!this.sourceChange(resourceName, this.useAppletRelative)) {
                            this.resourceLocator = oldValue;
                            this.setPathSelection();
                        }
                    } else if (this.resourceLocator instanceof ClassResourceLocator) {
                        this.resourceLocator = new AppletResourceLocator();
                    } else if (this.resourceLocator instanceof BaseResourceLocator) {
                        this.resourceLocator = new AppletResourceLocator();
                        String oldResourceName = resourceName;
                        if (!this.sourceChange(resourceName = this.stripFileHeaderFromURL(resourceName), this.useAppletRelative)) {
                            this.resourceLocator = oldValue;
                            this.setPathSelection();
                        }
                    }
                } else if (selectedItem.equals(this.useDocumentRelative)) {
                    this.sourceButton.setEnabled(false);
                    if (!(this.resourceLocator instanceof AppletResourceLocator)) {
                        if (this.resourceLocator instanceof ContextResourceLocator) {
                            this.resourceLocator = new AppletResourceLocator();
                            ((AppletResourceLocator)this.resourceLocator).setDocumentBaseRelative(true);
                        } else if (this.resourceLocator instanceof FileResourceLocator) {
                            this.resourceLocator = new AppletResourceLocator();
                            ((AppletResourceLocator)this.resourceLocator).setDocumentBaseRelative(true);
                            String oldResourceName = resourceName;
                            resourceName = this.replaceSlashes(resourceName);
                            if (!this.sourceChange(resourceName, this.useDocumentRelative)) {
                                this.resourceLocator = oldValue;
                                this.setPathSelection();
                            }
                        } else if (this.resourceLocator instanceof ClassResourceLocator) {
                            this.resourceLocator = new AppletResourceLocator();
                            ((AppletResourceLocator)this.resourceLocator).setDocumentBaseRelative(true);
                        } else if (this.resourceLocator instanceof BaseResourceLocator) {
                            this.resourceLocator = new AppletResourceLocator();
                            ((AppletResourceLocator)this.resourceLocator).setDocumentBaseRelative(true);
                            String oldResourceName = resourceName;
                            resourceName = this.stripFileHeaderFromURL(resourceName);
                            resourceName = this.replaceSlashes(resourceName);
                            if (!this.sourceChange(resourceName, this.useDocumentRelative)) {
                                this.resourceLocator = oldValue;
                                this.setPathSelection();
                            }
                        }
                    }
                    ((AppletResourceLocator)this.resourceLocator).setDocumentBaseRelative(true);
                } else if (selectedItem.equals(this.useAbsolutePath)) {
                    if (url != null) {
                        resourceName = url.toString();
                    }
                    if (this.resourceLocator instanceof AppletResourceLocator) {
                        if (url != null || resourceName != null && resourceName.indexOf(":") == -1) {
                            resourceName = ((AppletResourceLocator)this.resourceLocator).getAbsolutePath();
                        }
                    } else if (this.resourceLocator instanceof ContextResourceLocator || this.resourceLocator instanceof ClassResourceLocator || this.resourceLocator instanceof BaseResourceLocator) {
                        // empty if block
                    }
                    if (resourceName != null && resourceName.startsWith("file:")) {
                        resourceName = this.stripFileHeaderFromURL(resourceName);
                    }
                    this.resourceLocator = new FileResourceLocator(resourceName);
                } else if (selectedItem.equals(this.useURL)) {
                    if (this.isWebEIS) {
                        this.sourceButton.setEnabled(false);
                    }
                    if (this.resourceLocator instanceof AppletResourceLocator && (url != null || resourceName != null && resourceName.indexOf(":") == -1)) {
                        resourceName = ((AppletResourceLocator)this.resourceLocator).getAbsolutePath();
                    }
                    this.resourceLocator = new BaseResourceLocator();
                    if (url != null) {
                        this.resourceLocator.setResourceName(url.toString());
                        if (this.resourceLocator.getResourceName().startsWith("file:")) {
                            this.showFileURLWarning();
                        }
                    } else {
                        this.sourceChange(resourceName);
                    }
                } else if (selectedItem.equals(this.useContext)) {
                    this.contextLabel.setVisible(true);
                    this.context.setVisible(true);
                    this.sourceButton.setVisible(false);
                    this.resourceLocator = new ContextResourceLocator(resourceName);
                    try {
                        ((ContextResourceLocator)this.resourceLocator).setContext(new URL(this.context.getText()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                this.firePropertyChange("resourceLocator", oldValue, this.resourceLocator);
                this.source.setText(this.resourceLocator.getResourceName());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!ResourceLocatorInterfaceCustomizerPanel.this.pathType.isPopupVisible()) {
                            ResourceLocatorInterfaceCustomizerPanel.this.source.requestFocus();
                        }
                        ResourceLocatorInterfaceCustomizerPanel.this.source.selectAll();
                        ResourceLocatorInterfaceCustomizerPanel.this.getLayout().layoutContainer(ResourceLocatorInterfaceCustomizerPanel.this);
                        ResourceLocatorInterfaceCustomizerPanel.this.revalidate();
                        ResourceLocatorInterfaceCustomizerPanel.this.repaint();
                    }
                });
            }
            finally {
                this.pathTypeAction = false;
            }
        }
    }

    private void setPathSelection() {
        if (this.resourceLocator instanceof ClassResourceLocator) {
            this.pathType.setSelectedItem(this.useClassRelative);
        } else if (this.resourceLocator instanceof AppletResourceLocator) {
            if (((AppletResourceLocator)this.resourceLocator).isDocumentBaseRelative()) {
                this.pathType.setSelectedItem(this.useDocumentRelative);
            } else {
                this.pathType.setSelectedItem(this.useAppletRelative);
            }
        } else if (this.resourceLocator instanceof ContextResourceLocator) {
            this.pathType.setSelectedItem(this.useContext);
        } else if (this.resourceLocator instanceof FileResourceLocator) {
            this.pathType.setSelectedItem(this.useAbsolutePath);
        } else if (this.resourceLocator instanceof BaseResourceLocator) {
            this.pathType.setSelectedItem(this.useURL);
        }
    }

    private void showFileURLWarning() {
        final ResourceLocatorInterfaceCustomizerPanel panel = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(panel, RB.getStringResource((String)ResourceLocatorInterfaceCustomizerPanel.RB_KEY, (String)"fileURLWarningText.txt"), RB.getStringResource((String)ResourceLocatorInterfaceCustomizerPanel.RB_KEY, (String)"fileURLWarningTitle.txt"), 2, null);
            }
        });
        this.source.revalidate();
        this.source.update(this.source.getGraphics());
    }

    private String stripFileHeaderFromURL(String file) {
        if (file == null) {
            return null;
        }
        if (file.startsWith("file:")) {
            file = file.substring(6);
        }
        return file;
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object eSource = e.getSource();
        if (eSource == this.source && !this.settingSource) {
            this.sourceChange(this.source.getText());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    protected boolean sourceChange(String src) {
        return this.sourceChange(src, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sourceChange(String src, String typeDesired) {
        boolean cancel = false;
        try {
            this.settingSource = true;
            String oldValue = this.resourceLocator.getResourceName();
            if (src != null) {
                src = src.trim();
            }
            if (src == null || src.length() == 0) {
                this.resourceLocator.setResourceName(null);
            } else if (!src.equals(this.resourceLocator.getResourceName())) {
                String oldSrc = this.resourceLocator.getResourceName();
                String selectedItem = (String)this.pathType.getSelectedItem();
                if (selectedItem == this.useDocumentRelative || selectedItem == this.useAppletRelative) {
                    File temp = new File(src = this.replaceSlashes(src));
                    if (temp.getAbsolutePath().toUpperCase().indexOf(src.toUpperCase()) != 0) {
                        this.resourceLocator.setResourceName(src);
                        this.source.setText(src);
                    } else {
                        String destDir = this.getProjectDirectory();
                        if (src.toUpperCase().startsWith(destDir.toUpperCase())) {
                            int index = destDir.length();
                            this.source.setText(src.substring(index));
                            this.resourceLocator.setResourceName(src.substring(index));
                        } else if (this.shouldCopy) {
                            ResourceCopier copier = new ResourceCopier();
                            copier.setPromptForCopy(this.promptForCopy);
                            copier.setPromptForReplace(this.promptForReplace);
                            copier.setDestinationDir(destDir);
                            File copiedFile = copier.copyFile(src);
                            if (selectedItem == this.useDocumentRelative) {
                                if (copiedFile != null) {
                                    this.resourceLocator.setResourceName(copiedFile.getName());
                                    this.source.setText(copiedFile.getName());
                                } else {
                                    this.resourceLocator.setResourceName(oldSrc);
                                    this.source.setText(oldSrc);
                                }
                            } else if (copiedFile != null) {
                                if (!copiedFile.getAbsolutePath().toUpperCase().startsWith(destDir.toUpperCase())) {
                                    if (typeDesired != null) {
                                        this.pathType.setSelectedItem(typeDesired);
                                    } else {
                                        this.pathType.setSelectedItem(this.useAbsolutePath);
                                        this.resourceLocator.setResourceName(copiedFile.toString());
                                        this.source.setText(copiedFile.toString());
                                    }
                                } else {
                                    this.resourceLocator.setResourceName(copiedFile.getName());
                                    this.source.setText(copiedFile.getName());
                                }
                            } else {
                                this.resourceLocator.setResourceName(oldSrc);
                                this.source.setText(oldSrc);
                                cancel = true;
                            }
                        } else {
                            this.resourceLocator.setResourceName(src);
                            this.source.setText(src);
                        }
                    }
                } else if (selectedItem == this.useAbsolutePath) {
                    File temp = new File(src = this.replaceSlashes(src));
                    if (temp.getAbsolutePath().toUpperCase().indexOf(src.toUpperCase()) != 0) {
                        String path = "";
                        AppletResourceLocator frl = new AppletResourceLocator(src);
                        path = frl.getAbsolutePath();
                        this.resourceLocator.setResourceName(path);
                        this.source.setText(path);
                    } else {
                        this.resourceLocator.setResourceName(src);
                    }
                    this.source.setText(src);
                } else if (selectedItem == this.useURL) {
                    File tempFile = new File(src);
                    if (tempFile.exists()) {
                        try {
                            this.resourceLocator.setResourceName(tempFile.toURL().toString());
                        }
                        catch (MalformedURLException ex) {
                            if (src != null && src.length() != 0) {
                                src = src.replace('\\', '/');
                            }
                            this.resourceLocator.setResourceName(src);
                        }
                    } else {
                        if (src != null && src.length() != 0) {
                            src = src.replace('\\', '/');
                        }
                        this.resourceLocator.setResourceName(src);
                    }
                    try {
                        this.source.setText(this.resourceLocator.getResource().toString());
                        if (this.source.getText() != null && this.source.getText().startsWith("file:")) {
                            this.showFileURLWarning();
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else if (selectedItem == this.useClassRelative) {
                    this.resourceLocator.setResourceName(src);
                } else if (selectedItem == this.useContext) {
                    this.resourceLocator.setResourceName(src);
                }
            }
            this.settingSource = false;
            return !cancel;
        }
        catch (Throwable throwable) {
            this.settingSource = false;
            return !cancel;
        }
    }

    private String getProjectDirectory() {
        String destDir = null;
        if (this.resourceLocator instanceof AppletResourceLocator && ((AppletResourceLocator)this.resourceLocator).getApplet() != null) {
            destDir = ((AppletResourceLocator)this.resourceLocator).getProjectDirectory();
        } else {
            ResourceCopier copier = new ResourceCopier();
            copier.setPromptForCopy(this.promptForCopy);
            copier.setPromptForReplace(this.promptForReplace);
            destDir = copier.getDestinationDir();
        }
        if (!destDir.endsWith(File.separator)) {
            destDir = destDir + File.separator;
        }
        destDir = this.replaceSlashes(destDir);
        return destDir;
    }

    private String replaceSlashes(String src) {
        if (src == null) {
            return null;
        }
        src = com.sas.util.Util.equal((Object)File.separator, (Object)"\\") ? src.replace('/', '\\') : src.replace('\\', '/');
        return src;
    }

    public void setDefaultValues() {
        this.useClassRelative = RB.getStringResource((String)RB_KEY, (String)"useClassRelative.txt");
        this.useAbsolutePath = RB.getStringResource((String)RB_KEY, (String)"useAbsolutePath.txt");
        this.useAppletRelative = RB.getStringResource((String)RB_KEY, (String)"useAppletRelative.txt");
        this.useURL = RB.getStringResource((String)RB_KEY, (String)"useURL.txt");
        this.useDocumentRelative = RB.getStringResource((String)RB_KEY, (String)"useRelativeDocument.txt");
        this.useContext = RB.getStringResource((String)RB_KEY, (String)"useContextRelative.txt");
        this.shouldCopy = true;
        this.promptForCopy = true;
        this.promptForReplace = true;
        this.fileDialogFilter = new ImageFilter();
        this.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 0, 0, true, false, true));
        this.add(this.makeSettingsContainer());
    }

    protected Container makeSettingsContainer() {
        JPanel settings = new JPanel();
        JPanel sourceContainer = new JPanel();
        JPanel contextContainer = new JPanel();
        this.firstColumn = new JPanel();
        this.secondColumn = new JPanel();
        this.pathTypeLabel = new JLabel();
        this.classLabel = new JLabel(RB.getStringResource((String)RB_KEY, (String)"defaultClassLabel.txt"));
        this.contextLabel = new JLabel(RB.getStringResource((String)RB_KEY, (String)"defaultContextLabel.txt"));
        this.resourcePathLabel = new JLabel();
        this.source = new JTextField();
        this.resourcePathLabel.setLabelFor(this.source);
        this.sourceButton = new JButton();
        this.pathType = new JComboBox();
        this.relativeClassHost = new PropertyEditorHost();
        this.classLabel.setLabelFor(this.relativeClassHost);
        this.pathTypeModel = new DefaultComboBoxModel();
        this.context = new JTextField();
        this.contextLabel.setLabelFor(this.context);
        this.pathType.setEditable(false);
        this.pathType.setLightWeightPopupEnabled(false);
        AutoSizingGridLayout layout1 = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        layout1.setIgnoreSizeOfNonVisibleComponents(true);
        layout1.setRemainderColumn(2);
        settings.setLayout((LayoutManager)layout1);
        AutoSizingGridLayout layout2 = new AutoSizingGridLayout(4, 1, 0, 5, true, true, true);
        AutoSizingGridLayout layout3 = new AutoSizingGridLayout(4, 1, 0, 5, true, true, true);
        layout2.setIgnoreSizeOfNonVisibleComponents(true);
        layout3.setIgnoreSizeOfNonVisibleComponents(true);
        this.firstColumn.setLayout((LayoutManager)layout2);
        this.secondColumn.setLayout((LayoutManager)layout3);
        this.pathTypeLabel.setText(RB.getStringResource((String)RB_KEY, (String)"resourcePathTypeLabel.txt"));
        this.pathType.setModel(this.pathTypeModel);
        this.pathTypeModel.addElement(this.useAppletRelative);
        this.pathTypeModel.addElement(this.useURL);
        this.pathTypeModel.addElement(this.useAbsolutePath);
        this.pathTypeModel.addElement(this.useClassRelative);
        this.pathTypeLabel.setLabelFor(this.pathType);
        AutoSizingGridLayout layout5 = new AutoSizingGridLayout(1, 1, 3, 0, true, false, true);
        layout5.setIgnoreSizeOfNonVisibleComponents(true);
        layout5.setRemainderColumn(1);
        contextContainer.setLayout((LayoutManager)layout5);
        this.context.setColumns(20);
        this.context.setEditable(false);
        contextContainer.add(this.context);
        AutoSizingGridLayout layout4 = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
        layout4.setIgnoreSizeOfNonVisibleComponents(true);
        layout4.setRemainderColumn(1);
        sourceContainer.setLayout((LayoutManager)layout4);
        this.resourcePathLabel.setText(RB.getStringResource((String)RB_KEY, (String)"resourcePathLabel.txt"));
        this.sourceButton.setMargin(new Insets(0, 2, 0, 2));
        this.sourceButton.setText("...");
        this.source.setColumns(20);
        sourceContainer.add(this.source);
        sourceContainer.add(this.sourceButton);
        JPanel cont11 = new JPanel();
        AutoSizingGridLayout layout11 = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
        layout11.setIgnoreSizeOfNonVisibleComponents(true);
        cont11.setLayout((LayoutManager)layout11);
        cont11.add(this.pathTypeLabel);
        JPanel cont12 = new JPanel();
        AutoSizingGridLayout layout12 = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
        layout12.setIgnoreSizeOfNonVisibleComponents(true);
        cont12.setLayout((LayoutManager)layout12);
        cont12.add(this.pathType);
        layout11.setInterlockedRowContainer((Container)cont12);
        layout12.setInterlockedRowContainer((Container)cont11);
        JPanel cont21 = new JPanel();
        AutoSizingGridLayout layout21 = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
        layout21.setIgnoreSizeOfNonVisibleComponents(true);
        cont21.setLayout((LayoutManager)layout21);
        cont21.add(this.classLabel);
        JPanel cont22 = new JPanel();
        AutoSizingGridLayout layout22 = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
        layout22.setIgnoreSizeOfNonVisibleComponents(true);
        cont22.setLayout((LayoutManager)layout22);
        cont22.add(this.relativeClassHost);
        layout21.setInterlockedRowContainer((Container)cont22);
        layout22.setInterlockedRowContainer((Container)cont21);
        JPanel cont31 = new JPanel();
        AutoSizingGridLayout layout31 = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
        layout31.setIgnoreSizeOfNonVisibleComponents(true);
        cont31.setLayout((LayoutManager)layout31);
        cont31.add(this.contextLabel);
        JPanel cont32 = new JPanel();
        AutoSizingGridLayout layout32 = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
        layout32.setIgnoreSizeOfNonVisibleComponents(true);
        cont32.setLayout((LayoutManager)layout32);
        cont32.add(contextContainer);
        layout31.setInterlockedRowContainer((Container)cont32);
        layout32.setInterlockedRowContainer((Container)cont31);
        JPanel cont41 = new JPanel();
        AutoSizingGridLayout layout41 = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
        layout41.setIgnoreSizeOfNonVisibleComponents(true);
        cont41.setLayout((LayoutManager)layout41);
        cont41.add(this.resourcePathLabel);
        JPanel cont42 = new JPanel();
        AutoSizingGridLayout layout42 = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
        layout42.setIgnoreSizeOfNonVisibleComponents(true);
        cont42.setLayout((LayoutManager)layout42);
        cont42.add(sourceContainer);
        layout41.setInterlockedRowContainer((Container)cont42);
        layout42.setInterlockedRowContainer((Container)cont41);
        this.firstColumn.add(cont11);
        this.firstColumn.add(cont21);
        this.firstColumn.add(cont31);
        this.firstColumn.add(cont41);
        this.secondColumn.add(cont12);
        this.secondColumn.add(cont22);
        this.secondColumn.add(cont32);
        this.secondColumn.add(cont42);
        layout2.setInterlockedRowContainers(new Container[]{this.pathType, this.relativeClassHost, contextContainer, sourceContainer});
        layout3.setInterlockedRowContainers(new Container[]{this.pathTypeLabel, this.classLabel, this.contextLabel, this.resourcePathLabel});
        settings.add(this.firstColumn);
        settings.add(this.secondColumn);
        return settings;
    }

    public void setPathTypeLabel(String newValue) {
        this.pathTypeLabel.setText(newValue);
    }

    public void setResourcePathLabel(String newValue) {
        this.resourcePathLabel.setText(newValue);
    }

    public Container getFirstColumn() {
        return this.firstColumn;
    }

    public Container getSecondColumn() {
        return this.secondColumn;
    }

    public ResourceLocatorInterface getResourceLocatorInterface() {
        return this.resourceLocator;
    }

    public void setFileDialogFilter(FileFilter newValue) {
        if (!com.sas.util.Util.equal((Object)this.fileDialogFilter, (Object)newValue)) {
            FileFilter oldValue = this.fileDialogFilter;
            this.fileDialogFilter = newValue;
            this.firePropertyChange("fileDialogFilter", oldValue, newValue);
        }
    }

    public FileFilter getFileDialogFilter() {
        return this.fileDialogFilter;
    }

    public void setPromptForCopy(boolean newValue) {
        this.promptForCopy = newValue;
    }

    public void setPromptForReplace(boolean newValue) {
        this.promptForReplace = newValue;
    }

    public void setShouldCopy(boolean newValue) {
        this.shouldCopy = newValue;
    }

    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        if (bean instanceof ResourceLocatorInterface) {
            this.resourceLocator = (ResourceLocatorInterface)bean;
            if (this.resourceLocator instanceof BaseResourceLocator) {
                BaseResourceLocator cfr_ignored_0 = (BaseResourceLocator)this.resourceLocator;
                if (((BaseResourceLocator)this.resourceLocator).getMode() == 2) {
                    this.isWebEIS = true;
                    this.setPathTypeOptions(14);
                    this.setShouldCopy(false);
                }
            } else {
                this.isWebEIS = false;
            }
            try {
                String contextString = null;
                BaseResourceLocator cfr_ignored_1 = (BaseResourceLocator)this.resourceLocator;
                if (((BaseResourceLocator)this.resourceLocator).getMode() == 1) {
                    contextString = System.getProperty("webaf.context");
                    if (contextString != null) {
                        this.pathTypeModel.addElement(this.useContext);
                        this.context.setText(contextString);
                    }
                } else {
                    BaseResourceLocator cfr_ignored_2 = (BaseResourceLocator)this.resourceLocator;
                    if (((BaseResourceLocator)this.resourceLocator).getMode() == 2 && (contextString = System.getProperty("webeis.context")) != null) {
                        this.pathTypeModel.addElement(this.useContext);
                        this.context.setText(contextString);
                    }
                }
            }
            catch (Exception contextString) {
                // empty catch block
            }
            this.source.setText(this.resourceLocator.getResourceName());
            this.classLabel.setVisible(false);
            this.relativeClassHost.setVisible(false);
            this.contextLabel.setVisible(false);
            this.context.setVisible(false);
            this.relativeClass = null;
            if ((this.getPathTypeOptions() & 1) != 0) {
                this.pathType.setSelectedItem(this.useAppletRelative);
            } else if ((this.getPathTypeOptions() & 8) != 0) {
                this.pathType.setSelectedItem(this.useDocumentRelative);
            }
            if (this.resourceLocator instanceof ClassResourceLocator) {
                this.relativeClass = ((ClassResourceLocator)this.resourceLocator).getRelativeClass();
                this.pathType.setSelectedItem(this.useClassRelative);
                this.classLabel.setVisible(true);
                this.relativeClassHost.setVisible(true);
                this.sourceButton.setVisible(false);
                try {
                    this.relativeClassHost.setProperty((Object)this.resourceLocator, "relativeClass");
                }
                catch (IntrospectionException contextString) {
                    // empty catch block
                }
                if (this.relativeClassHost.getPropertyEditor() != null) {
                    this.relativeClassHost.getPropertyEditor().addPropertyChangeListener(this);
                }
            } else if (this.resourceLocator instanceof AppletResourceLocator) {
                if (((AppletResourceLocator)this.resourceLocator).isDocumentBaseRelative()) {
                    this.sourceButton.setEnabled(false);
                    this.pathType.setSelectedItem(this.useDocumentRelative);
                } else {
                    this.pathType.setSelectedItem(this.useAppletRelative);
                }
            } else if (this.resourceLocator instanceof ContextResourceLocator) {
                if ((this.getPathTypeOptions() & 0x20) != 0) {
                    this.pathTypeModel.addElement(this.useContext);
                }
                this.pathType.setSelectedItem(this.useContext);
                this.contextLabel.setVisible(true);
                this.context.setVisible(true);
                this.sourceButton.setVisible(false);
                if (((ContextResourceLocator)this.resourceLocator).getContext() != null) {
                    this.context.setText(((ContextResourceLocator)this.resourceLocator).getContext().toString());
                }
            } else if (this.resourceLocator instanceof FileResourceLocator) {
                this.pathType.setSelectedItem(this.useAbsolutePath);
            } else if (this.resourceLocator instanceof BaseResourceLocator) {
                this.pathType.setSelectedItem(this.useURL);
                if (this.isWebEIS) {
                    this.sourceButton.setEnabled(false);
                }
            }
        } else {
            Message exceptionMessage = new Message(com.sas.util.Util.getCommonResources(), "Customizer.setObject.ex.txt", (Object)"ResourceLocatorInterfaceCustomizerPanel", (Object)"com.sas.net.ResourceLocatorInterface");
            throw new ComponentException(exceptionMessage.toString());
        }
        this.addLinks();
    }

    public void addLinks() {
        this.pathType.addActionListener(this);
        this.sourceButton.addActionListener(this);
        this.source.addFocusListener(this);
        this.source.addActionListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PropertyEditor relativeClassEditor = this.relativeClassHost.getPropertyEditor();
        Object source = evt.getSource();
        if (source == relativeClassEditor && this.resourceLocator instanceof ClassResourceLocator) {
            ((ClassResourceLocator)this.resourceLocator).setRelativeClass((Class)relativeClassEditor.getValue());
        }
    }

    @Override
    public void customizerClosing() {
        this.sourceChange(this.source.getText());
        this.pathType.removeActionListener(this);
        this.sourceButton.removeActionListener(this);
        this.source.removeFocusListener(this);
        this.source.removeActionListener(this);
    }

    class ImageFilter
    extends FileFilter {
        ImageFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String extension = Extensions.getExtension(file);
            if (extension != null) {
                return extension.equals("tiff") || extension.equals("tif") || extension.equals("gif") || extension.equals("jpeg") || extension.equals("bmp") || extension.equals("jpg");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return RB.getStringResource((String)ResourceLocatorInterfaceCustomizerPanel.RB_KEY, (String)"imageFilesFilter.txt");
        }
    }

    static class Extensions {
        public static final String jpeg = "jpeg";
        public static final String jpg = "jpg";
        public static final String gif = "gif";
        public static final String tiff = "tiff";
        public static final String tif = "tif";
        public static final String bmp = "bmp";
        public static final String zip = "zip";
        public static final String jar = "jar";

        Extensions() {
        }

        public static String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

