/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.Component;
import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.Permuter;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.collection.StringCollection;
import com.sas.models.AlphabeticSequencer;
import com.sas.models.RB;
import com.sas.models.SimpleTableColumn;
import com.sas.table.ColumnChangedEvent;
import com.sas.table.ColumnLabelChangedEvent;
import com.sas.table.ColumnLabelInterface;
import com.sas.table.DataCellChangedEvent;
import com.sas.table.DataTableInterface;
import com.sas.table.RowChangedEvent;
import com.sas.table.RowLabelChangedEvent;
import com.sas.table.RowLabelInterface;
import com.sas.table.RowTemplateTableInterface;
import com.sas.table.SortableTableInterface;
import com.sas.table.StaticTableStyleInterface;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.util.CompositeComparator;
import com.sas.util.ConstantComparator;
import com.sas.util.EventGateInterface;
import com.sas.util.IndexedSetInterface;
import com.sas.util.ReverseComparator;
import com.sas.util.Sort;
import com.sas.util.Util;
import com.sas.util.VectorAccess;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class SimpleTable
extends Component
implements PublicClonable,
RowLabelInterface,
ColumnLabelInterface,
RowTemplateTableInterface,
ContentsChangedSource,
EventGateInterface,
StaticTableStyleInterface,
SortableTableInterface {
    static final long serialVersionUID = 8870222253165493508L;
    static final String RB_KEY = "SimpleTable.";
    private OrderedCollectionInterface colInfos;
    private StringCollection rowLabels;
    private OrderedCollectionInterface cellData;
    private Vector colInfoVector;
    private Vector rowLabelVector;
    private Vector cellDataVector;
    private int pendingEventGateCount = 0;
    protected boolean columnsLabelSupported;
    protected Object columnsLabel;
    protected boolean rowsLabelSupported;
    protected Object rowsLabel;
    protected boolean rowLabelsSupported;
    protected boolean columnLabelsSupported;
    private StaticPropertyBagInterface m_defaultCellStyle;
    private StaticPropertyBagInterface m_defaultLabelStyle;
    private StaticPropertyBagInterface m_defaultColumnStyle;
    private StaticPropertyBagInterface m_defaultRowStyle;
    protected transient ContentsChangedListenerList allContentsChangedListeners;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "cellStylesSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "cellsModifiable"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "column"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "columnClass"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "columnClasses"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "columnCount"}, {"Bound", "false"}, {"Linkable", "false"}}, {{"Name", "columnDefaultValue"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "columnLabel"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "columnLabelStyle"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "columnLabelStylesSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "columnLabelsModifiable"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "columnLabelsSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "columnStyle"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "columnStylesSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "columnsDeletable"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "columnsExtendable"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "columnsInsertable"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "columnsLabelSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "columnsRedefinable"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "defaultCellStyle"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "defaultColumnStyle"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "defaultLabelStyle"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "defaultRowStyle"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "multipleColumnUpdateSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "multipleRowUpdateSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "row"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "rowCount"}, {"Bound", "false"}, {"Linkable", "false"}}, {{"Name", "rowLabel"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "rowLabelStyle"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "rowLabelStylesSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "rowLabelsModifiable"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "rowLabelsSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "rowStyle"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "rowStylesSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "rowsDeletable"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "rowsExtendable"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "rowsInsertable"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "rowsLabelSupported"}, {"Bound", "false"}, {"Linkable", "false"}, {"Expert", "true"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public SimpleTable() {
    }

    public SimpleTable(int numRows, int numColumns) {
        this();
        this.setSize(numRows, numColumns);
    }

    public SimpleTable(DataTableInterface table) throws TableException {
        this();
        this.populate(table, true);
    }

    public SimpleTable(DataTableInterface table, int startRow, int endRow, int startCol, int endCol) throws TableException {
        this();
        this.populate(table, true, startRow, endRow, startCol, endCol);
    }

    public SimpleTable(DataTableInterface table, Comparator[] comparators) throws TableException {
        this(table);
        this.setColumnComparators(comparators);
    }

    public SimpleTable(DataTableInterface table, int startRowIndex, int endRowIndex, int startCol, int endCol, Comparator[] comparators) throws TableException {
        this(table, startRowIndex, endRowIndex, startCol, endCol);
        this.setColumnComparators(comparators);
    }

    public SimpleTable(int numRows, int numColumns, Comparator[] comparators) {
        this(numRows, numColumns);
        this.setColumnComparators(comparators);
    }

    public synchronized void setColumnComparators(Comparator[] comparators) {
        int max = Math.min(comparators.length, this.getColumnCount());
        for (int columnIndex = 0; columnIndex <= max; ++columnIndex) {
            SimpleTableColumn colInfo = (SimpleTableColumn)this.colInfoVector.elementAt(columnIndex);
            colInfo.setComparator(comparators[columnIndex]);
        }
    }

    public void populate(DataTableInterface dti) throws TableException {
        if (this.getColumnCount() > 0) {
            this.populate(dti, false);
        } else {
            this.populate(dti, true);
        }
    }

    protected void populate(DataTableInterface dti, boolean defineColumns) throws TableException {
        int rowCount = this.calculateTotalRows(dti);
        int columnCount = this.calculateTotalColumns(dti);
        if (rowCount == 0 && columnCount == 0) {
            throw new IndexOutOfBoundsException(RB.getStringResource((String)RB_KEY, (String)"cannotObtainSourceData.ex.txt"));
        }
        if (rowCount > 0) {
            this.populate(dti, defineColumns, 1, rowCount, 1, columnCount);
        } else {
            this.populate(dti, 1, columnCount);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populate(DataTableInterface dti, boolean defineColumns, int startRow, int endRow, int startCol, int endCol) throws TableException, IndexOutOfBoundsException, IllegalStateException {
        if (startRow <= 0) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"notGreaterThanZero.ex.txt"), (Object)"startRow"));
        }
        if (startCol <= 0) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"notGreaterThanZero.ex.txt"), (Object)"startCol"));
        }
        if (endCol == 0 || endCol < -1) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"invalidEntryEndParameter.ex.txt"), (Object)"endCol", (Object)new Integer(endCol)));
        }
        if (endRow == 0 || endRow < -1) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"invalidEntryEndParameter.ex.txt"), (Object)"endRow", (Object)new Integer(endRow)));
        }
        if (startRow > endRow && endRow != -1) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"startGreaterThanEnd.ex.txt"), (Object)"startRow", (Object)"endRow"));
        }
        if (startCol > endCol && endCol != -1) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"startGreaterThanEnd.ex.txt"), (Object)"startCol", (Object)"endCol"));
        }
        int rowsToAdd = this.calculateTotalRows(dti);
        int columnsToAdd = this.calculateTotalColumns(dti);
        if (rowsToAdd == 0 && columnsToAdd == 0) {
            throw new IndexOutOfBoundsException(RB.getStringResource((String)RB_KEY, (String)"cannotObtainSourceData.ex.txt"));
        }
        rowsToAdd = endRow != -1 ? endRow - startRow + 1 : 0;
        columnsToAdd = endCol != -1 ? endCol - startCol + 1 : 0;
        if (defineColumns) {
            this.setSize(0, 0);
            this.setSize(rowsToAdd, columnsToAdd);
            Object[][] cellsFromTable = dti.getCells(startRow, startCol, rowsToAdd, columnsToAdd);
            this.setCells(1, 1, rowsToAdd, columnsToAdd, cellsFromTable);
            Class[] columnClasses = dti.getColumnClasses(startCol, columnsToAdd);
            for (int i = 1; i <= columnsToAdd; ++i) {
                this.setColumnClass(i, columnClasses[i - 1]);
            }
            if (!dti.isColumnLabelsSupported()) return;
            Object[] columnLabels = dti.getColumnLabels(startCol, columnsToAdd);
            for (int i = 1; i <= columnsToAdd; ++i) {
                this.setColumnLabel(i, columnLabels[i - 1]);
            }
            return;
        } else {
            Class[] dataTableColumnClasses;
            int columnCount = this.getColumnCount();
            if (columnCount <= 0) throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"columnsNotDefined.ex.txt"));
            if (columnsToAdd > columnCount) {
                throw new TableException(RB.getStringResource((String)RB_KEY, (String)"cannotAddMoreColumns.ex.txt"));
            }
            Class[] currentColumnClasses = this.getColumnClasses(1, columnsToAdd);
            if (!Util.equal((Object)currentColumnClasses, (Object)(dataTableColumnClasses = dti.getColumnClasses(startCol, columnsToAdd)))) throw new TableException(RB.getStringResource((String)RB_KEY, (String)"incompatibleColumnClasses.ex.txt"));
            int currentRowCount = this.getRowCount() + 1;
            for (int i = startRow; i <= endRow; ++i) {
                Object[] columnValues = dti.getRow(i);
                this.addRow(currentRowCount, columnValues);
                if (this.isRowLabelsSupported()) {
                    this.setRowLabel(currentRowCount, String.valueOf(currentRowCount));
                }
                ++currentRowCount;
            }
        }
    }

    public void populate(DataTableInterface dti, int startCol, int endCol) throws TableException, IndexOutOfBoundsException {
        if (startCol <= 0) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"notGreaterThanZero.ex.txt"), (Object)"startCol"));
        }
        if (endCol == 0 || endCol < -1) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"invalidEntryEndParameter.ex.txt"), (Object)"endCol", (Object)new Integer(endCol)));
        }
        if (startCol > endCol && endCol != -1) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"startGreaterThanEnd.ex.txt"), (Object)"startCol", (Object)"endCol"));
        }
        int columnsToAdd = this.calculateTotalColumns(dti);
        if (columnsToAdd == 0) {
            throw new IndexOutOfBoundsException(RB.getStringResource((String)RB_KEY, (String)"cannotObtainSourceData.ex.txt"));
        }
        columnsToAdd = endCol != -1 ? endCol - startCol + 1 : 0;
        this.setSize(0, 0);
        this.setSize(0, columnsToAdd);
        Class[] columnClasses = dti.getColumnClasses(startCol, columnsToAdd);
        for (int i = 1; i <= columnsToAdd; ++i) {
            this.setColumnClass(i, columnClasses[i - 1]);
        }
        if (dti.isColumnLabelsSupported()) {
            Object[] columnLabels = dti.getColumnLabels(startCol, columnsToAdd);
            for (int i = 1; i <= columnsToAdd; ++i) {
                this.setColumnLabel(i, columnLabels[i - 1]);
            }
        }
    }

    protected int calculateTotalRows(DataTableInterface dti) throws TableException, IndexOutOfBoundsException {
        int rowCount;
        try {
            rowCount = dti.getRowCount();
            if (rowCount == -1) {
                rowCount = dti.countRows(0);
            }
        }
        catch (TableException e) {
            throw new TableException(RB.getStringResource((String)RB_KEY, (String)"cannotObtainRowCount.ex.txt"));
        }
        return rowCount;
    }

    protected int calculateTotalColumns(DataTableInterface dti) throws TableException {
        int columnCount;
        try {
            columnCount = dti.getColumnCount();
            if (columnCount == -1) {
                columnCount = dti.countColumns(0);
            }
        }
        catch (TableException e) {
            throw new TableException(RB.getStringResource((String)RB_KEY, (String)"cannotObtainColumnCount.ex.txt"));
        }
        return columnCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int rowCount, int colCount) {
        int oldRowCount = this.getRowCount();
        int oldColCount = this.getColumnCount();
        if (rowCount == oldRowCount && colCount == oldColCount) {
            return;
        }
        try {
            int i;
            this.disableEvents();
            for (i = oldColCount; i > colCount; --i) {
                this.deleteColumn(i);
            }
            for (i = oldColCount + 1; i <= colCount; ++i) {
                this.addColumn(i, String.class, null);
                if (!this.isColumnLabelsSupported()) continue;
                this.setColumnLabel(i, AlphabeticSequencer.defaultInstance.get(i));
            }
            for (i = oldRowCount; i > rowCount; --i) {
                this.deleteRow(i);
            }
            for (i = oldRowCount + 1; i <= rowCount; ++i) {
                this.addRow(i);
                if (!this.isRowLabelsSupported()) continue;
                this.setRowLabel(i, String.valueOf(i));
            }
            this.removeWastedSpace();
        }
        finally {
            rowCount = this.getRowCount();
            colCount = this.getColumnCount();
            if (rowCount != oldRowCount && colCount != oldColCount) {
                this.enableEvents();
            } else if (rowCount != oldRowCount) {
                if (rowCount > oldRowCount) {
                    this.enableEvents(new RowChangedEvent(this, oldRowCount + 1, rowCount - oldRowCount, 1));
                } else {
                    this.enableEvents(new RowChangedEvent(this, rowCount + 1, oldRowCount - rowCount, 2));
                }
            } else if (colCount != oldColCount) {
                if (colCount > oldColCount) {
                    this.enableEvents(new ColumnChangedEvent(this, oldColCount + 1, colCount - oldColCount, 1));
                } else {
                    this.enableEvents(new ColumnChangedEvent(this, colCount + 1, oldColCount - colCount, 2));
                }
            }
        }
    }

    protected void removeWastedSpace() {
        if (this.getRowCount() <= this.cellDataVector.capacity() / 2) {
            this.cellDataVector = (Vector)this.cellDataVector.clone();
            this.rowLabelVector = (Vector)this.rowLabelVector.clone();
        }
        if (this.getColumnCount() <= this.colInfoVector.capacity() / 2) {
            this.colInfoVector = (Vector)this.colInfoVector.clone();
            int cellDataVectorLen = this.cellDataVector.size();
            for (int i = 0; i < cellDataVectorLen; ++i) {
                Vector row = (Vector)this.cellDataVector.elementAt(i);
                this.cellDataVector.setElementAt(row.clone(), i);
            }
        }
    }

    public synchronized void setDefaultValues() {
        super.setDefaultValues();
        this.colInfoVector = new Vector();
        this.rowLabelVector = new Vector();
        this.cellDataVector = new Vector();
        this.rowLabelsSupported = true;
        this.columnLabelsSupported = true;
    }

    public synchronized void disableEvents() {
        ++this.pendingEventGateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        SimpleTable clone = (SimpleTable)super.clone();
        clone.allContentsChangedListeners = null;
        clone.pendingEventGateCount = 0;
        Vector vector = this.colInfoVector;
        synchronized (vector) {
            Vector<Object> clonedColInfoVector;
            int numCols = this.colInfoVector.size();
            clone.colInfoVector = clonedColInfoVector = new Vector<Object>(numCols);
            Vector<Object> vector2 = clonedColInfoVector;
            synchronized (vector2) {
                for (int i = 0; i < numCols; ++i) {
                    SimpleTableColumn col = (SimpleTableColumn)this.colInfoVector.elementAt(i);
                    clonedColInfoVector.addElement(col.clone());
                }
            }
        }
        clone.rowLabelVector = (Vector)this.rowLabelVector.clone();
        vector = this.cellDataVector;
        synchronized (vector) {
            Vector<Vector> clonedCellDataVector;
            clone.cellDataVector = clonedCellDataVector = new Vector<Vector>(this.cellDataVector.size());
            Vector<Vector> vector3 = clonedCellDataVector;
            synchronized (vector3) {
                int cellDataLen = this.cellDataVector.size();
                for (int i = 0; i < cellDataLen; ++i) {
                    Vector row = (Vector)this.cellDataVector.elementAt(i);
                    Vector newRow = (Vector)row.clone();
                    clonedCellDataVector.addElement(newRow);
                }
            }
        }
        if (this.m_defaultCellStyle != null) {
            clone.m_defaultCellStyle = (StaticPropertyBagInterface)this.m_defaultCellStyle.clone();
        }
        if (this.m_defaultLabelStyle != null) {
            clone.m_defaultLabelStyle = (StaticPropertyBagInterface)this.m_defaultLabelStyle.clone();
        }
        if (this.m_defaultColumnStyle != null) {
            clone.m_defaultColumnStyle = (StaticPropertyBagInterface)this.m_defaultColumnStyle.clone();
        }
        if (this.m_defaultRowStyle != null) {
            clone.m_defaultRowStyle = (StaticPropertyBagInterface)this.m_defaultRowStyle.clone();
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleTable) {
            return this.equals((SimpleTable)o);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(SimpleTable table) {
        if (table == null) {
            return false;
        }
        SimpleTable simpleTable = table;
        synchronized (simpleTable) {
            if (this.colInfoVector.size() != table.colInfoVector.size()) {
                return false;
            }
            if (this.rowLabelVector.size() != table.rowLabelVector.size()) {
                return false;
            }
            if (!Util.equal((Vector)this.colInfoVector, (Vector)table.colInfoVector)) {
                return false;
            }
            if (!Util.equal((Vector)this.rowLabelVector, (Vector)table.rowLabelVector)) {
                return false;
            }
            if (Util.unequal((Object)this.m_defaultColumnStyle, (Object)table.m_defaultColumnStyle)) {
                return false;
            }
            if (Util.unequal((Object)this.m_defaultLabelStyle, (Object)table.m_defaultLabelStyle)) {
                return false;
            }
            if (Util.unequal((Object)this.m_defaultCellStyle, (Object)table.m_defaultCellStyle)) {
                return false;
            }
            if (Util.unequal((Object)this.m_defaultRowStyle, (Object)table.m_defaultRowStyle)) {
                return false;
            }
            Vector vector = this.cellDataVector;
            synchronized (vector) {
                Vector vector2 = table.cellDataVector;
                synchronized (vector2) {
                    Vector otherCellDataVector = table.cellDataVector;
                    for (int i = 0; i < this.cellDataVector.size(); ++i) {
                        Vector otherRow;
                        Vector thisRow = (Vector)this.cellDataVector.elementAt(i);
                        if (Util.equal((Vector)thisRow, (Vector)(otherRow = (Vector)otherCellDataVector.elementAt(i)))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public synchronized void enableEvents() {
        if (this.pendingEventGateCount > 0) {
            --this.pendingEventGateCount;
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new ContentsChangedEvent((Object)this));
            }
        }
    }

    protected synchronized void enableEvents(ContentsChangedEvent e) {
        if (this.pendingEventGateCount > 0) {
            --this.pendingEventGateCount;
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(e);
            }
        }
    }

    public synchronized int countColumns(int maxColumnCount) {
        return this.getColumnCount();
    }

    public synchronized int countRows(int maxRowCount) {
        return this.getRowCount();
    }

    public synchronized Object getCell(int rowIndex, int columnIndex) {
        Object cell = ((Vector)this.cellDataVector.elementAt(rowIndex - 1)).elementAt(columnIndex - 1);
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) {
        Object[][] cells = new Object[rowCount][columnCount];
        Vector vector = this.cellDataVector;
        synchronized (vector) {
            int r = startRowIndex - 1;
            for (int i = 0; i < rowCount; ++i) {
                Vector rowVector = (Vector)this.cellDataVector.elementAt(r);
                Object[] row = new Object[columnCount];
                cells[i] = row;
                Vector vector2 = rowVector;
                synchronized (vector2) {
                    int c = startColumnIndex - 1;
                    for (int j = 0; j < columnCount; ++j) {
                        row[j] = rowVector.elementAt(c);
                        ++c;
                    }
                }
                ++r;
            }
        }
        return cells;
    }

    public synchronized Class getCellClass(int rowIndex, int columnIndex) {
        Object cell = this.getCell(rowIndex, columnIndex);
        if (cell == null) {
            return null;
        }
        return cell.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) {
        Class[][] types = new Class[rowCount][columnCount];
        Vector vector = this.cellDataVector;
        synchronized (vector) {
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < columnCount; ++c) {
                    types[r][c] = this.getCellClass(startRowIndex + r, startColumnIndex + c);
                }
            }
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[] getColumn(int columnIndex) {
        int rowCount = this.getRowCount();
        Object[] cells = new Object[rowCount];
        Vector vector = this.cellDataVector;
        synchronized (vector) {
            for (int r = 1; r <= rowCount; ++r) {
                cells[r - 1] = this.getCell(r, columnIndex);
            }
        }
        return cells;
    }

    public synchronized int getColumnCount() {
        return this.colInfoVector.size();
    }

    public synchronized void setColumnCount(int numColumns) {
        this.setSize(this.getRowCount(), numColumns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[] getRow(int rowIndex) {
        Vector row;
        int columnCount = this.getColumnCount();
        Object[] cells = new Object[columnCount];
        Vector vector = row = (Vector)this.cellDataVector.elementAt(rowIndex - 1);
        synchronized (vector) {
            int rowLen = row.size();
            for (int i = 0; i < rowLen; ++i) {
                cells[i] = row.elementAt(i);
            }
        }
        return cells;
    }

    public synchronized int getRowCount() {
        return this.rowLabelVector.size();
    }

    public synchronized void setRowCount(int numRows) {
        this.setSize(numRows, this.getColumnCount());
    }

    public boolean isCellsModifiable() {
        return true;
    }

    public boolean isMultipleRowUpdateSupported() {
        return true;
    }

    public boolean isMultipleColumnUpdateSupported() {
        return true;
    }

    public synchronized void setCell(int rowIndex, int columnIndex, Object data) {
        Vector row = (Vector)this.cellDataVector.elementAt(rowIndex - 1);
        row.setElementAt(data, columnIndex - 1);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new DataCellChangedEvent(this, rowIndex, columnIndex, 1, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount, Object[][] cells) {
        try {
            this.disableEvents();
            Vector vector = this.cellDataVector;
            synchronized (vector) {
                for (int r = 0; r < rowCount; ++r) {
                    this.setRow(startRowIndex + r, cells[r]);
                }
            }
        }
        finally {
            this.enableEvents(new DataCellChangedEvent(this, startRowIndex, startColumnIndex, rowCount, columnCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColumn(int columnIndex, Object[] cells) {
        try {
            this.disableEvents();
            int rowCount = this.getRowCount();
            Vector vector = this.cellDataVector;
            synchronized (vector) {
                for (int r = 0; r < rowCount; ++r) {
                    this.setCell(r + 1, columnIndex, cells[r]);
                }
            }
        }
        finally {
            this.enableEvents(new ColumnChangedEvent(this, columnIndex, 1, 4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRow(int rowIndex, Object[] cells) {
        try {
            this.disableEvents();
            int columnCount = this.getColumnCount();
            Vector vector = this.cellDataVector;
            synchronized (vector) {
                for (int c = 1; c <= columnCount; ++c) {
                    this.setCell(rowIndex, c, cells[c - 1]);
                }
            }
        }
        finally {
            this.enableEvents(new RowChangedEvent(this, rowIndex, 1, 4));
        }
    }

    public boolean isRowLabelsSupported() {
        return this.rowLabelsSupported;
    }

    public synchronized Object getRowLabel(int rowIndex) {
        if (!this.isRowLabelsSupported()) {
            throw new RuntimeException(RB.getStringResource((String)RB_KEY, (String)"invalidGetRowLabel.ex.txt"));
        }
        if (rowIndex == 0 && this.rowsLabelSupported) {
            return this.rowsLabel;
        }
        return this.rowLabelVector.elementAt(rowIndex - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[] getRowLabels(int startRowIndex, int rowCount) {
        if (!this.isRowLabelsSupported()) {
            throw new RuntimeException(RB.getStringResource((String)RB_KEY, (String)"invalidGetRowLabels.ex.txt"));
        }
        Object[] labels = new Object[rowCount];
        Vector vector = this.rowLabelVector;
        synchronized (vector) {
            for (int c = 0; c < rowCount; ++c) {
                labels[c] = this.getRowLabel(startRowIndex + c);
            }
        }
        return labels;
    }

    public boolean isRowsLabelSupported() {
        return this.rowsLabelSupported;
    }

    public boolean isRowLabelsModifiable() {
        return true;
    }

    public synchronized void setRowLabel(int rowIndex, Object label) {
        if (!this.isRowLabelsSupported()) {
            throw new RuntimeException(RB.getStringResource((String)RB_KEY, (String)"invalidSetRowLabel.ex.txt"));
        }
        if (rowIndex == 0) {
            this.rowsLabelSupported = true;
            this.rowsLabel = label;
        } else {
            this.rowLabelVector.setElementAt(label, rowIndex - 1);
        }
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new RowLabelChangedEvent(this, rowIndex, 1));
        }
    }

    public boolean isColumnLabelsSupported() {
        return this.columnLabelsSupported;
    }

    public synchronized Object getColumnLabel(int columnIndex) {
        if (!this.isColumnLabelsSupported()) {
            throw new RuntimeException(RB.getStringResource((String)RB_KEY, (String)"invalidGetColumnLabel.ex.txt"));
        }
        if (columnIndex == 0 && this.columnsLabelSupported) {
            return this.columnsLabel;
        }
        return ((SimpleTableColumn)this.colInfoVector.elementAt(columnIndex - 1)).getLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[] getColumnLabels(int startColumnIndex, int columnCount) {
        if (!this.isColumnLabelsSupported()) {
            throw new RuntimeException(RB.getStringResource((String)RB_KEY, (String)"invalidGetColumnLabels.ex.txt"));
        }
        Object[] labels = new Object[columnCount];
        Vector vector = this.colInfoVector;
        synchronized (vector) {
            for (int c = 0; c < columnCount; ++c) {
                labels[c] = this.getColumnLabel(startColumnIndex + c);
            }
        }
        return labels;
    }

    public boolean isColumnsLabelSupported() {
        return this.columnsLabelSupported;
    }

    public boolean isColumnLabelsModifiable() {
        return true;
    }

    public synchronized void setColumnLabel(int columnIndex, Object label) {
        if (!this.isColumnLabelsSupported()) {
            throw new RuntimeException(RB.getStringResource((String)RB_KEY, (String)"invalidSetColumnLabel.ex.txt"));
        }
        if (columnIndex == 0) {
            this.columnsLabelSupported = true;
            this.columnsLabel = label;
        } else {
            SimpleTableColumn colInfo = (SimpleTableColumn)this.colInfoVector.elementAt(columnIndex - 1);
            colInfo.setLabel(label);
        }
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ColumnLabelChangedEvent(this, columnIndex, 1));
        }
    }

    public synchronized Class[] getColumnClasses() {
        return this.getColumnClasses(1, this.getColumnCount());
    }

    public synchronized Class getColumnClass(int columnIndex) {
        if (columnIndex == 0 && this.columnsLabelSupported) {
            return this.columnsLabel.getClass();
        }
        return ((SimpleTableColumn)this.colInfoVector.elementAt(columnIndex - 1)).getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class[] getColumnClasses(int startColumnIndex, int columnCount) {
        Class[] types = new Class[columnCount];
        Vector vector = this.colInfoVector;
        synchronized (vector) {
            for (int c = 0; c < columnCount; ++c) {
                types[c] = this.getColumnClass(startColumnIndex + c);
            }
        }
        return types;
    }

    public synchronized void addColumn(int columnIndex, Class type, Object defaultValue) {
        SimpleTableColumn columnInfo = new SimpleTableColumn();
        columnInfo.setLabel(null);
        columnInfo.setType(type);
        columnInfo.setDefaultValue(defaultValue);
        this.colInfoVector.insertElementAt(columnInfo, columnIndex - 1);
        for (int r = 0; r < this.getRowCount(); ++r) {
            Vector row = (Vector)this.cellDataVector.elementAt(r);
            row.insertElementAt(defaultValue, columnIndex - 1);
        }
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ColumnChangedEvent(this, columnIndex, 1, 1));
        }
    }

    public synchronized void addColumn(int columnIndex) {
        this.addColumn(columnIndex, Object.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addRow(int rowIndex) {
        Vector<Object> row;
        this.rowLabelVector.insertElementAt(null, rowIndex - 1);
        int cc = this.getColumnCount();
        Vector<Object> vector = row = new Vector<Object>(cc);
        synchronized (vector) {
            for (int c = 0; c < cc; ++c) {
                row.addElement(this.getColumnDefaultValue(c + 1));
            }
        }
        this.cellDataVector.insertElementAt(row, rowIndex - 1);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new RowChangedEvent(this, rowIndex, 1, 1));
        }
    }

    public synchronized void addRow(int rowIndex, Object[] values) {
        int valuesLength = values.length;
        if (valuesLength != this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        this.rowLabelVector.insertElementAt(null, rowIndex - 1);
        Vector<Object> row = new Vector<Object>(valuesLength);
        for (int i = 0; i < valuesLength; ++i) {
            Object value = values[i];
            row.addElement(value);
        }
        this.cellDataVector.insertElementAt(row, rowIndex - 1);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new RowChangedEvent(this, rowIndex, 1, 1));
        }
    }

    public synchronized void deleteColumn(int columnIndex) {
        for (int r = 0; r < this.getRowCount(); ++r) {
            Vector row = (Vector)this.cellDataVector.elementAt(r);
            row.removeElementAt(columnIndex - 1);
        }
        this.colInfoVector.removeElementAt(columnIndex - 1);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ColumnChangedEvent(this, columnIndex, 1, 2));
        }
    }

    public synchronized void deleteRow(int rowIndex) {
        this.rowLabelVector.removeElementAt(rowIndex - 1);
        this.cellDataVector.removeElementAt(rowIndex - 1);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new RowChangedEvent(this, rowIndex, 1, 2));
        }
    }

    public synchronized Object getColumnDefaultValue(int columnIndex) {
        return ((SimpleTableColumn)this.colInfoVector.elementAt(columnIndex - 1)).getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[] getColumnDefaultValues(int startColumnIndex, int columnCount) {
        Object[] defaultValues = new Object[columnCount];
        Vector vector = this.colInfoVector;
        synchronized (vector) {
            for (int c = 0; c < columnCount; ++c) {
                defaultValues[c] = this.getColumnDefaultValue(startColumnIndex + c);
            }
        }
        return defaultValues;
    }

    public boolean isColumnsDeletable() {
        return true;
    }

    public boolean isColumnsExtendable() {
        return true;
    }

    public boolean isColumnsInsertable() {
        return true;
    }

    public boolean isColumnsRedefinable() {
        return true;
    }

    public boolean isRowsDeletable() {
        return true;
    }

    public boolean isRowsExtendable() {
        return true;
    }

    public boolean isRowsInsertable() {
        return true;
    }

    public synchronized void setColumnDefaultValue(int columnIndex, Object newValue) {
        if (Util.unequal((Object)newValue, (Object)this.getColumnDefaultValue(columnIndex))) {
            SimpleTableColumn colInfo = (SimpleTableColumn)this.colInfoVector.elementAt(columnIndex - 1);
            colInfo.setDefaultValue(newValue);
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new ColumnChangedEvent(this, columnIndex, 1, 6));
            }
        }
    }

    public synchronized void setColumnClass(int columnIndex, Class newValue) {
        if (Util.unequal((Object)newValue, (Object)this.getColumnClass(columnIndex))) {
            SimpleTableColumn colInfo = (SimpleTableColumn)this.colInfoVector.elementAt(columnIndex - 1);
            colInfo.setType(newValue);
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new ColumnChangedEvent(this, columnIndex, 1, 5));
            }
        }
    }

    public synchronized void setColumnLabelsSupported(boolean columnLabelsSupported) {
        this.columnLabelsSupported = columnLabelsSupported;
    }

    public synchronized void setRowLabelsSupported(boolean rowLabelsSupported) {
        this.rowLabelsSupported = rowLabelsSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteAllColumns() {
        int columnCount = this.getColumnCount();
        if (columnCount > 0) {
            try {
                this.disableEvents();
                Vector vector = this.cellDataVector;
                synchronized (vector) {
                    Vector vector2 = this.colInfoVector;
                    synchronized (vector2) {
                        for (int c = columnCount; c > 0; --c) {
                            this.deleteColumn(c);
                        }
                    }
                }
                this.removeWastedSpace();
            }
            finally {
                this.enableEvents(new ColumnChangedEvent(this, 1, columnCount, 2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteAllRows() {
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            try {
                this.disableEvents();
                Vector vector = this.cellDataVector;
                synchronized (vector) {
                    Vector vector2 = this.rowLabelVector;
                    synchronized (vector2) {
                        for (int r = rowCount; r > 0; --r) {
                            this.deleteRow(r);
                        }
                    }
                }
                this.removeWastedSpace();
            }
            finally {
                this.enableEvents(new RowChangedEvent(this, 1, rowCount, 2));
            }
        }
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    protected void fireContentsChanged(ContentsChangedEvent event) {
        if (this.pendingEventGateCount > 0) {
            return;
        }
        if (this.allContentsChangedListeners != null && this.allContentsChangedListeners.count() > 0) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged(event);
            }
        }
        this.firePropertyChange((PropertyChangeEvent)event);
    }

    protected synchronized void fireContentsChanged() {
        if (this.pendingEventGateCount > 0) {
            return;
        }
        ContentsChangedEvent contentsChangedEvent = new ContentsChangedEvent((Object)this);
        this.fireContentsChanged(contentsChangedEvent);
    }

    protected boolean anyContentsChangedListeners() {
        return this.pendingEventGateCount == 0 && (this.allContentsChangedListeners != null && this.allContentsChangedListeners.count() > 0 || this.anyPropertyChangeListeners());
    }

    @Override
    public StaticPropertyBagInterface getDefaultCellStyle() {
        return this.m_defaultCellStyle;
    }

    public void setDefaultCellStyle(StaticPropertyBagInterface newValue) {
        this.m_defaultCellStyle = newValue;
    }

    @Override
    public StaticPropertyBagInterface getDefaultColumnStyle() {
        return this.m_defaultColumnStyle;
    }

    public void setDefaultColumnStyle(StaticPropertyBagInterface newValue) {
        this.m_defaultColumnStyle = newValue;
    }

    @Override
    public StaticPropertyBagInterface getDefaultLabelStyle() {
        return this.m_defaultLabelStyle;
    }

    public void setDefaultLabelStyle(StaticPropertyBagInterface newValue) {
        this.m_defaultLabelStyle = newValue;
    }

    @Override
    public StaticPropertyBagInterface getDefaultRowStyle() {
        return this.m_defaultRowStyle;
    }

    public void setDefaultRowStyle(StaticPropertyBagInterface newValue) {
        this.m_defaultRowStyle = newValue;
    }

    @Override
    public StaticPropertyBagInterface getCellStyle(int rowIndex, int colIndex) {
        throw new RuntimeException();
    }

    @Override
    public boolean isCellStylesSupported() {
        return false;
    }

    @Override
    public StaticPropertyBagInterface getColumnLabelStyle(int colIndex) {
        throw new RuntimeException();
    }

    @Override
    public boolean isColumnLabelStylesSupported() {
        return false;
    }

    @Override
    public StaticPropertyBagInterface getColumnStyle(int colIndex) {
        throw new RuntimeException();
    }

    @Override
    public boolean isColumnStylesSupported() {
        return false;
    }

    @Override
    public StaticPropertyBagInterface getRowLabelStyle(int rowIndex) {
        throw new RuntimeException();
    }

    @Override
    public boolean isRowLabelStylesSupported() {
        return false;
    }

    @Override
    public StaticPropertyBagInterface getRowStyle(int rowIndex) {
        throw new RuntimeException();
    }

    @Override
    public boolean isRowStylesSupported() {
        return false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.pendingEventGateCount = 0;
        if (this.colInfos != null) {
            this.convertToVectorInternals();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToVectorInternals() {
        int i;
        Vector vector;
        OrderedCollectionInterface orderedCollectionInterface = this.colInfos;
        synchronized (orderedCollectionInterface) {
            this.colInfoVector = new Vector(this.colInfos.count());
            vector = this.colInfoVector;
            synchronized (vector) {
                int colInfosLen = this.colInfos.count();
                for (i = 0; i < colInfosLen; ++i) {
                    this.colInfoVector.addElement(this.colInfos.get(i));
                }
            }
        }
        orderedCollectionInterface = this.rowLabels;
        synchronized (orderedCollectionInterface) {
            this.rowLabelVector = new Vector(this.rowLabels.count());
            vector = this.rowLabelVector;
            synchronized (vector) {
                int rowLabelsLen = this.rowLabels.count();
                for (i = 0; i < rowLabelsLen; ++i) {
                    this.rowLabelVector.addElement(this.rowLabels.get(i));
                }
            }
        }
        orderedCollectionInterface = this.cellData;
        synchronized (orderedCollectionInterface) {
            this.cellDataVector = new Vector(this.cellData.count());
            vector = this.cellDataVector;
            synchronized (vector) {
                int cellDataLen = this.cellData.count();
                for (i = 0; i < cellDataLen; ++i) {
                    OrderedCollection row;
                    OrderedCollection orderedCollection = row = (OrderedCollection)this.cellData.get(i);
                    synchronized (orderedCollection) {
                        int numCols = row.count();
                        Vector<Object> newRow = new Vector<Object>(numCols);
                        this.cellDataVector.addElement(newRow);
                        Vector<Object> vector2 = newRow;
                        synchronized (vector2) {
                            for (int j = 0; j < numCols; ++j) {
                                newRow.addElement(row.get(j));
                            }
                        }
                    }
                }
            }
        }
        this.colInfos = null;
        this.rowLabels = null;
        this.cellData = null;
    }

    public final synchronized void sort(Comparator comparator, boolean removeDuplicates) throws TableException {
        try {
            this.disableEvents();
            this.sort(comparator, 1, -1, null);
            if (removeDuplicates) {
                this.removeDuplicates(comparator, 1, -1, true, null);
            }
        }
        finally {
            this.enableEvents();
        }
    }

    protected Comparator newRowComparator() {
        int numCols = this.getColumnCount();
        int[] columnIndices = new int[numCols];
        Comparator[] comparators = new Comparator[numCols];
        for (int i = 0; i < numCols; ++i) {
            columnIndices[i] = i + 1;
        }
        Comparator comparator = this.newCompositeComparator(columnIndices, comparators);
        return comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sort(Comparator comparator, int startRowIndex, int endRowIndex, int[] permutation) throws TableException {
        try {
            this.disableEvents();
            startRowIndex = this.normalizeStartRow(startRowIndex);
            endRowIndex = this.normalizeEndRow(endRowIndex);
            VectorAccess vectorAccess = new VectorAccess(this.cellDataVector);
            if (comparator == null) {
                comparator = this.newRowComparator();
            }
            new Sort((IndexedSetInterface)vectorAccess, comparator).sort(startRowIndex - 1, endRowIndex - 1, permutation);
        }
        finally {
            this.enableEvents();
        }
    }

    public int normalizeStartRow(int rowNumber) {
        if (rowNumber < 0) {
            rowNumber = this.getRowCount() + rowNumber + 1;
        }
        return rowNumber;
    }

    public int normalizeEndRow(int rowNumber) {
        if (rowNumber < 0) {
            rowNumber = this.getRowCount() + rowNumber + 2;
        }
        return rowNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void sort(int columnIndex, Comparator comparator, boolean removeDuplicates) throws TableException {
        try {
            this.disableEvents();
            this.sort(columnIndex, comparator, 1, -1, null);
            if (removeDuplicates) {
                this.removeDuplicates(columnIndex, comparator, 1, -1, true, null);
            }
        }
        finally {
            this.enableEvents();
        }
    }

    public synchronized void sort(int columnIndex, Comparator comparator, int startRowIndex, int endRowIndex, int[] permutation) throws TableException {
        Comparator c = this.newColumnComparator(columnIndex, comparator);
        this.sort(c, startRowIndex, endRowIndex, permutation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void sort(int[] columnIndices, Comparator[] comparators, boolean removeDuplicates) throws TableException {
        try {
            this.disableEvents();
            this.sort(columnIndices, comparators, 1, -1, null);
            if (removeDuplicates) {
                this.removeDuplicates(columnIndices, comparators, 1, -1, true, null);
            }
        }
        finally {
            this.enableEvents();
        }
    }

    public synchronized void sort(int[] columnIndices, Comparator[] comparators, int startRowIndex, int endRowIndex, int[] permutation) throws TableException {
        Comparator c = this.newCompositeComparator(columnIndices, comparators);
        this.sort(c, startRowIndex, endRowIndex, permutation);
    }

    protected Comparator newColumnComparator(int col, Comparator comparator) {
        if (comparator == null) {
            comparator = this.getColumnComparator(col);
        }
        comparator = new ColumnComparator(col, comparator);
        return comparator;
    }

    public Comparator newCompositeComparator(int[] columnIndices, Comparator[] comparators) {
        Comparator[] result = new Comparator[columnIndices.length];
        for (int i = columnIndices.length - 1; i >= 0; --i) {
            int col = columnIndices[i];
            Comparator comparator = null;
            if (col == 0) break;
            if (comparators != null) {
                comparator = comparators[i];
            }
            result[i] = this.newColumnComparator(col, comparator);
        }
        CompositeComparator comparator = new CompositeComparator(result);
        return comparator;
    }

    public synchronized void permute(int[] permutation) throws TableException {
        try {
            this.disableEvents();
            VectorAccess vectorAccess = new VectorAccess(this.cellDataVector);
            Permuter.permute((IndexedSetInterface)vectorAccess, (int[])permutation);
        }
        finally {
            this.enableEvents();
        }
    }

    public final synchronized void removeDuplicates(Comparator comparator) throws TableException {
        this.removeDuplicates(comparator, 1, -1, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeDuplicates(Comparator comparator, int startRowIndex, int endRowIndex, boolean keepFirst, boolean[] removed) throws TableException {
        try {
            this.disableEvents();
            startRowIndex = this.normalizeStartRow(startRowIndex);
            endRowIndex = this.normalizeEndRow(endRowIndex);
            int numRows = this.getRowCount();
            if (comparator == null) {
                comparator = this.newRowComparator();
            }
            Object[] last = this.getRow(startRowIndex);
            int thisRowIndex = startRowIndex;
            int removedIndex = startRowIndex - 1;
            while (thisRowIndex + 1 < endRowIndex) {
                Object[] thisRow = last;
                Object[] nextRow = this.getRow(thisRowIndex + 1);
                if (comparator.compare(thisRow, nextRow) == 0) {
                    if (keepFirst) {
                        if (removed != null) {
                            removed[removedIndex + 1] = true;
                        }
                        this.deleteRow(thisRowIndex + 1);
                    } else {
                        if (removed != null) {
                            removed[removedIndex] = true;
                        }
                        last = nextRow;
                        this.deleteRow(thisRowIndex);
                    }
                    --endRowIndex;
                } else {
                    last = nextRow;
                    ++thisRowIndex;
                }
                ++removedIndex;
            }
        }
        finally {
            this.enableEvents();
        }
    }

    public final synchronized void removeDuplicates(int columnIndex, Comparator comparator) throws TableException {
        this.removeDuplicates(columnIndex, comparator, 1, -1, true, null);
    }

    public synchronized void removeDuplicates(int columnIndex, Comparator comparator, int startRowIndex, int endRowIndex, boolean keepFirst, boolean[] removed) throws TableException {
        Comparator c = this.newColumnComparator(columnIndex, comparator);
        this.removeDuplicates(c, startRowIndex, endRowIndex, keepFirst, removed);
    }

    public final synchronized void removeDuplicates(int[] columnIndices, Comparator[] comparators) throws TableException {
        this.removeDuplicates(columnIndices, comparators, 1, -1, true, null);
    }

    public synchronized void removeDuplicates(int[] columnIndices, Comparator[] comparators, int startRowIndex, int endRowIndex, boolean keepFirst, boolean[] removed) throws TableException {
        Comparator c = this.newCompositeComparator(columnIndices, comparators);
        this.removeDuplicates(c, startRowIndex, endRowIndex, keepFirst, removed);
    }

    public synchronized void deleteRows(boolean[] delete) {
        try {
            this.disableEvents();
            for (int i = delete.length - 1; i >= 0; --i) {
                if (!delete[i]) continue;
                this.deleteRow(i + 1);
            }
        }
        finally {
            this.enableEvents();
        }
    }

    public synchronized Comparator getColumnComparator(int columnIndex) {
        SimpleTableColumn colInfo = (SimpleTableColumn)this.colInfoVector.elementAt(columnIndex - 1);
        return colInfo.getComparator();
    }

    public synchronized void setColumnComparator(int columnIndex, Comparator comparator) {
        SimpleTableColumn colInfo = (SimpleTableColumn)this.colInfoVector.elementAt(columnIndex - 1);
        colInfo.setComparator(comparator);
    }

    public synchronized void reverseColumnComparator(int columnIndex) {
        this.setColumnComparator(columnIndex, ReverseComparator.reverse((Comparator)this.getColumnComparator(columnIndex)));
    }

    public static Object getCell(Object row, int columnIndex) {
        if (row instanceof List) {
            return ((List)row).get(columnIndex - 1);
        }
        return ((Object[])row)[columnIndex - 1];
    }

    static class ColumnComparator
    implements Comparator {
        int columnIndex;
        Comparator comparator;

        ColumnComparator(int columnIndex, Comparator comparator) {
            this.columnIndex = columnIndex;
            this.comparator = comparator == null ? ConstantComparator.COMPARE_EQUALS : comparator;
        }

        public int compare(Object a, Object b) {
            return this.comparator.compare(SimpleTable.getCell(a, this.columnIndex), SimpleTable.getCell(b, this.columnIndex));
        }

        public boolean equal(ColumnComparator other) {
            return other != null && other.columnIndex == this.columnIndex && Util.equal((Object)this.comparator, (Object)other.comparator);
        }

        public boolean equal(Object object) {
            return object instanceof ColumnComparator && this.equals((ColumnComparator)object);
        }

        public String toString() {
            return this.comparator + "@column#" + (this.columnIndex + 1);
        }
    }
}

