/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.Component;
import com.sas.ComponentException;
import com.sas.DeepCloneSupport;
import com.sas.awt.VisualInterface;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.OrderedCollection;
import com.sas.models.RB;
import com.sas.models.RangeCollectionInterface;
import com.sas.models.RangeSegment;
import com.sas.models.RangeSegmentInterface;
import com.sas.text.Message;
import com.sas.util.EventGateInterface;
import com.sas.util.datamonitors.DataMonitorInterface;
import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;

public class RangeCollection
extends Component
implements RangeCollectionInterface,
DataMonitorInterface,
ContentsChangedListener,
ContentsChangedSource,
EventGateInterface,
Serializable {
    public static final String RB_KEY = "RangeCollection.";
    static final long serialVersionUID = -547193798215671377L;
    protected OrderedCollection segments;
    protected int pendingEventGateCount;
    protected boolean contiguousSegmentsRequired;
    protected transient ContentsChangedListenerList allContentsChangedListeners;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        return ebi;
    }

    public RangeCollection() {
        this((RangeSegmentInterface[])new RangeSegment[]{new RangeSegment((Number)new Double(0.0), (Number)new Double(33.0), Color.red), new RangeSegment((Number)new Double(33.0), (Number)new Double(67.0), Color.yellow), new RangeSegment((Number)new Double(67.0), (Number)new Double(100.0), Color.green)});
    }

    public RangeCollection(RangeSegmentInterface[] rangeSegments) {
        this.segments = new OrderedCollection(rangeSegments.length);
        for (int i = 0; i < rangeSegments.length; ++i) {
            this.segments.add((Object)rangeSegments[i]);
        }
        this.segments.addContentsChangedListener((ContentsChangedListener)this);
    }

    public void setDefaultValues() {
        super.setDefaultValues();
        this.contiguousSegmentsRequired = true;
    }

    public boolean isContiguousSegmentsRequired() {
        return this.contiguousSegmentsRequired;
    }

    public void setContiguousSegmentsRequired(boolean contiguousSegmentsRequired) {
        this.contiguousSegmentsRequired = contiguousSegmentsRequired;
    }

    public int getSegmentCount() {
        return this.segments.count();
    }

    public Enumeration getSegments() {
        return this.segments.getItems();
    }

    public RangeSegmentInterface getSegment(int index) {
        if (this.segments.count() == 0) {
            return null;
        }
        if (index < 0 || index >= this.segments.count()) {
            throw new IndexOutOfBoundsException(RB.getStringResource((String)RB_KEY, (String)"invalidIndex.ex.txt"));
        }
        return (RangeSegmentInterface)this.segments.get(index);
    }

    public RangeSegmentInterface getSegment(double value) {
        if (this.segments.count() == 0) {
            return null;
        }
        RangeSegmentInterface tempSeg = null;
        if (this.isContiguousSegmentsRequired()) {
            tempSeg = (RangeSegmentInterface)this.segments.get(0);
            if (value < tempSeg.getMinimumNumber().doubleValue()) {
                return tempSeg;
            }
            tempSeg = (RangeSegmentInterface)this.segments.get(this.segments.count() - 1);
            if (value >= tempSeg.getMaximumNumber().doubleValue()) {
                return tempSeg;
            }
        }
        for (int i = 0; i < this.segments.count(); ++i) {
            RangeSegmentInterface loopSeg = (RangeSegmentInterface)this.segments.get(i);
            if (!(value >= loopSeg.getMinimumNumber().doubleValue()) || !(value <= loopSeg.getMaximumNumber().doubleValue())) continue;
            tempSeg = loopSeg;
            break;
        }
        return tempSeg;
    }

    public void addSegment(RangeSegmentInterface segment) {
        if (this.isContiguousSegmentsRequired()) {
            if (this.segments.count() == 0) {
                this.segments.add((Object)segment, 0);
            } else if (segment.getMaximumNumber().doubleValue() == ((RangeSegmentInterface)this.segments.get(0)).getMinimumNumber().doubleValue()) {
                this.segments.add((Object)segment, 0);
            } else if (segment.getMinimumNumber().doubleValue() == ((RangeSegmentInterface)this.segments.get(this.segments.count() - 1)).getMaximumNumber().doubleValue()) {
                this.segments.add((Object)segment, this.segments.count());
            }
        } else {
            this.segments.add((Object)segment, this.segments.count());
        }
    }

    public void removeSegment(RangeSegmentInterface segment) {
        if (this.segments.count() == 0) {
            return;
        }
        if (this.isContiguousSegmentsRequired()) {
            if (segment == (RangeSegmentInterface)this.segments.get(0)) {
                this.segments.removeAt(0);
            } else if (segment == (RangeSegmentInterface)this.segments.get(this.segments.count() - 1)) {
                this.segments.removeAt(this.segments.count() - 1);
            }
        } else {
            this.segments.remove((Object)segment);
        }
    }

    public void removeSegment(int index) {
        if (this.segments.count() == 0) {
            return;
        }
        if (this.isContiguousSegmentsRequired()) {
            if (index == 0 || index == this.segments.count() - 1) {
                this.segments.removeAt(index);
            }
        } else {
            this.segments.removeAt(index);
        }
    }

    public void removeAllSegments() {
        this.segments.removeAll();
    }

    public Color getColor(double value) {
        if (this.segments.count() == 0) {
            return Color.black;
        }
        RangeSegmentInterface segment = null;
        if (this.isContiguousSegmentsRequired()) {
            segment = (RangeSegmentInterface)this.segments.get(0);
            if (value < segment.getMinimumNumber().doubleValue()) {
                return (Color)segment.get("COLOR");
            }
            segment = (RangeSegmentInterface)this.segments.get(this.segments.count() - 1);
            if (value > segment.getMaximumNumber().doubleValue()) {
                return (Color)segment.get("COLOR");
            }
        }
        for (int i = 0; i < this.segments.count(); ++i) {
            RangeSegmentInterface tempSegment = (RangeSegmentInterface)this.segments.get(i);
            if (!(value >= tempSegment.getMinimumNumber().doubleValue()) || !(value <= tempSegment.getMaximumNumber().doubleValue())) continue;
            segment = tempSegment;
            break;
        }
        if (segment != null) {
            return (Color)segment.get("COLOR");
        }
        return null;
    }

    public void contentsChanged(ContentsChangedEvent cev) {
        this.fireContentsChanged(new ContentsChangedEvent((Object)this));
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    protected void fireContentsChanged(ContentsChangedEvent event) {
        if (this.pendingEventGateCount > 0) {
            return;
        }
        if (this.allContentsChangedListeners != null) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged(event);
            }
        }
    }

    public void disableEvents() {
        ++this.pendingEventGateCount;
    }

    public synchronized void enableEvents() {
        if (this.pendingEventGateCount > 0) {
            --this.pendingEventGateCount;
            if (this.pendingEventGateCount == 0) {
                this.fireContentsChanged(new ContentsChangedEvent((Object)this));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void monitorData(Object component, Object value) {
        if (!(value instanceof String)) throw new ComponentException(RB.getStringResource((String)RB_KEY, (String)"monitor.ex.txt"));
        String valueString = (String)value;
        if ((valueString = valueString.trim()) == null || valueString.length() == 0) {
            return;
        }
        try {
            double valueDouble = Double.valueOf(valueString);
            Color valueColor = this.getColor(valueDouble);
            if (!(component instanceof VisualInterface)) return;
            VisualInterface visualComponent = (VisualInterface)component;
            visualComponent.setForegroundColor(valueColor);
            return;
        }
        catch (NumberFormatException e) {
            throw new ComponentException(Message.format((String)RB.getStringResource((String)"stringToDouble.ex.txt"), (Object)valueString));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        RangeCollection rc = (RangeCollection)super.clone();
        rc.segments = (OrderedCollection)this.segments.clone();
        rc.reset();
        return rc;
    }

    private void reset() {
        this.pendingEventGateCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone(DeepCloneSupport support, boolean deeply) throws CloneNotSupportedException {
        RangeCollection rangeCollection = this;
        synchronized (rangeCollection) {
            RangeCollection clone = (RangeCollection)super.clone();
            clone.reset();
            if (support != null) {
                support.register((Object)this, (Object)clone);
            }
            if (deeply) {
                try {
                    clone.segments = support == null ? (OrderedCollection)this.segments.clone() : (OrderedCollection)this.segments.clone(support, deeply);
                }
                catch (NullPointerException e) {
                    throw new CloneNotSupportedException("support == null");
                }
            }
            return clone;
        }
    }
}

