/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.models.MutableSimpleNodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeDnDDelegateInterface;
import com.sas.util.Util;
import java.io.Serializable;

public class DefaultTreeDnDDelegate
implements TreeDnDDelegateInterface,
Serializable {
    public static DefaultTreeDnDDelegate defaultDelegate = new DefaultTreeDnDDelegate();

    @Override
    public boolean isDraggable(SimpleNodeInterface[] nodePath) {
        if (nodePath == null) {
            return false;
        }
        if (nodePath.length < 2) {
            return false;
        }
        return nodePath[nodePath.length - 2] instanceof MutableSimpleNodeInterface && nodePath[nodePath.length - 1] instanceof MutableSimpleNodeInterface;
    }

    @Override
    public boolean isDropSite(SimpleNodeInterface[] dragNodePath, SimpleNodeInterface[] dropNodeParentPath, int index) {
        if (dropNodeParentPath == null) {
            return false;
        }
        if (dropNodeParentPath.length == 0) {
            return false;
        }
        if (this.contains(dropNodeParentPath, dragNodePath[dragNodePath.length - 1])) {
            return false;
        }
        return dropNodeParentPath[dropNodeParentPath.length - 1] instanceof MutableSimpleNodeInterface;
    }

    private boolean isPreviousSibling(SimpleNodeInterface[] dragNodePath, SimpleNodeInterface[] dropNodeParentPath, int position) {
        if (dragNodePath.length - 1 != dropNodeParentPath.length && Util.unequal((Object)dragNodePath[dragNodePath.length - 2], (Object)dropNodeParentPath[dropNodeParentPath.length - 1])) {
            return false;
        }
        if (position == 0) {
            return false;
        }
        SimpleNodeInterface parent = dropNodeParentPath[dropNodeParentPath.length - 1];
        SimpleNodeInterface node = dragNodePath[dragNodePath.length - 1];
        for (int i = 0; i < position; ++i) {
            if (!Util.equal((Object)node, (Object)parent.getNodeChild(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean performDrop(SimpleNodeInterface[] dragNodePath, SimpleNodeInterface[] dropNodeParentPath, int position) {
        if (this.isPreviousSibling(dragNodePath, dropNodeParentPath, position)) {
            --position;
        }
        MutableSimpleNodeInterface parentDragNode = (MutableSimpleNodeInterface)dragNodePath[dragNodePath.length - 2];
        MutableSimpleNodeInterface dragNode = (MutableSimpleNodeInterface)dragNodePath[dragNodePath.length - 1];
        MutableSimpleNodeInterface dropNode = (MutableSimpleNodeInterface)dropNodeParentPath[dropNodeParentPath.length - 1];
        parentDragNode.removeNodeChild((SimpleNodeInterface)dragNode);
        dropNode.addNodeChild((SimpleNodeInterface)dragNode, position);
        return true;
    }

    private boolean contains(SimpleNodeInterface[] path, SimpleNodeInterface node) {
        if (path == null || path.length == 0) {
            return false;
        }
        for (int i = 0; i < path.length; ++i) {
            if (!Util.equal((Object)path[i], (Object)node)) continue;
            return true;
        }
        return false;
    }
}

