/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.collection.StaticStringListInterface;
import com.sas.collection.StringCollection;
import com.sas.models.ActionInterface;
import com.sas.models.Node;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ActionNode
extends Node
implements ActionInterface {
    static final long serialVersionUID = -7933965243394275784L;
    protected StaticStringListInterface actions = null;
    private transient ActionListener actionListener;

    public ActionNode() {
    }

    public ActionNode(String nodeText) {
        super(nodeText);
    }

    public ActionNode(String nodeText, String nodeType) {
        super(nodeText, nodeType);
    }

    public void setActionList(StaticStringListInterface actionList) {
        if (actionList != null) {
            StringCollection strings = new StringCollection();
            strings.addItems(actionList.getItems());
            this.actions = strings;
        } else {
            this.actions = null;
        }
    }

    public void setActionList(String[] actionList) {
        this.actions = actionList != null ? new StringCollection(actionList) : null;
    }

    @Override
    public Object getActions() {
        return this.actions;
    }

    @Override
    public void performAction(Object action) {
        String str = action.toString();
        this.processActionEvent(new ActionEvent(this, 1, str));
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }
}

