/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mdtable;

import com.sas.ModelInterface;
import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.lang.BooleanDataInterface;
import com.sas.mdtable.Axis;
import com.sas.mdtable.AxisChangedEvent;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelChangedEvent;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.Cell;
import com.sas.mdtable.Dimension;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.Label;
import com.sas.mdtable.Level;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.LevelLabel;
import com.sas.mdtable.MdTo2dFormattedTable;
import com.sas.mdtable.MdTo2dTable;
import com.sas.mdtable.Member;
import com.sas.mdtable.MemberInterface;
import com.sas.mdtable.RB;
import com.sas.mdtable.StaticFormattedDataInterface;
import com.sas.mdtable.StaticMultidimensionalTableInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.table.CellStyle;
import com.sas.table.CellVector;
import com.sas.table.Column;
import com.sas.table.ColumnChangedEvent;
import com.sas.table.DataCell;
import com.sas.table.LabelCell;
import com.sas.table.Row;
import com.sas.table.RowChangedEvent;
import com.sas.table.RowStyle;
import com.sas.table.TableElement;
import com.sas.table.TableView;
import com.sas.util.Command;
import com.sas.util.CommandManager;
import com.sas.util.CommandsInterface;
import com.sas.util.MenuCommand;
import com.sas.util.MenuSeparatorCommand;
import com.sas.util.PreorderTreeIterator;
import com.sas.visuals.util.RubberBand;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class MultidimensionalTableView
extends TableView {
    static final long serialVersionUID = 8914900658001287448L;
    public static final String RB_KEY = "MultidimensionalTableView.";
    public static final int TREE_LAYOUT = 0;
    public static final int OUTLINE_LAYOUT = 1;
    public static final int LEDGER_LAYOUT = 2;
    public static final int CONDENSED_LEDGER_LAYOUT = 3;
    private static final String[] requiredInterfacesString = new String[]{"com.sas.mdtable.StaticMultidimensionalTableInterface"};
    private static final int RESIZE_NONE = 0;
    private static final int RESIZE_HORIZONTALLY = 1;
    private static final int RESIZE_VERTICALLY = 2;
    private static final int REFRESH_COL_AXIS = 1;
    private static final int REFRESH_ROW_AXIS = 2;
    private transient Rectangle m_colLabelBounds;
    private transient Label m_curLabel;
    private transient int m_defaultColumnIndex;
    private transient int m_defaultRowIndex;
    private transient OrderedCollection m_displayedColumnLabels;
    private transient OrderedCollection m_displayedRowLabels;
    private transient int m_flags;
    private transient StaticMultidimensionalTableInterface m_model;
    private transient RubberBand m_resizer;
    private transient Rectangle m_rowLabelBounds;
    private transient Command m_rowLabelsLayoutCommand;
    private transient OrderedCollection m_selectedLabels;
    private transient Command m_transposeCommand;
    private transient Axis m_xAxis;
    private transient Axis m_yAxis;
    private transient int m_printingSpacer;
    MdTo2dTable m_mdTo2d;
    private int m_rowLabelsLayout;
    private boolean m_transposed;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "rowLabelsLayout"}, {"Property editor class", "com.sas.beans.editors._MdTableViewRowLabelsLayoutEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public MultidimensionalTableView() {
        this.initializeTransients();
    }

    @Override
    public synchronized com.sas.table.Cell findCell(Point point) {
        Label label = this.findLabel(point);
        if (label != null) {
            return label;
        }
        com.sas.table.Cell cell = super.findCell(point);
        if (cell != null) {
            return cell;
        }
        if (!this.getOriginCellBounds().contains(point)) {
            return null;
        }
        LevelLabel levelLabel = this.findLevelLabel(point, this.getRowAxis_());
        if (levelLabel == null) {
            levelLabel = this.findLevelLabel(point, this.getColumnAxis_());
        }
        return levelLabel;
    }

    public synchronized Label findLabel(Point point) {
        Label label;
        this.updateView(null);
        if (this.m_rowLabelBounds.contains(point)) {
            label = (Label)this.findRow(point.y).getLabel();
            while (point.x < label.getHorizontalPosition()) {
                label = label.getParent();
            }
        } else if (this.m_colLabelBounds.contains(point)) {
            label = (Label)this.findColumn(point.x).getLabel();
            while (point.y < label.getVerticalPosition()) {
                label = label.getParent();
            }
        } else {
            label = null;
        }
        return label;
    }

    @Override
    public void hold(CellVector cellVector) {
        throw new IllegalStateException();
    }

    @Override
    public StaticOrderedCollectionInterface getHeldRows() {
        return null;
    }

    @Override
    public synchronized void refresh(ModelInterface model) {
        if (model == this.m_model && this.m_mdTo2d != null) {
            this.m_mdTo2d.refresh();
        } else {
            super.refresh(model);
        }
    }

    @Override
    public void scrollToRow(Row row, boolean makeFirst) {
        Axis yAxis;
        if (makeFirst && this.getRowLabelsLayout() == 1 && (yAxis = this.getRowAxis_()) != null) {
            this.updateView(null);
            if ((this.m_flags & 2) != 0) {
                this.m_flags &= 0xFFFFFFFD;
                yAxis.refresh();
            }
            Label label = (Label)row.getLabel();
            while (!label.isLeafNode()) {
                row = row.nextRow();
                label = (Label)row.getLabel();
            }
            Vector<Row> v = null;
            Row lastHeld = null;
            for (Label parent = label.getParent(); parent != null; parent = parent.getParent()) {
                Row r = (Row)parent.getChild();
                if (r.isHeld()) {
                    lastHeld = r;
                    break;
                }
                if (v == null) {
                    v = new Vector<Row>(8, 0);
                }
                v.insertElementAt(r, 0);
            }
            if (lastHeld == null) {
                this.releaseAllRows();
            } else {
                StaticOrderedCollectionInterface heldRows = super.getHeldRows();
                int heldRowCount = heldRows.count();
                int lastHeldIndex = heldRows.getIndex((Object)lastHeld, 0);
                int numToRelease = heldRowCount - (lastHeldIndex + 1);
                for (int i = 0; i < numToRelease; ++i) {
                    this.release((CellVector)heldRows.get(--heldRowCount));
                }
            }
            if (v != null) {
                int maxi = v.size() - 1;
                for (int i = 0; i <= maxi; ++i) {
                    super.hold((CellVector)v.elementAt(i));
                }
            }
        }
        super.scrollToRow(row, makeFirst);
    }

    public AxisInterface getColumnAxis() {
        Axis axis = this.getColumnAxis_();
        return axis != null ? axis.getMetaAxis() : null;
    }

    @Override
    public boolean isColumnLabelsVisible() {
        return true;
    }

    StaticOrderedCollectionInterface getDisplayedColumnLabels() {
        return this.m_displayedColumnLabels;
    }

    StaticOrderedCollectionInterface getDisplayedRowLabels() {
        return this.m_displayedRowLabels;
    }

    public int getPDFPrintingSpacer() {
        return this.m_printingSpacer;
    }

    public void setPDFPrintingSpacer(int spacer) {
        if (spacer != this.m_printingSpacer) {
            int old = this.m_printingSpacer;
            this.m_printingSpacer = spacer;
            this.firePropertyChange("PDFPrintingSpacer", new Integer(old), new Integer(spacer));
        }
    }

    @Override
    public ModelInterface getModelInterface() {
        if (this.m_model != null) {
            return (ModelInterface)this.m_model;
        }
        return super.getModelInterface();
    }

    @Override
    public Rectangle getPaintableBounds() {
        Rectangle bounds = super.getPaintableBounds();
        Insets insets = this.getInsets();
        if (insets.left != bounds.x) {
            int x2 = bounds.x + bounds.width - 1;
            bounds.x = insets.left;
            bounds.width = x2 - bounds.x + 1;
        }
        if (insets.top != bounds.y) {
            int y2 = bounds.y + bounds.height - 1;
            bounds.y = insets.top;
            bounds.height = y2 - bounds.y + 1;
        }
        return bounds;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector requiredInterfaces = super.getRequiredInterfaces();
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public AxisInterface getRowAxis() {
        Axis axis = this.getRowAxis_();
        return axis != null ? axis.getMetaAxis() : null;
    }

    public int getRowLabelsLayout() {
        return this.m_rowLabelsLayout;
    }

    public void setRowLabelsLayout(int newValue) {
        if (this.m_rowLabelsLayout == newValue) {
            return;
        }
        if (newValue != 0 && newValue != 1 && newValue != 2 && newValue != 3) {
            throw new IllegalArgumentException();
        }
        int oldValue = this.m_rowLabelsLayout;
        this.m_rowLabelsLayout = newValue;
        if (this.m_mdTo2d != null) {
            int layout = this.m_mdTo2d.getRowLabelsLayout();
            boolean concatenated = this.m_mdTo2d.isRowLabelsConcatenated();
            this.m_mdTo2d.setRowLabelsLayout(this.m_rowLabelsLayout == 1 ? 2 : 0, this);
            this.m_mdTo2d.setRowLabelsConcatenated(this.m_rowLabelsLayout == 3);
            if (layout == this.m_mdTo2d.getRowLabelsLayout() && concatenated == this.m_mdTo2d.isRowLabelsConcatenated()) {
                this.refresh();
            }
        }
        if (this.anyPropertyChangeListeners()) {
            this.firePropertyChange("rowLabelsLayout", new Integer(oldValue), new Integer(newValue));
        }
    }

    @Override
    public boolean isRowLabelsVisible() {
        return true;
    }

    public boolean isTransposed() {
        return this.m_transposed;
    }

    public void setTransposed(boolean newValue) {
        if (this.m_transposed == newValue) {
            return;
        }
        this.m_transposed = newValue;
        this.m_defaultColumnIndex = 1;
        this.m_defaultRowIndex = 1;
        if (this.m_mdTo2d != null) {
            this.m_mdTo2d.setTransposed(newValue);
        }
        this.firePropertyChange("transposed", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public CellStyle getAxisDefaultCellStyle(AxisInterface axis) {
        return (CellStyle)this.getAxis(axis).getDefaultCellStyle();
    }

    public void setAxisDefaultCellStyle(AxisInterface axis, CellStyle style) {
        this.updateView(null);
        this.getAxis(axis).setDefaultCellStyle((StaticPropertyBagInterface)style);
        this.repaint();
    }

    public CellStyle getAxisDefaultLabelStyle(AxisInterface axis) {
        return (CellStyle)this.getAxis(axis).getDefaultLabelStyle();
    }

    public void setAxisDefaultLabelStyle(AxisInterface axis, CellStyle style) {
        this.updateView(null);
        this.getAxis(axis).setDefaultLabelStyle((StaticPropertyBagInterface)style);
        this.repaint();
    }

    public CellStyle getDimensionDefaultCellStyle(DimensionInterface dimension) {
        return (CellStyle)this.getDimension(dimension).getDefaultCellStyle();
    }

    public void setDimensionDefaultCellStyle(DimensionInterface dimension, CellStyle style) {
        this.updateView(null);
        this.getDimension(dimension).setDefaultCellStyle((StaticPropertyBagInterface)style);
        this.repaint();
    }

    public CellStyle getDimensionDefaultLabelStyle(DimensionInterface dimension) {
        return (CellStyle)this.getDimension(dimension).getDefaultLabelStyle();
    }

    public void setDimensionDefaultLabelStyle(DimensionInterface dimension, CellStyle style) {
        this.updateView(null);
        this.getDimension(dimension).setDefaultLabelStyle((StaticPropertyBagInterface)style);
        this.repaint();
    }

    public CellStyle getLevelDefaultCellStyle(LevelInterface level) {
        return (CellStyle)this.getLevel(level).getDefaultCellStyle();
    }

    public void setLevelDefaultCellStyle(LevelInterface level, CellStyle style) {
        this.updateView(null);
        this.getLevel(level).setDefaultCellStyle((StaticPropertyBagInterface)style);
        this.repaint();
    }

    public CellStyle getLevelDefaultLabelStyle(LevelInterface level) {
        return (CellStyle)this.getLevel(level).getDefaultLabelStyle();
    }

    public void setLevelDefaultLabelStyle(LevelInterface level, CellStyle style) {
        this.updateView(null);
        this.getLevel(level).setDefaultLabelStyle((StaticPropertyBagInterface)style);
        this.repaint();
    }

    public CellStyle getMemberDefaultCellStyle(MemberInterface member) {
        Member mem = this.getMember(member, false);
        return mem != null ? (CellStyle)mem.getDefaultCellStyle() : null;
    }

    public void setMemberDefaultCellStyle(MemberInterface member, CellStyle style) {
        this.updateView(null);
        this.getMember(member, true).setDefaultCellStyle((StaticPropertyBagInterface)style);
        this.repaint();
    }

    public CellStyle getMemberDefaultLabelStyle(MemberInterface member) {
        Member mem = this.getMember(member, false);
        return mem != null ? (CellStyle)mem.getDefaultLabelStyle() : null;
    }

    public void setMemberDefaultLabelStyle(MemberInterface member, CellStyle style) {
        this.updateView(null);
        this.getMember(member, true).setDefaultLabelStyle((StaticPropertyBagInterface)style);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachModel(ModelInterface model) {
        if (model == this.m_mdTo2d) {
            super.attachModel(model);
            this.m_model = (StaticMultidimensionalTableInterface)this.m_mdTo2d.getModelInterface();
            if (this.m_mdTo2d.getRowLabelsLayout() == 2) {
                this.m_mdTo2d.setRowLabelsLayout(2, this);
            }
        } else if (model instanceof StaticMultidimensionalTableInterface) {
            MdTo2dTable mdTo2d = model instanceof StaticFormattedDataInterface ? new MdTo2dFormattedTable() : new MdTo2dTable();
            int layout = this.getRowLabelsLayout();
            mdTo2d.setRowLabelsLayout(layout == 1 ? 2 : 0, this);
            mdTo2d.setRowLabelsConcatenated(layout == 3);
            mdTo2d.setColumnLabelsConcatenated(false);
            mdTo2d.setTransposed(this.isTransposed());
            mdTo2d.setModelInterface(model);
            try {
                super.attachModel((ModelInterface)mdTo2d);
                this.m_mdTo2d = mdTo2d;
                this.m_model = (StaticMultidimensionalTableInterface)model;
            }
            finally {
                if (this.m_mdTo2d == null) {
                    mdTo2d.setModelInterface(null);
                }
            }
        } else {
            super.attachModel(model);
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        if (model == this.m_model) {
            super.detachModel((ModelInterface)this.m_mdTo2d);
        } else {
            super.detachModel(model);
        }
        this.m_model = null;
        if (this.m_mdTo2d != null) {
            this.m_mdTo2d.setModelInterface(null);
            this.m_mdTo2d = null;
        }
        this.m_defaultColumnIndex = 0;
        this.m_defaultRowIndex = 0;
    }

    @Override
    public void contentsChanged(ContentsChangedEvent e) {
        AxisInterface axis = null;
        AxisLabelInterface label = null;
        boolean expandCollapse = false;
        boolean callSuper = true;
        if (e instanceof AxisChangedEvent) {
            AxisChangedEvent ace = (AxisChangedEvent)e;
            axis = ace.axis;
            label = ace.focusLabel;
        } else if (e instanceof AxisLabelChangedEvent) {
            expandCollapse = true;
            AxisLabelChangedEvent alce = (AxisLabelChangedEvent)e;
            label = alce.label;
            axis = label.getAxis();
        }
        if (axis != null || label != null) {
            if (this.m_xAxis != null && (axis == null || this.m_xAxis.getMetaAxis() == axis)) {
                this.m_flags |= 1;
                if (label != null && (axis != null || label.getAxis() == this.m_xAxis.getMetaAxis())) {
                    this.m_defaultColumnIndex = label.getMinimumCoordinate() + 1;
                    if (expandCollapse && this.m_defaultColumnIndex != 0) {
                        try {
                            if (this.getColumn(this.m_defaultColumnIndex).isDisplayed()) {
                                this.m_defaultColumnIndex = ((CellVector)this.getDisplayedColumns().get(0)).getIndex();
                            }
                        }
                        catch (IndexOutOfBoundsException alce) {
                            // empty catch block
                        }
                    }
                }
                super.contentsChanged(new ColumnChangedEvent(e.getSource()));
                callSuper = false;
            }
            if (this.m_yAxis != null && (axis == null || this.m_yAxis.getMetaAxis() == axis)) {
                this.m_flags |= 2;
                if (label != null && (axis != null || label.getAxis() == this.m_yAxis.getMetaAxis())) {
                    if (this.getRowLabelsLayout() == 1) {
                        PreorderTreeIterator pti = null;
                        pti = axis != null ? new PreorderTreeIterator((TreeInterface)axis) : new PreorderTreeIterator((TreeInterface)label.getAxis());
                        pti.setNode((SimpleNodeInterface)label);
                        this.m_defaultRowIndex = pti.getNodeIndex();
                    } else {
                        this.m_defaultRowIndex = label.getMinimumCoordinate() + 1;
                    }
                    if (expandCollapse && this.m_defaultRowIndex != 0) {
                        try {
                            if (this.getRow(this.m_defaultRowIndex).isDisplayed()) {
                                this.m_defaultRowIndex = ((CellVector)this.getDisplayedRows().get(0)).getIndex();
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
                super.contentsChanged(new RowChangedEvent(e.getSource()));
                callSuper = false;
            }
        }
        if (callSuper) {
            super.contentsChanged(e);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.getDefaultLabelStyle().setWrapped(true);
        RowStyle rowStyle = this.getDefaultRowStyle();
        CellStyle cellStyle = null;
        if (rowStyle.isDefaultLabelStyleSet()) {
            cellStyle = rowStyle.getDefaultLabelStyle();
        }
        if (cellStyle == null) {
            cellStyle = new CellStyle();
        }
        cellStyle.setHorizontalJustification(1);
        rowStyle.setDefaultLabelStyle(cellStyle);
    }

    @Override
    protected void cloneModelDependentState(TableView clone, double horizontalScale, double verticalScale) throws CloneNotSupportedException {
        super.cloneModelDependentState(clone, horizontalScale, verticalScale);
        MultidimensionalTableView mtvClone = (MultidimensionalTableView)clone;
        Axis axis = this.getColumnAxis_();
        if (axis != null) {
            axis.copyLevelSizes(mtvClone.getColumnAxis_(), horizontalScale);
        }
        if ((axis = this.getRowAxis_()) != null) {
            axis.copyLevelSizes(mtvClone.getRowAxis_(), verticalScale);
        }
    }

    @Override
    protected void cloneModelIndependentState(TableView clone, double horizontalScale, double verticalScale) throws CloneNotSupportedException {
        super.cloneModelIndependentState(clone, horizontalScale, verticalScale);
        MultidimensionalTableView mtvClone = (MultidimensionalTableView)clone;
        mtvClone.setRowLabelsLayout(this.getRowLabelsLayout());
        mtvClone.setTransposed(this.isTransposed());
        mtvClone.setPDFPrintingSpacer(this.getPDFPrintingSpacer());
    }

    @Override
    protected DataCell createCell(Row row, Column col) {
        if (this.getColumnAxis_() == null || this.getRowAxis_() == null) {
            return super.createCell(row, col);
        }
        return new Cell(this, row, col);
    }

    @Override
    protected LabelCell createColumnLabel(Column col) {
        Axis axis = this.getColumnAxis_();
        if (axis == null) {
            return super.createColumnLabel(col);
        }
        return axis.createLabel(col.getIndex() - 1);
    }

    @Override
    protected LabelCell createRowLabel(Row row) {
        Axis axis = this.getRowAxis_();
        if (axis == null) {
            return super.createRowLabel(row);
        }
        return axis.createLabel(row.getIndex() - 1);
    }

    @Override
    protected int getDefaultColumnIndex() {
        if (this.m_defaultColumnIndex == 0) {
            return super.getDefaultColumnIndex();
        }
        return this.m_defaultColumnIndex;
    }

    @Override
    protected int getDefaultRowIndex() {
        if (this.m_defaultRowIndex == 0) {
            return super.getDefaultRowIndex();
        }
        return this.m_defaultRowIndex;
    }

    @Override
    protected Insets getLabelInsets() {
        if (this.m_model == null) {
            return super.getLabelInsets();
        }
        Insets insets = this.getInsets();
        insets.top = this.m_rowLabelBounds.y;
        insets.left = this.m_colLabelBounds.x;
        return insets;
    }

    @Override
    protected Rectangle getTableBounds(Graphics g) {
        Rectangle bounds = super.getTableBounds(g);
        bounds.width += bounds.x - this.m_rowLabelBounds.x;
        bounds.x = this.m_rowLabelBounds.x;
        bounds.height += bounds.y - this.m_colLabelBounds.y;
        bounds.y = this.m_colLabelBounds.y;
        return bounds;
    }

    @Override
    protected TableView newTableView() {
        return new MultidimensionalTableView();
    }

    @Override
    protected void paintTable(Graphics g, Rectangle invalidBounds) {
        super.paintTable(g, invalidBounds);
        this.m_defaultColumnIndex = 0;
        this.m_defaultRowIndex = 0;
        if (this.m_model == null) {
            return;
        }
        Rectangle originCellBounds = this.getOriginCellBounds();
        if (invalidBounds.intersects(originCellBounds)) {
            Axis yAxis;
            Axis xAxis = this.getColumnAxis_();
            if (xAxis != null) {
                xAxis.paintLevelLabels(g);
            }
            if ((yAxis = this.getRowAxis_()) != null) {
                yAxis.paintLevelLabels(g);
            }
        }
        if (invalidBounds.intersects(this.m_rowLabelBounds)) {
            int layout = this.getRowLabelsLayout();
            if (layout == 1 || layout == 3) {
                StaticOrderedCollectionInterface rows = this.getDisplayedRows();
                int maxy = invalidBounds.y + invalidBounds.height - 1;
                int maxi = rows.count();
                for (int i = 0; i < maxi; ++i) {
                    Row row = (Row)rows.get(i);
                    int bottomEdge = row.getBottomEdge();
                    if (invalidBounds.y > bottomEdge) continue;
                    row.getLabel().paint(g);
                    if (maxy > bottomEdge) {
                        continue;
                    }
                    break;
                }
            } else {
                this.paintDisplayedChildren(g, (StaticOrderedCollectionInterface)this.m_displayedRowLabels);
            }
        }
        if (invalidBounds.intersects(this.m_colLabelBounds)) {
            this.paintDisplayedChildren(g, (StaticOrderedCollectionInterface)this.m_displayedColumnLabels);
        }
    }

    @Override
    protected void populatePopupMenu(PopupMenu popupMenu, TableElement element) {
        Command[] cmds = this.getContextCommands(element, -1, -1);
        CommandManager.addCommands((Menu)popupMenu, (Command[])cmds, (Object)this);
        if (element != null) {
            if (cmds.length != 0) {
                CommandManager.addCommand((Menu)popupMenu, (Command)MenuSeparatorCommand.instance(), (Object)this);
            }
            CommandManager.addCommands((Menu)popupMenu, (Command[])this.getContextCommands(null, -1, -1), (Object)this);
        }
    }

    @Override
    protected void onAllChanged() {
        this.m_xAxis = null;
        this.m_yAxis = null;
        this.m_colLabelBounds.height = 0;
        this.m_colLabelBounds.width = 0;
        this.m_rowLabelBounds.height = 0;
        this.m_rowLabelBounds.width = 0;
        super.onAllChanged();
    }

    @Override
    protected void formatView(Graphics g) {
        Axis yAxis;
        Insets insets = this.getInsets();
        this.m_colLabelBounds.y = insets.top;
        this.m_rowLabelBounds.x = insets.left;
        Axis xAxis = this.getColumnAxis_();
        if (xAxis != null) {
            if ((this.m_flags & 1) != 0) {
                this.m_flags &= 0xFFFFFFFE;
                xAxis.refresh();
            }
            if (g == null) {
                g = this.getGraphics();
            }
            this.m_colLabelBounds.height = g != null ? xAxis.computePreferredSize(g) : 0;
            xAxis.setPosition(this.m_colLabelBounds.y);
        }
        if ((yAxis = this.getRowAxis_()) != null) {
            if ((this.m_flags & 2) != 0) {
                this.m_flags &= 0xFFFFFFFD;
                yAxis.refresh();
            }
            if (g == null) {
                g = this.getGraphics();
            }
            this.m_rowLabelBounds.width = g != null ? yAxis.computePreferredSize(g) : 0;
            yAxis.setPosition(this.m_rowLabelBounds.x);
        }
        this.m_colLabelBounds.x = this.m_rowLabelBounds.x + this.m_rowLabelBounds.width;
        this.m_rowLabelBounds.y = this.m_colLabelBounds.y + this.m_colLabelBounds.height;
        super.formatView(g);
    }

    @Override
    protected void updateDisplayedColumns(Graphics g) {
        this.removeDisplayedChildren(this.m_displayedColumnLabels);
        super.updateDisplayedColumns(g);
        if (this.getColumnAxis_() == null) {
            return;
        }
        this.m_colLabelBounds.width = 0;
        StaticOrderedCollectionInterface cols = this.getDisplayedColumns();
        int maxi = cols.count();
        block0: for (int i = 0; i < maxi; ++i) {
            Column col = (Column)cols.get(i);
            Label label = (Label)col.getLabel();
            int x = col.getPosition();
            int y = label.getLevel_().getPosition();
            int width = col.getSize();
            int height = this.m_rowLabelBounds.y - y;
            label.bounds.setBounds(x, y, width, height);
            width = col.getDisplayedSize();
            while (true) {
                Label parent;
                if ((parent = label.getParent()) == null) {
                    this.m_colLabelBounds.width += width;
                    if (this.m_displayedColumnLabels.contains((Object)label)) continue block0;
                    this.m_displayedColumnLabels.add((Object)label);
                    continue block0;
                }
                int newy = parent.getLevel_().getPosition();
                height = y - newy;
                y = newy;
                if (parent.displayedChildren.count() == 0) {
                    parent.bounds.setBounds(x, y, width, height);
                } else {
                    parent.bounds.width += width;
                }
                if (!parent.displayedChildren.contains((Object)label)) {
                    parent.displayedChildren.add((Object)label);
                }
                label = parent;
            }
        }
    }

    @Override
    protected void updateDisplayedRows(Graphics g) {
        this.removeDisplayedChildren(this.m_displayedRowLabels);
        super.updateDisplayedRows(g);
        if (this.getRowAxis_() == null) {
            return;
        }
        this.m_rowLabelBounds.height = 0;
        StaticOrderedCollectionInterface rows = this.getDisplayedRows();
        int layout = this.getRowLabelsLayout();
        if (layout == 1 || layout == 3) {
            Row row = null;
            int x = this.m_rowLabelBounds.x;
            int width = this.m_colLabelBounds.x - x;
            int maxi = rows.count();
            for (int i = 0; i < maxi; ++i) {
                row = (Row)rows.get(i);
                Label label = (Label)row.getLabel();
                label.bounds.setBounds(x, row.getPosition(), width, row.getSize());
            }
            if (row != null) {
                this.m_rowLabelBounds.height = row.getPosition() - this.m_rowLabelBounds.y + row.getDisplayedSize();
            }
            return;
        }
        int maxi = rows.count();
        block1: for (int i = 0; i < maxi; ++i) {
            Row row = (Row)rows.get(i);
            Label label = (Label)row.getLabel();
            int x = label.getLevel_().getPosition();
            int y = row.getPosition();
            int width = this.m_colLabelBounds.x - x;
            int height = row.getSize();
            label.bounds.setBounds(x, y, width, height);
            height = row.getDisplayedSize();
            while (true) {
                Label parent;
                if ((parent = label.getParent()) == null) {
                    this.m_rowLabelBounds.height += height;
                    if (layout != 2 && this.m_displayedRowLabels.contains((Object)label)) continue block1;
                    this.m_displayedRowLabels.add((Object)label);
                    continue block1;
                }
                int newx = parent.getLevel_().getPosition();
                width = x - newx;
                x = newx;
                if (parent.displayedChildren.count() == 0) {
                    parent.bounds.setBounds(x, y, width, height);
                } else {
                    parent.bounds.height += height;
                }
                if (layout == 2 || !parent.displayedChildren.contains((Object)label)) {
                    parent.displayedChildren.add((Object)label);
                }
                label = parent;
            }
        }
    }

    @Override
    protected void onSizeColumn(Column col, Graphics g) {
        super.onSizeColumn(col, g);
        if (this.getColumnAxis_() == null) {
            return;
        }
        if (!this.isColumnLabelsVisible()) {
            return;
        }
        Label label = (Label)col.getLabel();
        while ((label = label.getParent()) != null) {
            if (!this.sizeCellVectors(label.getCellVectorChildren(), label.getPreferredWidth(g, label.getLevel_().getSize()), g)) continue;
            return;
        }
    }

    @Override
    protected void onSizeRow(Row row, Graphics g) {
        super.onSizeRow(row, g);
        if (this.getRowAxis_() == null || !this.isRowLabelsVisible() || this.getRowLabelsLayout() == 1) {
            return;
        }
        Label label = (Label)row.getLabel();
        while ((label = label.getParent()) != null) {
            if (!this.sizeCellVectors(label.getCellVectorChildren(), label.getPreferredHeight(g, label.getLevel_().getSize()), g)) continue;
            return;
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent me) {
        block25: {
            int id;
            Point point;
            block27: {
                block28: {
                    block26: {
                        point = me.getPoint();
                        if (me.isConsumed()) break block25;
                        id = me.getID();
                        if (this.m_resizer == null) break block26;
                        if (id == 502) {
                            this.m_resizer.stop();
                            this.m_resizer = null;
                        }
                        me.consume();
                        break block25;
                    }
                    if (id != 501) break block27;
                    if ((me.getModifiers() & 0x10) != 0) break block28;
                    if ((me.getModifiers() & (0x10 | 8 | 4)) != 0) break block25;
                }
                if (!me.isPopupTrigger() && this.resizeHitTest(me.getPoint(), true) != 0) {
                    me.consume();
                }
                break block25;
            }
            if (id == 500 && me.getClickCount() == 2 && Util.isLeftMouseButton(me)) {
                if (this.getCursor() == Cursor.getPredefinedCursor(11)) {
                    Label label = this.findLabel(point);
                    if (label == null) {
                        return;
                    }
                    int left = label.getHorizontalPosition();
                    int right = left + label.getWidth() - 1;
                    if (point.x < right - 3) {
                        if (point.x < left + 3) {
                            Point pnt = new Point(left - 1, point.y);
                            label = this.findLabel(pnt);
                            if (label == null) {
                                return;
                            }
                        } else {
                            return;
                        }
                    }
                    if (label.isColumnLabel()) {
                        this.resizeColumnLabelToPreferredSize(label);
                    } else if (label.isRowLabel()) {
                        this.resizeRowLevelToPreferredSize(label);
                    }
                    me.consume();
                    return;
                }
                if (this.getCursor() == Cursor.getPredefinedCursor(8)) {
                    Label label = this.findLabel(point);
                    if (label == null) {
                        return;
                    }
                    int top = label.getVerticalPosition();
                    int bottom = top + label.getHeight() - 1;
                    if (point.y < bottom - 3) {
                        if (point.y < top + 3) {
                            Point pnt = new Point(point.x, top - 1);
                            label = this.findLabel(pnt);
                            if (label == null) {
                                return;
                            }
                        } else {
                            return;
                        }
                    }
                    if (label.isRowLabel()) {
                        this.resizeRowLabelToPreferredSize(label);
                    } else if (label.isColumnLabel()) {
                        this.resizeColumnLevelToPreferredSize(label);
                    }
                    me.consume();
                    return;
                }
                if ((me.getModifiers() & 2) == 0) {
                    Command cmd;
                    AxisLabelInterface label;
                    TableElement curElement;
                    if ((me.getModifiers() & 1) == 0 && (curElement = this.getCurrentElement()) != null && curElement instanceof Label && (label = ((Label)curElement).getMetaLabel()) instanceof Command && (cmd = (Command)label).isExecutable()) {
                        cmd.execute((Object)this);
                        me.consume();
                    }
                }
            }
        }
        super.processMouseEvent(me);
    }

    private void resizeColumnLevelToPreferredSize(Label label) {
        Level level = label.getLevel_();
        level.setSize(level.getPreferredSize());
        this.repaintColumns();
    }

    private void resizeColumnLabelToPreferredSize(Label label) {
        if (label.isLeafNode()) {
            CellVector cv = label.getFirstCellVector();
            cv.setSize(cv.getPreferredSize());
        } else {
            OrderedCollection labels = label.getCellVectorChildrenAsCollection();
            for (int i = 0; i < labels.count(); ++i) {
                if (!(labels.get(i) instanceof CellVector)) continue;
                ((CellVector)labels.get(i)).setSize(((CellVector)labels.get(i)).getPreferredSize());
            }
        }
        this.repaintColumns();
    }

    private void resizeRowLevelToPreferredSize(Label label) {
        Level level = label.getLevel_();
        MultidimensionalTableView mtv = level.getTableView();
        int layout = mtv.getRowLabelsLayout();
        if (layout == 1 || layout == 3) {
            Column cv = mtv.getRowAxis_().m_rowLabelsColumn;
            cv.setSize(cv.getPreferredSize());
            mtv.remeasureAllColumns(true);
        } else {
            level.setSize(level.getPreferredSize());
        }
        this.repaintColumns();
    }

    private void resizeRowLabelToPreferredSize(Label label) {
        int layout = ((MultidimensionalTableView)label.getTableView()).getRowLabelsLayout();
        if (label.isLeafNode() || layout == 1) {
            CellVector cv = label.getFirstCellVector();
            cv.setSize(cv.getPreferredSize());
        } else if (layout == 0) {
            OrderedCollection labels = label.getCellVectorChildrenAsCollection();
            for (int i = 0; i < labels.count(); ++i) {
                if (!(labels.get(i) instanceof CellVector)) continue;
                ((CellVector)labels.get(i)).setSize(((CellVector)labels.get(i)).getPreferredSize());
            }
        } else {
            if (layout != 2) {
                return;
            }
            Label label2 = label;
            while (!(label2 = (Label)label2.m_children.elementAt(0)).isLeafNode()) {
            }
            CellVector cv = label2.getFirstCellVector();
            cv.setSize(cv.getPreferredSize());
        }
        this.repaintRows();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent me) {
        if (!me.isConsumed() && this.m_resizer != null) {
            me.consume();
        }
        super.processMouseMotionEvent(me);
    }

    @Override
    protected void setCursor(Point point) {
        switch (this.resizeHitTest(point, false)) {
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 2: {
                this.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            default: {
                super.setCursor(point);
            }
        }
    }

    Axis getColumnAxis_() {
        AxisInterface axis;
        if (this.m_xAxis == null && this.m_mdTo2d != null && (axis = this.m_mdTo2d.getColumnAxis()) != null) {
            this.m_xAxis = new Axis(this, axis);
        }
        return this.m_xAxis;
    }

    Axis getRowAxis_() {
        AxisInterface axis;
        if (this.m_yAxis == null && this.m_mdTo2d != null && (axis = this.m_mdTo2d.getRowAxis()) != null) {
            this.m_yAxis = new Axis(this, axis);
        }
        return this.m_yAxis;
    }

    Axis getAxis(AxisInterface axisI) {
        Axis axis = this.getColumnAxis_();
        if (axis != null && axis.getMetaAxis().equals(axisI)) {
            return axis;
        }
        axis = this.getRowAxis_();
        if (axis != null && axis.getMetaAxis().equals(axisI)) {
            return axis;
        }
        throw new IllegalArgumentException();
    }

    Dimension getDimension(DimensionInterface dimI) {
        return this.getAxis(dimI.getAxis()).getDimension(dimI);
    }

    Level getLevel(LevelInterface levI) {
        return this.getDimension(levI.getDimension()).getLevel(levI);
    }

    Member getMember(MemberInterface memI, boolean create) {
        return this.getLevel(memI.getLevel()).getMember(memI, create);
    }

    private LevelLabel findLevelLabel(Point point, Axis axis) {
        int maxd = axis.getDimensionCount();
        for (int d = 0; d < maxd; ++d) {
            Dimension dim = (Dimension)axis.getDimension(d);
            int maxl = dim.getLevelCount();
            for (int l = 0; l < maxl; ++l) {
                LevelLabel label = ((Level)dim.getLevel(l)).getLabelCell();
                if (!label.isDisplayed() || !label.getBounds().contains(point)) continue;
                return label;
            }
        }
        return null;
    }

    @Override
    public Command[] getContextCommands(Object context, int x, int y) {
        Object o;
        StaticPropertyBagInterface style;
        Object[] cmds = null;
        Object subContext = context;
        if (context == this) {
            subContext = this.getCurrentElement();
        }
        if (subContext instanceof Label) {
            Label label = (Label)subContext;
            cmds = label.getCommands();
        } else if (subContext instanceof LevelLabel) {
            LevelInterface level = ((LevelLabel)subContext).getLevel().getMetaLevel();
            if (level instanceof CommandsInterface) {
                cmds = ((CommandsInterface)level).getCommands();
            }
        } else if (subContext instanceof DataCell && (style = ((DataCell)subContext).getModelStyle()) != null && (o = style.get("Commands", null)) instanceof CommandsInterface) {
            cmds = ((CommandsInterface)o).getCommands();
        }
        int cmdCount = 0;
        if (cmds != null) {
            cmdCount = cmds.length;
        }
        Vector<Object> vector = new Vector<Object>(cmdCount + 3);
        for (int i = 0; i < cmdCount; ++i) {
            vector.addElement(cmds[i]);
        }
        if (context == this || context == null) {
            if (cmdCount != 0) {
                vector.addElement(MenuSeparatorCommand.instance());
            }
            vector.addElement(this.getTransposeCommand());
            vector.addElement(this.getRowLabelsLayoutCommand());
        }
        if ((cmdCount = vector.size()) == 0) {
            cmds = CommandManager.getEmptyCommandArray();
        } else {
            cmds = new Command[cmdCount];
            vector.copyInto(cmds);
        }
        return cmds;
    }

    private Command getTransposeCommand() {
        if (this.m_transposeCommand == null) {
            this.m_transposeCommand = new TransposeCommand(this);
        }
        return this.m_transposeCommand;
    }

    private Command getRowLabelsLayoutCommand() {
        if (this.m_rowLabelsLayoutCommand == null) {
            this.m_rowLabelsLayoutCommand = new RowLabelsLayoutMenu(this);
        }
        return this.m_rowLabelsLayoutCommand;
    }

    private void initializeTransients() {
        this.m_colLabelBounds = new Rectangle();
        this.m_displayedColumnLabels = new OrderedCollection();
        this.m_displayedRowLabels = new OrderedCollection();
        this.m_rowLabelBounds = new Rectangle();
        this.m_selectedLabels = new OrderedCollection();
        this.m_printingSpacer = 0;
    }

    private void paintDisplayedChildren(Graphics g, StaticOrderedCollectionInterface list) {
        if (list != null) {
            int maxi = list.count();
            for (int i = 0; i < maxi; ++i) {
                Label label = (Label)list.get(i);
                this.paintDisplayedChildren(g, (StaticOrderedCollectionInterface)label.displayedChildren);
                label.paint(g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDisplayedChildren(OrderedCollection list) {
        if (list == null) {
            return;
        }
        OrderedCollection orderedCollection = list;
        synchronized (orderedCollection) {
            int maxi = list.count();
            for (int i = 0; i < maxi; ++i) {
                Label label = (Label)list.get(i);
                this.removeDisplayedChildren(label.displayedChildren);
            }
            list.removeAll();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            stream.defaultReadObject();
        }
        finally {
            this.initializeTransients();
        }
    }

    private int resizeHitTest(Point point, boolean resize) {
        return this.resizeHitTest(point, resize, null, point);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int resizeHitTest(Point point, boolean resize, Label label, Point origPoint) {
        int left;
        int right;
        if (label == null) {
            label = this.findLabel(point);
        }
        if (label == null) return 0;
        if (label.isColumnLabel()) {
            int top;
            int bottom;
            int left2 = label.getHorizontalPosition();
            int right2 = left2 + label.getWidth() - 1;
            if (point.x < right2 - 3) {
                if (point.x < left2 + 3) {
                    return this.resizeHitTest(new Point(left2 - 1, point.y), resize, null, origPoint);
                }
            } else if (!label.isPartiallyDisplayed()) {
                if (!resize) return 1;
                this.m_resizer = new ColumnLabelResizer(label);
                Rectangle r1 = label.getBounds();
                Rectangle r2 = this.getDataCellBounds();
                r1.height = r2.y - r1.y + r2.height;
                this.m_resizer.start(this, r1, origPoint);
                return 1;
            }
            if (point.y < (bottom = (top = label.getVerticalPosition()) + label.getHeight() - 1) - 3) {
                if (point.y >= top + 3) return 0;
                return this.resizeHitTest(new Point(point.x, top - 1), resize, null, origPoint);
            }
            if (!resize) return 2;
            this.m_resizer = new ColumnLevelResizer(label.getLevel_());
            this.m_resizer.start(this, label.getBounds(), origPoint);
            return 2;
        }
        if (!label.isRowLabel()) return 0;
        int top = label.getVerticalPosition();
        int bottom = top + label.getHeight() - 1;
        if (point.y < bottom - 3) {
            if (point.y < top + 3) {
                return this.resizeHitTest(new Point(point.x, top - 1), resize, null, origPoint);
            }
        } else if (!label.isPartiallyDisplayed()) {
            if (!resize) return 2;
            this.m_resizer = new RowLabelResizer(label);
            Rectangle r1 = label.getBounds();
            Rectangle r2 = this.getDataCellBounds();
            r1.width = r2.x - r1.x + r2.width;
            this.m_resizer.start(this, r1, origPoint);
            return 2;
        }
        if (point.x < (right = (left = label.getHorizontalPosition()) + label.getWidth() - 1) - 3) {
            if (point.x >= left + 3) return 0;
            return this.resizeHitTest(new Point(left - 1, point.y), resize, null, origPoint);
        }
        if (!resize) return 1;
        this.m_resizer = new RowLevelResizer(label.getLevel_());
        this.m_resizer.start(this, label.getBounds(), origPoint);
        return 1;
    }

    private boolean sizeCellVectors(Enumeration cellVectors, int labelSize, Graphics g) {
        int cellVectorsSize = 0;
        OrderedCollection cvs = null;
        while (cellVectors.hasMoreElements()) {
            CellVector cv = (CellVector)cellVectors.nextElement();
            if (cv.getSize() == 0) {
                if (cv instanceof Column) {
                    this.onSizeColumn((Column)cv, g);
                } else {
                    this.onSizeRow((Row)cv, g);
                }
                return true;
            }
            if ((cellVectorsSize += cv.getSize()) >= labelSize) {
                return false;
            }
            if (cvs == null) {
                cvs = new OrderedCollection();
            }
            cvs.add((Object)cv);
        }
        if (cvs != null) {
            CellVector.resize(cvs, labelSize, false);
        }
        return false;
    }

    private final class TransposeCommand
    extends MdTableViewCommand {
        public TransposeCommand(MultidimensionalTableView mtv) {
            super(mtv);
            this.setText(RB.getStringResource(MultidimensionalTableView.RB_KEY, "popupMenu.rotate.txt"));
        }

        public void execute(Object arg) {
            this._table.setTransposed(!this._table.isTransposed());
        }
    }

    private final class RowLabelsLayoutMenu
    extends MdTableViewCommand
    implements MenuCommand {
        RowLabelsLayoutCommand[] _cmds;

        public RowLabelsLayoutMenu(MultidimensionalTableView mtv) {
            super(mtv);
            this.setText(RB.getStringResource(MultidimensionalTableView.RB_KEY, "popupMenu.rowLabelsLayout.txt"));
        }

        public void execute(Object arg) {
        }

        public boolean isSeparator() {
            return false;
        }

        public Command[] getCommands() {
            if (this._cmds == null) {
                this._cmds = new RowLabelsLayoutCommand[4];
                this._cmds[0] = new RowLabelsLayoutCommand(this._table, 0, RB.getStringResource(MultidimensionalTableView.RB_KEY, "popupMenu.tree.txt"));
                this._cmds[1] = new RowLabelsLayoutCommand(this._table, 1, RB.getStringResource(MultidimensionalTableView.RB_KEY, "popupMenu.outline.txt"));
                this._cmds[2] = new RowLabelsLayoutCommand(this._table, 2, RB.getStringResource(MultidimensionalTableView.RB_KEY, "popupMenu.ledger.txt"));
                this._cmds[3] = new RowLabelsLayoutCommand(this._table, 3, RB.getStringResource(MultidimensionalTableView.RB_KEY, "popupMenu.condensedLedger.txt"));
            }
            return this._cmds;
        }
    }

    private final class ColumnLabelResizer
    extends RubberBand {
        private Label m_label;

        public ColumnLabelResizer(Label label) {
            this.setConstraints(1);
            Rectangle r = MultidimensionalTableView.this.getPaintableBounds();
            this.setMaximumWidth(r.width - (label.getHorizontalPosition() - r.x));
            this.m_label = label;
        }

        @Override
        public void stop() {
            super.stop();
            int sizeOffset = this.getBounds().width - this.getInitialBounds().width;
            if (this.m_label.isLeafNode()) {
                CellVector cv = this.m_label.getFirstCellVector();
                cv.setSize(cv.getSize() + sizeOffset);
            } else {
                CellVector.resize(this.m_label.getCellVectorChildrenAsCollection(), sizeOffset, true, false);
            }
            MultidimensionalTableView.this.repaintColumns();
        }
    }

    private final class ColumnLevelResizer
    extends RubberBand {
        private Level m_level;

        public ColumnLevelResizer(Level level) {
            this.setConstraints(0);
            Rectangle r = MultidimensionalTableView.this.getPaintableBounds();
            this.setMaximumHeight(r.height - (level.getPosition() - r.y));
            this.m_level = level;
        }

        @Override
        public void stop() {
            super.stop();
            this.m_level.setSize(this.m_level.getSize() + this.getBounds().height - this.getInitialBounds().height);
        }
    }

    private final class RowLabelResizer
    extends RubberBand {
        private Label m_label;

        public RowLabelResizer(Label label) {
            this.setConstraints(0);
            Rectangle r = MultidimensionalTableView.this.getPaintableBounds();
            this.setMaximumHeight(r.height - (label.getVerticalPosition() - r.y));
            this.m_label = label;
        }

        @Override
        public void stop() {
            super.stop();
            int sizeOffset = this.getBounds().height - this.getInitialBounds().height;
            int layout = ((MultidimensionalTableView)this.m_label.getTableView()).getRowLabelsLayout();
            if (this.m_label.isLeafNode() || layout == 1) {
                CellVector cv = this.m_label.getFirstCellVector();
                cv.setSize(cv.getSize() + sizeOffset);
            } else if (layout == 0) {
                CellVector.resize(this.m_label.getCellVectorChildrenAsCollection(), sizeOffset, true, false);
            } else {
                if (layout != 2) {
                    throw new IllegalStateException();
                }
                Label label = this.m_label;
                while (!(label = (Label)label.m_children.elementAt(0)).isLeafNode()) {
                }
                CellVector cv = label.getFirstCellVector();
                cv.setSize(cv.getSize() + sizeOffset);
            }
            MultidimensionalTableView.this.repaintRows();
        }
    }

    private final class RowLevelResizer
    extends RubberBand {
        private Level m_level;

        public RowLevelResizer(Level level) {
            this.setConstraints(1);
            Rectangle r = MultidimensionalTableView.this.getPaintableBounds();
            if (level.getTableView().getRowLabelsLayout() == 1) {
                this.setMaximumWidth(r.width);
            } else {
                this.setMaximumWidth(r.width - (level.getPosition() - r.x));
            }
            this.m_level = level;
        }

        @Override
        public void stop() {
            super.stop();
            int sizeOffset = this.getBounds().width - this.getInitialBounds().width;
            MultidimensionalTableView mtv = this.m_level.getTableView();
            int layout = mtv.getRowLabelsLayout();
            if (layout == 1 || layout == 3) {
                Column cv = mtv.getRowAxis_().m_rowLabelsColumn;
                cv.setSize(cv.getSize() + sizeOffset);
                mtv.remeasureAllColumns(true);
            } else {
                this.m_level.setSize(this.m_level.getSize() + sizeOffset);
            }
        }
    }

    private final class RowLabelsLayoutCommand
    extends MdTableViewCommand
    implements BooleanDataInterface {
        private int _layout;

        public RowLabelsLayoutCommand(MultidimensionalTableView mtv, int layout, String text) {
            super(mtv);
            this._layout = layout;
            this.setText(text);
        }

        public final void execute(Object arg) {
            this.setBooleanData(!this.getBooleanData());
        }

        public boolean getBooleanData() {
            return this._table.getRowLabelsLayout() == this._layout;
        }

        public void setBooleanData(boolean newValue) {
            this._table.setRowLabelsLayout(this._layout);
        }
    }

    private abstract class MdTableViewCommand
    implements Command {
        protected MultidimensionalTableView _table;
        private String _text;

        public MdTableViewCommand(MultidimensionalTableView mtv) {
            this._table = mtv;
        }

        public boolean isExecutable() {
            return true;
        }

        public boolean isUndoable() {
            return false;
        }

        public void undo() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String getText() {
            return this._text;
        }

        public void setText(String newValue) {
            this._text = newValue;
        }
    }
}

