/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mdtable;

import com.sas.mdtable.AbstractNode;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.HierarchyInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.table.TableException;
import java.util.NoSuchElementException;

public abstract class AbstractHierarchy
extends AbstractNode
implements HierarchyInterface {
    private DimensionInterface m_dimension;

    public AbstractHierarchy(DimensionInterface dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        this.m_dimension = dimension;
    }

    @Override
    public final DimensionInterface getDimension() {
        return this.m_dimension;
    }

    @Override
    public LevelInterface[] getLevels(int index, int count) throws TableException {
        int maxCount = this.getLevelCount();
        if (index + count > maxCount) {
            count = maxCount - index;
        }
        LevelInterface[] array = new LevelInterface[count];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getLevel(index + i);
        }
        return array;
    }

    public final SimpleNodeInterface getNodeChild(int index) {
        try {
            return this.getLevel(index);
        }
        catch (TableException tex) {
            throw new NoSuchElementException();
        }
    }

    public final int getNodeChildCount() {
        try {
            return this.getLevelCount();
        }
        catch (TableException tex) {
            return 0;
        }
    }

    public final SimpleNodeInterface[] getNodeChildren(int index, int count) {
        try {
            return this.getLevels(index, count);
        }
        catch (TableException tex) {
            return new SimpleNodeInterface[0];
        }
    }

    public String getNodeType() {
        return "hierarchy";
    }

    public final boolean isLeafNode() {
        return false;
    }
}

