/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mdtable;

import com.sas.mdtable.AbstractNode;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.HierarchyInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.table.TableException;
import java.util.NoSuchElementException;

public abstract class AbstractDimension
extends AbstractNode
implements DimensionInterface {
    protected AxisInterface m_axis;

    public AbstractDimension(AxisInterface axis) {
        this.m_axis = axis;
    }

    @Override
    public final AxisInterface getAxis() {
        return this.m_axis;
    }

    @Override
    public HierarchyInterface[] getHierarchies(int index, int count) throws TableException {
        int maxCount = this.getHierarchyCount();
        if (index + count > maxCount) {
            count = maxCount - index;
        }
        HierarchyInterface[] array = new HierarchyInterface[count];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getHierarchy(index + i);
        }
        return array;
    }

    @Override
    public LevelInterface[] getLevels(int index, int count) throws TableException {
        int maxCount = this.getLevelCount();
        if (index + count > maxCount) {
            count = maxCount - index;
        }
        LevelInterface[] array = new LevelInterface[count];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getLevel(index + i);
        }
        return array;
    }

    public final SimpleNodeInterface getNodeChild(int index) {
        try {
            return this.getHierarchy(index);
        }
        catch (TableException tex) {
            throw new NoSuchElementException();
        }
    }

    public final int getNodeChildCount() {
        try {
            return this.getHierarchyCount();
        }
        catch (TableException tex) {
            return 0;
        }
    }

    public final SimpleNodeInterface[] getNodeChildren(int index, int count) {
        try {
            return this.getHierarchies(index, count);
        }
        catch (TableException tex) {
            return new SimpleNodeInterface[0];
        }
    }

    public String getNodeType() {
        return "dimension";
    }

    public final boolean isLeafNode() {
        return false;
    }
}

