/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail.commands;

import com.sas.ComponentInterface;
import com.sas.beans.Util;
import com.sas.mail.Attachment;
import com.sas.mail.commands.RB;
import com.sas.text.Message;
import com.sas.util.Command;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsErrorHandlerInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class ViewAttachmentCommand
implements Command,
PropertyChangeListener,
SupportsErrorHandlerInterface,
Serializable {
    public static final String RB_KEY = "ViewAttachmentCommand.";
    protected String text;
    protected Container parentContainer;
    protected Component viewer;
    protected ErrorHandlerInterface errorHandler;

    public Object clone() throws CloneNotSupportedException {
        return new ViewAttachmentCommand();
    }

    public boolean isExecutable() {
        return true;
    }

    public boolean isUndoable() {
        return false;
    }

    public void undo() {
    }

    public void execute(Object arg) {
        if (arg == null || !(arg instanceof Attachment)) {
            return;
        }
        Attachment mailAttachment = (Attachment)arg;
        Container parent = this.getContainer();
        Component oldViewer = this.viewer;
        this.viewer = mailAttachment.getViewer();
        if (this.viewer != null && parent != null) {
            if (oldViewer != null) {
                parent.remove(oldViewer);
            }
            parent.add(this.viewer);
            if (parent instanceof Window) {
                ((Window)parent).pack();
                Message msg = new Message(RB.getResources(), "ViewAttachmentCommand.viewerTitle.txt", (Object)mailAttachment);
                if (parent instanceof Dialog) {
                    ((Dialog)parent).setTitle(msg.toString());
                }
            }
            parent.setVisible(true);
        } else if (this.errorHandler != null) {
            Message msg = new Message(RB.getResources(), "ViewAttachmentCommand.noViewer.txt", (Object)mailAttachment);
            String viewerError = RB.getStringResource(RB_KEY, "viewerError.txt");
            if (parent instanceof ComponentInterface) {
                this.errorHandler.handleError((ComponentInterface)parent, msg, viewerError);
            } else {
                this.errorHandler.handleError(null, msg, viewerError);
            }
        }
    }

    public Container getContainer() {
        return this.parentContainer;
    }

    public void setContainer(Container viewerContainer) {
        if (viewerContainer != this.parentContainer) {
            Container oldContainer = this.parentContainer;
            this.parentContainer = viewerContainer;
            if (oldContainer != null) {
                Util.removePropertyChangeListener((Object)oldContainer, (PropertyChangeListener)this);
            }
            Util.addPropertyChangeListener((Object)this.parentContainer, (PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object eSource = evt.getSource();
        String propName = evt.getPropertyName();
        if (eSource == this.parentContainer && propName != null && propName.equals("visible") && this.parentContainer != null && !this.parentContainer.isVisible() && this.viewer != null) {
            this.parentContainer.remove(this.viewer);
        }
    }

    public ErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandlerInterface errHandler) {
        this.errorHandler = errHandler;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String txt) {
        this.text = txt;
    }
}

