/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail.commands;

import com.sas.mail.ComposeMessageForm;
import com.sas.mail.MessageDataInterface;
import com.sas.mail.commands.RB;
import com.sas.text.Message;
import com.sas.util.Command;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsErrorHandlerInterface;
import jakarta.mail.MessagingException;
import jakarta.mail.Transport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.io.Serializable;

public class SendMessageCommand
implements Command,
SupportsErrorHandlerInterface,
Serializable {
    public static final String RB_KEY = "SendMessageCommand.";
    String text = RB.getStringResource("SendMessageCommand.", "defaultText.txt");
    ErrorHandlerInterface errorHandler;

    public Object clone() throws CloneNotSupportedException {
        return new SendMessageCommand();
    }

    public boolean isExecutable() {
        return true;
    }

    public boolean isUndoable() {
        return false;
    }

    public void undo() {
    }

    public void execute(Object arg) {
        block8: {
            try {
                if (arg instanceof ComposeMessageForm) {
                    boolean sent = ((ComposeMessageForm)arg).sendMessage(false);
                    Container parent = ((Component)arg).getParent();
                    if (parent instanceof Dialog && sent) {
                        parent.setVisible(false);
                    }
                } else if (arg instanceof MessageDataInterface) {
                    jakarta.mail.Message msg = ((MessageDataInterface)arg).getMessage();
                    Transport.send((jakarta.mail.Message)msg);
                }
            }
            catch (MessagingException e) {
                if (this.errorHandler == null) break block8;
                Exception nextException = e.getNextException();
                while (nextException != null && nextException instanceof MessagingException) {
                    nextException = ((MessagingException)((Object)nextException)).getNextException();
                }
                String text = e.getMessage();
                if (nextException != null) {
                    text = nextException.getMessage();
                }
                Message msg = new Message(RB.getResources(), "SendMessageCommand.errorSending.txt", (Object)text);
                this.errorHandler.handleError(null, msg, null);
            }
        }
    }

    public ErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandlerInterface errHandler) {
        this.errorHandler = errHandler;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String txt) {
        this.text = txt;
    }
}

