/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail.commands;

import com.sas.ComponentInterface;
import com.sas.beans.Util;
import com.sas.mail.Attachment;
import com.sas.mail.commands.RB;
import com.sas.text.Message;
import com.sas.util.Command;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsErrorHandlerInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class EditAttachmentCommand
implements Command,
PropertyChangeListener,
SupportsErrorHandlerInterface,
Serializable {
    public static final String RB_KEY = "EditAttachmentCommand.";
    protected String text;
    protected Container parentContainer;
    protected Component editor;
    protected ErrorHandlerInterface errorHandler;

    public Object clone() throws CloneNotSupportedException {
        return new EditAttachmentCommand();
    }

    public boolean isExecutable() {
        return true;
    }

    public boolean isUndoable() {
        return false;
    }

    public void undo() {
    }

    public void execute(Object arg) {
        if (arg == null || !(arg instanceof Attachment)) {
            return;
        }
        Attachment mailAttachment = (Attachment)arg;
        Container parent = this.getContainer();
        Component oldEditor = this.editor;
        this.editor = mailAttachment.getEditor();
        if (this.editor != null && parent != null) {
            if (oldEditor != null) {
                parent.remove(oldEditor);
            }
            parent.add(this.editor);
            if (parent instanceof Window) {
                ((Window)parent).pack();
                Message msg = new Message(RB.getResources(), "EditAttachmentCommand.editorTitle.txt", (Object)mailAttachment);
                if (parent instanceof Dialog) {
                    ((Dialog)parent).setTitle(msg.toString());
                }
            }
            parent.setVisible(true);
        } else if (this.errorHandler != null) {
            Message msg = new Message(RB.getResources(), "EditAttachmentCommand.noEditor.txt", (Object)mailAttachment);
            String editorError = RB.getStringResource(RB_KEY, "editorError.txt");
            if (parent instanceof ComponentInterface) {
                this.errorHandler.handleError((ComponentInterface)parent, msg, editorError);
            } else {
                this.errorHandler.handleError(null, msg, editorError);
            }
        }
    }

    public Container getContainer() {
        return this.parentContainer;
    }

    public void setContainer(Container editorContainer) {
        if (editorContainer != this.parentContainer) {
            Container oldContainer = this.parentContainer;
            this.parentContainer = editorContainer;
            if (oldContainer != null) {
                Util.removePropertyChangeListener((Object)oldContainer, (PropertyChangeListener)this);
            }
            Util.addPropertyChangeListener((Object)this.parentContainer, (PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object eSource = evt.getSource();
        String propName = evt.getPropertyName();
        Container parent = this.getContainer();
        if (eSource == parent && propName != null && propName.equals("visible") && parent != null && !parent.isVisible() && this.editor != null) {
            parent.remove(this.editor);
        }
    }

    public ErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandlerInterface errHandler) {
        this.errorHandler = errHandler;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String txt) {
        this.text = txt;
    }
}

