/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail.commands;

import com.sas.ComponentInterface;
import com.sas.awt.util.Util;
import com.sas.collection.AssociationList;
import com.sas.collection.AssociationListInterface;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.mail.ComposeMessageDialog;
import com.sas.mail.ComposeMessageForm;
import com.sas.mail.HeaderFormInterface;
import com.sas.mail.MessageFactoryInterface;
import com.sas.mail.MimeMessageFactory;
import com.sas.mail.commands.RB;
import com.sas.mail.commands.TransformAttachment;
import com.sas.text.Message;
import com.sas.util.AbstractCommand;
import com.sas.util.Command;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsErrorHandlerInterface;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Message;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;
import java.text.ParseException;

public class ComposeMessageCommand
extends AbstractCommand
implements Serializable,
SupportsErrorHandlerInterface {
    public static final String RB_KEY = "ComposeMessageCommand.";
    static final long serialVersionUID = 4730114072042437486L;
    protected transient ComposeMessageDialog composeMsgDialog;
    protected transient Frame parentFrame;
    protected Component centeringComponent;
    protected AssociationListInterface recipientList;
    protected MessageFactoryInterface msgFactory;
    protected OrderedCollectionInterface attachmentList;
    protected ErrorHandlerInterface errHandler;
    protected String msgSubject;
    protected String dialogTitle;

    public ComposeMessageCommand() {
        this(null, RB.getStringResource(RB_KEY, "dialogTitle.txt"));
    }

    public ComposeMessageCommand(Frame parent) {
        this(parent, RB.getStringResource(RB_KEY, "dialogTitle.txt"));
    }

    public ComposeMessageCommand(Frame parent, String title) {
        this.setText(title);
        this.setTitle(title);
        this.setParentFrame(parent);
    }

    public Object clone() throws CloneNotSupportedException {
        return new ComposeMessageCommand(this.parentFrame, this.getTitle());
    }

    protected OrderedCollectionInterface newAttachmentList() {
        return new OrderedCollection();
    }

    protected ComposeMessageDialog newComposeMessageDialog() {
        Frame frame = this.getParentFrame();
        if (frame == null) {
            Component centerComp = this.getCenteringComponent();
            if (centerComp != null) {
                frame = Util.getParentFrame(centerComp);
            }
            if (frame == null) {
                frame = new Frame();
            }
            this.setParentFrame(frame);
        }
        return new ComposeMessageDialog(frame, this.getTitle());
    }

    protected MessageFactoryInterface newMessageFactory() {
        return new MimeMessageFactory();
    }

    protected AssociationListInterface newRecipientList() {
        return new AssociationList();
    }

    public String getTitle() {
        return this.dialogTitle;
    }

    public void setTitle(String title) {
        if (this.composeMsgDialog != null) {
            this.composeMsgDialog.setTitle(title);
        }
        this.dialogTitle = title;
    }

    protected Message.RecipientType convertStringToRecipientType(String type) {
        Message.RecipientType recipientType = Message.RecipientType.TO;
        if ("CC".equals(type)) {
            recipientType = Message.RecipientType.CC;
        } else if ("BCC".equals(type)) {
            recipientType = Message.RecipientType.BCC;
        }
        return recipientType;
    }

    protected String convertRecipientTypeToString(Message.RecipientType type) {
        String recipientType = "TO";
        if (type == Message.RecipientType.CC) {
            recipientType = "CC";
        } else if (type == Message.RecipientType.BCC) {
            recipientType = "BCC";
        }
        return recipientType;
    }

    public String getDefaultSubject() {
        return this.msgSubject;
    }

    public void setDefaultSubject(String subject) {
        this.msgSubject = subject;
    }

    public Address[] getDefaultRecipients(Message.RecipientType type) {
        if (this.recipientList != null) {
            String recipientType = this.convertRecipientTypeToString(type);
            String addressesString = null;
            if (this.recipientList.containsKey((Object)recipientType)) {
                addressesString = (String)this.recipientList.get((Object)recipientType);
            }
            if (addressesString != null && addressesString.length() > 0) {
                try {
                    Address[] addresses = this.getMessageFactory().newAddresses(addressesString);
                    return addresses;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return new Address[0];
    }

    public void setDefaultRecipients(Message.RecipientType type, Address[] addresses) {
        if (this.recipientList == null) {
            this.recipientList = this.newRecipientList();
        }
        if (addresses == null || addresses.length == 0) {
            return;
        }
        String addressesString = this.getMessageFactory().toString(addresses);
        String recipientType = this.convertRecipientTypeToString(type);
        if (this.recipientList.containsKey((Object)recipientType)) {
            this.recipientList.removeAt((Object)recipientType);
        }
        this.recipientList.set((Object)recipientType, (Object)addressesString);
    }

    public ErrorHandlerInterface getErrorHandler() {
        return this.errHandler;
    }

    public void setErrorHandler(ErrorHandlerInterface errorHandler) {
        this.errHandler = errorHandler;
    }

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(Frame parent) {
        if (parent != this.parentFrame) {
            this.parentFrame = parent;
        }
    }

    public MessageFactoryInterface getMessageFactory() {
        if (this.msgFactory == null) {
            this.msgFactory = this.newMessageFactory();
        }
        return this.msgFactory;
    }

    public void setMessageFactory(MessageFactoryInterface messageFactory) {
        if (messageFactory != this.msgFactory) {
            this.msgFactory = messageFactory;
            ComposeMessageDialog dialog = this.getComposeMessageDialog();
            dialog.setMessageFactory(this.msgFactory);
        }
    }

    public Command getConfigureOptionsCommand() {
        ComposeMessageDialog dialog = this.getComposeMessageDialog();
        ComposeMessageForm form = dialog.getComposeMessageForm();
        AssociationListInterface cmdList = form.getCommandList();
        Command cmd = (Command)cmdList.get((Object)"CONFIGURE_OPTIONS");
        return cmd;
    }

    public ComposeMessageDialog getComposeMessageDialog() {
        if (this.composeMsgDialog == null) {
            this.composeMsgDialog = this.newComposeMessageDialog();
            this.composeMsgDialog.setMessageFactory(this.getMessageFactory());
        }
        return this.composeMsgDialog;
    }

    public Component getCenteringComponent() {
        return this.centeringComponent;
    }

    public void setCenteringComponent(Component comp) {
        this.centeringComponent = comp;
    }

    public OrderedCollectionInterface getAttachmentList() {
        if (this.attachmentList == null) {
            this.attachmentList = this.newAttachmentList();
        }
        return this.attachmentList;
    }

    public void addAttachment(Object contentSource, String contentType, String name) {
        TransformAttachment tAttach = new TransformAttachment(contentSource, contentType, name);
        this.getAttachmentList().add((Object)tAttach);
    }

    public void addAttachment(Object contentSource, String contentType, String name, int index) {
        TransformAttachment tAttach = new TransformAttachment(contentSource, contentType, name);
        this.getAttachmentList().add((Object)tAttach, index);
    }

    public void addAttachment(Object contentSource, TransformInterface transform, String name) {
        TransformAttachment tAttach = new TransformAttachment(transform, contentSource, name);
        this.getAttachmentList().add((Object)tAttach);
    }

    public void addAttachment(Object contentSource, TransformInterface transform, String name, int index) {
        TransformAttachment tAttach = new TransformAttachment(transform, contentSource, name);
        this.getAttachmentList().add((Object)tAttach, index);
    }

    public void removeAllAttachments() {
        this.getAttachmentList().removeAll();
    }

    public void removeAttachmentAt(int index) {
        this.getAttachmentList().removeAt(index);
    }

    public void removeAttachment(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        OrderedCollectionInterface attachList = this.getAttachmentList();
        int count = attachList.count();
        for (int i = 0; i < count; ++i) {
            TransformAttachment attachment = (TransformAttachment)attachList.get(i);
            if (!name.equals(attachment.attachmentName)) continue;
            attachList.removeAt(i);
            break;
        }
    }

    public void removeAttachment(Object contentSource) {
        if (contentSource == null) {
            return;
        }
        OrderedCollectionInterface attachList = this.getAttachmentList();
        int count = attachList.count();
        for (int i = 0; i < count; ++i) {
            TransformAttachment attachment = (TransformAttachment)attachList.get(i);
            if (contentSource != attachment.contentSource && !contentSource.equals(attachment.contentSource)) continue;
            attachList.removeAt(i);
            break;
        }
    }

    protected void initializeMessageForm(ComposeMessageForm msgForm) {
        msgForm.resetMessageForm();
        this.initializeHeaderInformation(msgForm);
        this.initializeAttachments(msgForm);
        if (msgForm.getAttachmentCount() > 0) {
            msgForm.setAttachmentListVisible(true);
        }
    }

    protected void initializeAttachments(ComposeMessageForm msgForm) {
        block4: {
            try {
                OrderedCollectionInterface attachList = this.getAttachmentList();
                int count = attachList.count();
                for (int i = 0; i < count; ++i) {
                    TransformAttachment tAttachment = (TransformAttachment)attachList.get(i);
                    DataSource ds = tAttachment.transformToDataSource();
                    if (ds != null) {
                        msgForm.addAttachment(ds);
                        continue;
                    }
                    if (tAttachment.contentType == null || tAttachment.contentSource == null) continue;
                    msgForm.addAttachment(tAttachment.contentSource, tAttachment.contentType, tAttachment.attachmentName);
                }
            }
            catch (TransformException e) {
                ErrorHandlerInterface errorHandler = this.getErrorHandler();
                if (errorHandler == null) break block4;
                Message msg = new Message(RB.getResources(), "ComposeMessageCommand.initializeAttachments.ex.txt", (Object)e);
                errorHandler.handleError((ComponentInterface)this.getComposeMessageDialog(), msg, "AttachmentCreationError");
            }
        }
    }

    protected void initializeHeaderInformation(ComposeMessageForm msgForm) {
        HeaderFormInterface headerForm = msgForm.getHeaderForm();
        if (this.recipientList != null) {
            int count = this.recipientList.count();
            for (int i = 0; i < count; ++i) {
                String addressesString = (String)this.recipientList.get(i);
                String type = (String)this.recipientList.getKey(i);
                if (addressesString == null) continue;
                try {
                    Address[] addresses = this.getMessageFactory().newAddresses(addressesString);
                    Message.RecipientType recipientType = this.convertStringToRecipientType(type);
                    headerForm.setRecipients(recipientType, addresses);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (this.msgSubject != null) {
            headerForm.setSubject(this.msgSubject);
        }
    }

    public void executeCommand() {
        this.execute(null);
    }

    public void execute(Object obj) {
        ComposeMessageDialog msgDialog = this.getComposeMessageDialog();
        ComposeMessageForm msgForm = msgDialog.getComposeMessageForm();
        this.initializeMessageForm(msgForm);
        msgDialog.pack();
        Component comp = this.getCenteringComponent();
        if (comp == null && obj instanceof Component) {
            comp = (Component)obj;
        }
        if (comp != null) {
            Util.centerOverWindow(msgDialog, comp);
        } else {
            Util.center(msgDialog);
        }
        msgDialog.setVisible(true);
    }
}

