/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import com.sas.awt.TextField;
import com.sas.beans.Util;
import com.sas.collection.AssociationList;
import com.sas.lang.StringDataInterface;
import com.sas.mail.ComposeMessageForm;
import com.sas.mail.MessageFactoryInterface;
import com.sas.mail.RB;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.LabelView;
import com.sas.visuals.TabFolder;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;

public class UserOptionsFolder
extends TabFolder
implements Customizer {
    public static final String RB_KEY = "UserOptionsFolder.";
    protected Properties sessionProperties;
    protected AssociationList fieldList;
    protected StringDataInterface nameField;
    protected StringDataInterface fromField;
    protected StringDataInterface replyToField;
    protected StringDataInterface organizationField;
    protected LabelView nameLabel;
    protected LabelView fromLabel;
    protected LabelView replyToLabel;
    protected LabelView organizationLabel;

    public UserOptionsFolder() {
    }

    public UserOptionsFolder(String tabText) {
        super(tabText);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.createComponents();
        this.layoutComponents();
        this.setText(RB.getStringResource(RB_KEY, "tabText.txt"));
    }

    protected void layoutComponents() {
        this.setInsets(new Insets(5, 5, 5, 5));
        this.setLayout((LayoutManager)new AutoSizingGridLayout(4, 2, 5, 5, true, false, true));
        this.add(this.nameLabel);
        this.add((Component)this.nameField);
        this.add(this.organizationLabel);
        this.add((Component)this.organizationField);
        this.add(this.fromLabel);
        this.add((Component)this.fromField);
        this.add(this.replyToLabel);
        this.add((Component)this.replyToField);
    }

    protected void createComponents() {
        this.fieldList = new AssociationList();
        this.nameField = new TextField();
        this.fromField = new TextField();
        this.replyToField = new TextField();
        this.organizationField = new TextField();
        this.nameLabel = new LabelView();
        this.fromLabel = new LabelView();
        this.replyToLabel = new LabelView();
        this.organizationLabel = new LabelView();
        ((TextField)this.nameField).setColumns(25);
        this.nameLabel.setText(RB.getStringResource(RB_KEY, "nameLabel.txt"));
        this.organizationLabel.setText(RB.getStringResource(RB_KEY, "organizationLabel.txt"));
        this.fromLabel.setText(RB.getStringResource(RB_KEY, "fromLabel.txt"));
        this.replyToLabel.setText(RB.getStringResource(RB_KEY, "replyToLabel.txt"));
        this.fieldList.set((Object)"mail.header.from", (Object)this.fromField);
        this.fieldList.set((Object)"mail.header.organization", (Object)this.organizationField);
        this.fieldList.set((Object)"mail.header.replyTo", (Object)this.replyToField);
        this.fieldList.set((Object)"mail.header.personalName", (Object)this.nameField);
        Util.addPropertyChangeListener((Object)this.nameField, (PropertyChangeListener)((Object)this));
        Util.addPropertyChangeListener((Object)this.fromField, (PropertyChangeListener)((Object)this));
        Util.addPropertyChangeListener((Object)this.replyToField, (PropertyChangeListener)((Object)this));
        Util.addPropertyChangeListener((Object)this.organizationField, (PropertyChangeListener)((Object)this));
    }

    public Properties getSessionProperties() {
        return this.sessionProperties;
    }

    public void setSessionProperties(Properties properties) {
        if (this.sessionProperties != properties) {
            Properties oldProperties = this.sessionProperties;
            this.sessionProperties = properties;
            this.firePropertyChange("properties", oldProperties, this.sessionProperties);
        }
        if (this.sessionProperties != null) {
            this.initFields();
        }
    }

    public void initFields() {
        Properties props = this.getSessionProperties();
        for (int i = 0; i < this.fieldList.count(); ++i) {
            String key = (String)this.fieldList.getKey(i);
            String value = (String)props.get(key);
            if (value == null) continue;
            ((StringDataInterface)this.fieldList.get(i)).setText(value);
        }
    }

    public String getFromAddress() {
        return this.fromField.getText();
    }

    public void setFromAddress(String from) {
        this.fromField.setText(from);
    }

    @Override
    public String getName() {
        return this.nameField.getText();
    }

    @Override
    public void setName(String name) {
        this.nameField.setText(name);
    }

    public String getReplyToAddress() {
        return this.replyToField.getText();
    }

    public void setReplyToAddress(String reply) {
        this.replyToField.setText(reply);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        Object eSource = e.getSource();
        String propName = e.getPropertyName();
        Properties props = this.getSessionProperties();
        if (eSource instanceof StringDataInterface && this.fieldList.contains(eSource) && props != null) {
            String key = (String)this.fieldList.getKey(eSource);
            String value = ((StringDataInterface)eSource).getText();
            if (value == null || value.length() == 0) {
                props.remove(key);
            } else {
                props.put(key, value);
            }
        }
    }

    @Override
    public void setObject(Object bean) {
        Properties props;
        if (bean == null) {
            return;
        }
        if (bean instanceof Properties) {
            this.setSessionProperties((Properties)bean);
        } else if (bean instanceof ComposeMessageForm) {
            MessageFactoryInterface msgFactory = ((ComposeMessageForm)bean).getMessageFactory();
            Properties props2 = msgFactory.getSessionProperties();
            if (props2 != null) {
                this.setSessionProperties(props2);
            }
        } else if (bean instanceof MessageFactoryInterface && (props = ((MessageFactoryInterface)bean).getSessionProperties()) != null) {
            this.setSessionProperties(props);
        }
    }
}

