/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import com.sas.awt.CheckBox;
import com.sas.awt.Container;
import com.sas.awt.TextField;
import com.sas.beans.Util;
import com.sas.collection.AssociationList;
import com.sas.lang.StringDataInterface;
import com.sas.mail.ComposeMessageForm;
import com.sas.mail.MessageFactoryInterface;
import com.sas.mail.MimeMessageFactory;
import com.sas.mail.RB;
import com.sas.mail.UserInfoAuthenticator;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.LabelView;
import com.sas.visuals.TabFolder;
import jakarta.mail.Authenticator;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;

public class ServerOptionsFolder
extends TabFolder
implements Customizer,
ItemListener {
    public static final String RB_KEY = "ServerOptionsFolder.";
    protected Properties sessionProperties;
    protected AssociationList fieldList;
    protected CheckBox authenticatorRequired;
    protected StringDataInterface hostField;
    protected LabelView hostLabel;
    protected java.awt.Container hostContainer;
    protected Authenticator authenticator;
    protected MessageFactoryInterface msgFactory;

    public ServerOptionsFolder() {
    }

    public ServerOptionsFolder(String tabText) {
        super(tabText);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.createComponents();
        this.layoutComponents();
        this.setText(RB.getStringResource(RB_KEY, "tabText.txt"));
    }

    protected void createComponents() {
        this.fieldList = new AssociationList();
        this.hostContainer = new Container();
        this.hostField = new TextField();
        this.hostLabel = new LabelView();
        ((TextField)this.hostField).setColumns(20);
        this.hostLabel.setText(RB.getStringResource(RB_KEY, "hostLabel.txt"));
        this.fieldList.set((Object)"mail.host", (Object)this.hostField);
        Util.addPropertyChangeListener((Object)this.hostField, (PropertyChangeListener)((Object)this));
        this.authenticatorRequired = new CheckBox();
        this.authenticatorRequired.setText(RB.getStringResource(RB_KEY, "authenticationRequired.txt"));
        this.authenticatorRequired.setEnabled(false);
        this.authenticatorRequired.addItemListener(this);
    }

    protected void layoutComponents() {
        this.setInsets(new Insets(5, 5, 5, 5));
        this.setLayout((LayoutManager)new AutoSizingGridLayout(3, 1, 5, 5, true, false, true));
        this.hostContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 2, 5, 0, true, false, true));
        this.hostContainer.add(this.hostLabel);
        this.hostContainer.add((Component)this.hostField);
        this.add(this.hostContainer);
        this.add(this.authenticatorRequired);
    }

    public Properties getSessionProperties() {
        return this.sessionProperties;
    }

    public void setSessionProperties(Properties properties) {
        if (this.sessionProperties != properties) {
            Properties oldProperties = this.sessionProperties;
            this.sessionProperties = properties;
            this.firePropertyChange("properties", oldProperties, this.sessionProperties);
        }
        if (this.sessionProperties != null) {
            this.initFields();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.authenticatorRequired && this.msgFactory != null) {
            Properties props = this.getSessionProperties();
            if (this.authenticatorRequired.isSelected()) {
                if (this.msgFactory instanceof MimeMessageFactory) {
                    props.put("mail.authenticator.required", "true");
                }
                if (this.authenticator == null) {
                    this.authenticator = this.newAuthenticator();
                }
                this.msgFactory.setAuthenticator(this.authenticator);
            } else {
                if (this.msgFactory instanceof MimeMessageFactory) {
                    props.remove("mail.authenticator.required");
                }
                this.msgFactory.setAuthenticator(null);
            }
        }
    }

    protected Authenticator newAuthenticator() {
        return new UserInfoAuthenticator(new Frame());
    }

    public void initFields() {
        Properties props = this.getSessionProperties();
        for (int i = 0; i < this.fieldList.count(); ++i) {
            String key = (String)this.fieldList.getKey(i);
            String value = (String)props.get(key);
            if (value == null) continue;
            ((StringDataInterface)this.fieldList.get(i)).setText(value);
        }
    }

    public String getServerHost() {
        return this.hostField.getText();
    }

    public void setServerHost(String host) {
        this.hostField.setText(host);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        Object eSource = e.getSource();
        String propName = e.getPropertyName();
        Properties props = this.getSessionProperties();
        if (eSource instanceof StringDataInterface && this.fieldList.contains(eSource) && props != null) {
            String key = (String)this.fieldList.getKey(eSource);
            String value = ((StringDataInterface)eSource).getText();
            if (value == null || value.length() == 0) {
                props.remove(key);
            } else {
                props.put(key, value);
            }
            if (eSource == this.hostField) {
                this.firePropertyChange("serverHost", e.getOldValue(), value);
            }
        }
    }

    @Override
    public void setObject(Object bean) {
        if (bean == null) {
            return;
        }
        if (bean instanceof Properties) {
            this.setSessionProperties((Properties)bean);
        } else if (bean instanceof ComposeMessageForm) {
            this.msgFactory = ((ComposeMessageForm)bean).getMessageFactory();
            Properties props = this.msgFactory.getSessionProperties();
            if (props != null) {
                this.setSessionProperties(props);
            }
        } else if (bean instanceof MessageFactoryInterface) {
            this.msgFactory = (MessageFactoryInterface)bean;
            Properties props = ((MessageFactoryInterface)bean).getSessionProperties();
            if (props != null) {
                this.setSessionProperties(props);
            }
        }
        if (this.msgFactory != null) {
            this.authenticator = this.msgFactory.getAuthenticator();
            if (this.authenticator != null) {
                this.authenticatorRequired.setSelected(true);
            } else {
                this.authenticatorRequired.setSelected(false);
            }
            if (this.msgFactory instanceof MimeMessageFactory) {
                this.authenticatorRequired.setEnabled(true);
            }
        }
    }
}

