/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import com.sas.beans.PropertyChangeListenerList;
import com.sas.beans.PropertyChangeSource;
import java.awt.Component;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class PopupTrigger
extends MouseAdapter
implements PropertyChangeSource,
Serializable {
    static final long serialVersionUID = -6567515507303973422L;
    protected PopupMenu popupMenu;
    protected Component parent;
    protected PropertyChangeListenerList allPropertyChangeListeners;

    public PopupTrigger(PopupMenu menu, Component menuParent) {
        this.popupMenu = menu;
        this.parent = menuParent;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.allPropertyChangeListeners == null) {
            this.allPropertyChangeListeners = new PropertyChangeListenerList();
        }
        this.allPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.allPropertyChangeListeners != null) {
            this.allPropertyChangeListeners.remove(listener);
        }
    }

    protected void notifyPropertyChange(PropertyChangeEvent event) {
        if (this.allPropertyChangeListeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.allPropertyChangeListeners.getListeners()) {
            listener.propertyChange(event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            Point popupPt = this.translatePoint((Component)event.getSource(), this.parent, event.getPoint());
            this.showPopupMenu(popupPt.x, popupPt.y);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            Point popupPt = this.translatePoint((Component)event.getSource(), this.parent, event.getPoint());
            this.showPopupMenu(popupPt.x, popupPt.y);
        }
    }

    public Point translatePoint(Component originalComp, Component destinationComp, Point originalPoint) {
        Point translatedPoint = new Point(originalPoint.x, originalPoint.y);
        for (Component comp = originalComp; comp != destinationComp; comp = comp.getParent()) {
            if (comp == null) {
                return originalPoint;
            }
            Point newPoint = comp.getLocation();
            translatedPoint.translate(newPoint.x, newPoint.y);
        }
        return translatedPoint;
    }

    public void showPopupMenu(int x, int y) {
        this.notifyPropertyChange(new PropertyChangeEvent(this, "showPopupMenu", Boolean.FALSE, Boolean.TRUE));
        if (this.parent != null) {
            this.popupMenu.show(this.parent, x, y);
        }
    }
}

