/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import com.sas.ComponentInterface;
import com.sas.awt.Container;
import com.sas.beans.Util;
import com.sas.collection.AssociationList;
import com.sas.collection.OrderedCollection;
import com.sas.lang.StringDataInterface;
import com.sas.mail.AddressFactoryInterface;
import com.sas.mail.HeaderFields;
import com.sas.mail.HeaderFormInterface;
import com.sas.mail.InternetAddressFactory;
import com.sas.mail.RB;
import com.sas.text.Message;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.IconInterface;
import com.sas.visuals.LabelView;
import com.sas.visuals.TextEditComposite;
import jakarta.mail.Address;
import jakarta.mail.Flags;
import jakarta.mail.Message;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class HeaderForm
extends Container
implements HeaderFormInterface {
    static final long serialVersionUID = 1681131080605446398L;
    protected Container flagsContainer;
    protected Container headersContainer;
    protected StringDataInterface fromLabel;
    protected StringDataInterface replyToLabel;
    protected StringDataInterface toLabel;
    protected StringDataInterface ccLabel;
    protected StringDataInterface bccLabel;
    protected StringDataInterface subjectLabel;
    protected StringDataInterface sentLabel;
    protected StringDataInterface receivedLabel;
    protected StringDataInterface fromField;
    protected StringDataInterface toField;
    protected StringDataInterface ccField;
    protected StringDataInterface replyToField;
    protected StringDataInterface bccField;
    protected StringDataInterface subjectField;
    protected StringDataInterface sentField;
    protected StringDataInterface receivedField;
    protected transient AssociationList fieldList;
    protected transient AssociationList labelList;
    protected transient AssociationList iconList;
    protected transient AssociationList addressLists;
    protected AddressFactoryInterface addressFactory;
    protected DateFormat dateFormat;
    protected Date sentDate;
    protected Date receivedDate;
    protected transient Flags flags;
    protected String subject;
    protected boolean updateValue;
    protected boolean updateField;

    protected void createComponents() {
        this.flagsContainer = new Container();
        this.headersContainer = new Container();
        this.fromLabel = new LabelView();
        this.replyToLabel = new LabelView();
        this.toLabel = new LabelView();
        this.ccLabel = new LabelView();
        this.bccLabel = new LabelView();
        this.subjectLabel = new LabelView();
        this.fromField = new TextEditComposite(RB.getStringResource("HeaderForm.", "fromFieldDefault.txt"));
        this.toField = new TextEditComposite(RB.getStringResource("HeaderForm.", "toFieldDefault.txt"));
        this.ccField = new TextEditComposite(RB.getStringResource("HeaderForm.", "ccFieldDefault.txt"));
        this.replyToField = new TextEditComposite(RB.getStringResource("HeaderForm.", "replyToFieldDefault.txt"));
        this.bccField = new TextEditComposite(RB.getStringResource("HeaderForm.", "bccFieldDefault.txt"));
        this.subjectField = new TextEditComposite(RB.getStringResource("HeaderForm.", "subjectFieldDefault.txt"));
        this.sentLabel = new LabelView();
        this.sentField = new LabelView();
        this.receivedLabel = new LabelView();
        this.receivedField = new LabelView();
        this.initializeLabelView((LabelView)this.fromLabel, RB.getStringResource("HeaderForm.", "fromLabel.txt"));
        this.initializeLabelView((LabelView)this.replyToLabel, RB.getStringResource("HeaderForm.", "replyToLabel.txt"));
        this.initializeLabelView((LabelView)this.toLabel, RB.getStringResource("HeaderForm.", "toLabel.txt"));
        this.initializeLabelView((LabelView)this.ccLabel, RB.getStringResource("HeaderForm.", "ccLabel.txt"));
        this.initializeLabelView((LabelView)this.bccLabel, RB.getStringResource("HeaderForm.", "bccLabel.txt"));
        this.initializeLabelView((LabelView)this.subjectLabel, RB.getStringResource("HeaderForm.", "subjectLabel.txt"));
        this.initializeLabelView((LabelView)this.sentLabel, RB.getStringResource("HeaderForm.", "sentDateLabel.txt"));
        this.initializeLabelView((LabelView)this.receivedLabel, RB.getStringResource("HeaderForm.", "receivedDateLabel.txt"));
        this.dateFormat = DateFormat.getDateTimeInstance();
        this.addressFactory = new InternetAddressFactory();
        this.addressLists = new AssociationList();
        this.fieldList = new AssociationList();
        this.labelList = new AssociationList();
        this.iconList = new AssociationList();
        this.initializeFieldList();
        this.initializeLabelList();
        for (int i = 0; i < this.fieldList.count(); ++i) {
            Util.addPropertyChangeListener((Object)this.fieldList.get(i), (PropertyChangeListener)((Object)this));
        }
    }

    protected void initializeLabelList() {
        int index = 0;
        this.labelList.initialize();
        this.labelList.add(index++, (Object)HeaderFields.FROM, (Object)this.fromLabel);
        this.labelList.add(index++, (Object)HeaderFields.SENT_DATE, (Object)this.sentLabel);
        this.labelList.add(index++, (Object)HeaderFields.RECEIVED_DATE, (Object)this.receivedLabel);
        this.labelList.add(index++, (Object)HeaderFields.TO, (Object)this.toLabel);
        this.labelList.add(index++, (Object)HeaderFields.CC, (Object)this.ccLabel);
        this.labelList.add(index++, (Object)HeaderFields.BCC, (Object)this.bccLabel);
        this.labelList.add(index++, (Object)HeaderFields.REPLY_TO, (Object)this.replyToLabel);
        this.labelList.add(index++, (Object)HeaderFields.SUBJECT, (Object)this.subjectLabel);
    }

    protected void initializeFieldList() {
        int index = 0;
        this.fieldList.initialize();
        this.fieldList.add(index++, (Object)HeaderFields.FROM, (Object)this.fromField);
        this.fieldList.add(index++, (Object)HeaderFields.SENT_DATE, (Object)this.receivedField);
        this.fieldList.add(index++, (Object)HeaderFields.RECEIVED_DATE, (Object)this.sentField);
        this.fieldList.add(index++, (Object)HeaderFields.TO, (Object)this.toField);
        this.fieldList.add(index++, (Object)HeaderFields.CC, (Object)this.ccField);
        this.fieldList.add(index++, (Object)HeaderFields.BCC, (Object)this.bccField);
        this.fieldList.add(index++, (Object)HeaderFields.REPLY_TO, (Object)this.replyToField);
        this.fieldList.add(index++, (Object)HeaderFields.SUBJECT, (Object)this.subjectField);
    }

    protected void initializeLabelView(LabelView label, String text) {
        label.setText(text);
        label.setInsets(new Insets(0, 5, 0, 5));
        label.setHorizontalAlignment(2);
        label.setForeground(Color.white);
        label.setBackground(Color.darkGray);
        label.setTransparent(false);
    }

    protected boolean isAddressField(HeaderFields type) {
        return type == HeaderFields.FROM || type == HeaderFields.TO || type == HeaderFields.CC || type == HeaderFields.BCC || type == HeaderFields.REPLY_TO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateValue(HeaderFields type) {
        block22: {
            if (this.updateField) {
                return;
            }
            try {
                this.updateValue = true;
                StringDataInterface headerField = (StringDataInterface)this.fieldList.get((Object)type);
                if (this.isAddressField(type) && this.addressFactory != null) {
                    String text = headerField.getText();
                    Address[] addresses = null;
                    try {
                        addresses = this.addressFactory.newAddresses(text);
                    }
                    catch (ParseException e) {
                        Message errorMsg = new Message(RB.getResources(), "HeaderForm.addressFieldParseError.txt", (Object)text);
                        ErrorHandlerInterface errorHandler = this.getErrorHandler();
                        if (errorHandler != null) {
                            errorHandler.handleError((ComponentInterface)this, errorMsg, null);
                        }
                        this.updateValue = false;
                        return;
                    }
                    OrderedCollection addressList = null;
                    if (this.addressLists.containsKey((Object)type)) {
                        addressList = (OrderedCollection)this.addressLists.get((Object)type);
                    }
                    if (addressList == null) {
                        addressList = new OrderedCollection();
                        this.addressLists.set((Object)type, (Object)addressList);
                    }
                    if (addressList.count() > 0) {
                        addressList.removeAll();
                    }
                    for (int i = 0; addresses != null && i < addresses.length; ++i) {
                        addressList.add((Object)addresses[i]);
                    }
                    break block22;
                }
                if (type == HeaderFields.SUBJECT) {
                    String oldValue = this.subject;
                    this.subject = headerField.getText();
                    this.firePropertyChange("subject", oldValue, this.subject);
                } else if (type == HeaderFields.RECEIVED_DATE) {
                    String oldValue = this.subject;
                    String date = headerField.getText();
                    try {
                        this.sentDate = this.dateFormat.parse(date);
                        this.firePropertyChange("receivedDate", oldValue, this.receivedDate);
                    }
                    catch (ParseException parseException) {}
                } else if (type == HeaderFields.SENT_DATE) {
                    String oldValue = this.subject;
                    String date = headerField.getText();
                    try {
                        this.sentDate = this.dateFormat.parse(date);
                        this.firePropertyChange("sentDate", oldValue, this.sentDate);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.updateValue = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateField(HeaderFields type) {
        if (this.updateValue) {
            return;
        }
        try {
            this.updateField = true;
            StringDataInterface headerField = (StringDataInterface)this.fieldList.get((Object)type);
            if (this.isAddressField(type) && this.addressFactory != null) {
                String text = "";
                OrderedCollection addressList = (OrderedCollection)this.addressLists.get((Object)type);
                if (addressList != null && addressList.count() > 0) {
                    Object[] objectArray = addressList.toArray();
                    Address[] addressArray = new Address[objectArray.length];
                    System.arraycopy(objectArray, 0, addressArray, 0, objectArray.length);
                    text = this.addressFactory.toString(addressArray);
                }
                headerField.setText(text);
            } else if (type == HeaderFields.SUBJECT) {
                headerField.setText(this.subject);
            } else if (type == HeaderFields.RECEIVED_DATE) {
                String date = this.dateFormat.format(this.receivedDate);
                headerField.setText(date);
            } else if (type == HeaderFields.SENT_DATE) {
                String date = this.dateFormat.format(this.sentDate);
                headerField.setText(date);
            }
        }
        finally {
            this.updateField = false;
        }
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        int headerCount = this.fieldList.count();
        if (this.labelList.count() < headerCount) {
            headerCount = this.labelList.count();
        }
        AutoSizingGridLayout layout1 = new AutoSizingGridLayout(headerCount, 2, 0, 0, true, false, true);
        layout1.setIgnoreSizeOfNonVisibleComponents(true);
        this.headersContainer.setLayout((LayoutManager)layout1);
        for (int i = 0; i < this.fieldList.count() && i < this.labelList.count(); ++i) {
            Component field = (Component)this.fieldList.get(i);
            Component label = (Component)this.labelList.get(i);
            this.headersContainer.add(label);
            this.headersContainer.add(field);
        }
        AutoSizingGridLayout layout2 = new AutoSizingGridLayout(0, 1, 0, 0, true, false, false);
        layout2.setIgnoreSizeOfNonVisibleComponents(true);
        this.flagsContainer.setLayout((LayoutManager)layout2);
        this.add((Component)this.headersContainer, "Center");
        this.add((Component)this.flagsContainer, "East");
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object eSource = event.getSource();
        String propName = event.getPropertyName();
        if (propName != null && propName.equals("text") && !this.updateField) {
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (this.fieldList.contains(eSource)) {
                this.updateValue((HeaderFields)((Object)this.fieldList.getKey(eSource)));
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.addressLists = new AssociationList();
        this.fieldList = new AssociationList();
        this.labelList = new AssociationList();
        this.iconList = new AssociationList();
        this.initializeLabelList();
        this.initializeFieldList();
        int count = this.fieldList.count();
        for (int i = 0; i < count; ++i) {
            Util.addPropertyChangeListener((Object)this.fieldList.get(i), (PropertyChangeListener)((Object)this));
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.getBorder().setStyle(2);
        this.getBorder().setBorderWidth(1);
        this.createComponents();
        this.layoutComponents();
        this.setHeaderFieldVisible(HeaderFields.FROM, false);
        this.setHeaderFieldVisible(HeaderFields.SENT_DATE, false);
        this.setHeaderFieldVisible(HeaderFields.RECEIVED_DATE, false);
        this.setHeaderFieldVisible(HeaderFields.BCC, false);
        this.setHeaderFieldVisible(HeaderFields.REPLY_TO, false);
    }

    public void addAddresses(HeaderFields fieldType, Address[] addresses) {
        if (!this.isAddressField(fieldType)) {
            return;
        }
        OrderedCollection addressList = null;
        if (this.addressLists.containsKey((Object)fieldType)) {
            addressList = (OrderedCollection)this.addressLists.get((Object)fieldType);
        }
        if (addressList == null) {
            addressList = new OrderedCollection();
            this.addressLists.set((Object)fieldType, (Object)addressList);
        }
        for (int i = 0; addresses != null && i < addresses.length; ++i) {
            if (addressList.contains((Object)addresses[i])) continue;
            addressList.add((Object)addresses[i]);
        }
        this.updateField(fieldType);
    }

    public void removeAddresses(HeaderFields fieldType, Address[] addresses) {
        if (!this.isAddressField(fieldType)) {
            return;
        }
        boolean valueChanged = false;
        OrderedCollection addressList = null;
        if (this.addressLists.containsKey((Object)fieldType)) {
            addressList = (OrderedCollection)this.addressLists.get((Object)fieldType);
        }
        for (int i = 0; addresses != null && i < addresses.length; ++i) {
            if (!addressList.contains((Object)addresses[i])) continue;
            addressList.remove((Object)addresses[i]);
            valueChanged = true;
        }
        if (valueChanged) {
            this.updateField(fieldType);
        }
    }

    @Override
    public void addFrom(Address[] addresses) {
        this.addAddresses(HeaderFields.FROM, addresses);
    }

    @Override
    public void addRecipients(Message.RecipientType type, Address[] addresses) {
        if (type == Message.RecipientType.TO) {
            this.addAddresses(HeaderFields.TO, addresses);
        } else if (type == Message.RecipientType.CC) {
            this.addAddresses(HeaderFields.CC, addresses);
        } else if (type == Message.RecipientType.BCC) {
            this.addAddresses(HeaderFields.BCC, addresses);
        }
    }

    @Override
    public Flags getFlags() {
        return this.flags;
    }

    @Override
    public Address[] getAddresses(HeaderFields type) {
        if (!this.addressLists.containsKey((Object)type)) {
            return null;
        }
        OrderedCollection addressList = (OrderedCollection)this.addressLists.get((Object)type);
        if (addressList != null) {
            Object[] objectArray = addressList.toArray();
            Address[] addressArray = new Address[objectArray.length];
            System.arraycopy(objectArray, 0, addressArray, 0, objectArray.length);
            return addressArray;
        }
        return null;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public Address[] getFrom() {
        return this.getAddresses(HeaderFields.FROM);
    }

    @Override
    public Date getReceivedDate() {
        return this.receivedDate;
    }

    @Override
    public Address[] getRecipients(Message.RecipientType type) {
        if (type == Message.RecipientType.TO) {
            return this.getAddresses(HeaderFields.TO);
        }
        if (type == Message.RecipientType.CC) {
            return this.getAddresses(HeaderFields.CC);
        }
        if (type == Message.RecipientType.BCC) {
            return this.getAddresses(HeaderFields.BCC);
        }
        return null;
    }

    @Override
    public Address[] getReplyTo() {
        return this.getAddresses(HeaderFields.REPLY_TO);
    }

    @Override
    public Date getSentDate() {
        return this.sentDate;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public AddressFactoryInterface getAddressFactory() {
        return this.addressFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetHeaderForm() {
        try {
            this.updateField = true;
            if (this.addressLists != null) {
                this.addressLists.removeAll();
            }
            int count = this.fieldList.count();
            for (int i = 0; i < count; ++i) {
                StringDataInterface field = (StringDataInterface)this.fieldList.get(i);
                field.setText("");
            }
        }
        finally {
            this.updateField = false;
        }
    }

    public void setAddressFactory(AddressFactoryInterface adrsFactory) {
        if (adrsFactory != this.addressFactory) {
            AddressFactoryInterface oldFactory = this.addressFactory;
            this.addressFactory = adrsFactory;
            this.firePropertyChange("addressFactory", oldFactory, this.addressFactory);
        }
    }

    public void setDateFormat(DateFormat format) {
        if (!com.sas.util.Util.equal((Object)format, (Object)this.dateFormat)) {
            DateFormat oldValue = this.dateFormat;
            this.dateFormat = format == null ? DateFormat.getDateTimeInstance() : format;
            this.firePropertyChange("dateFormat", oldValue, format);
        }
    }

    @Override
    public void setFlag(Flags.Flag flag, boolean set) {
        Flags tmpFlags = this.getFlags();
        if (tmpFlags == null) {
            tmpFlags = this.flags = new Flags();
        }
        if (set) {
            tmpFlags.add(flag);
        } else {
            tmpFlags.remove(flag);
        }
        this.updateField(HeaderFields.FLAGS);
    }

    @Override
    public void setFlags(Flags fs, boolean set) {
        Flags tmpFlags = this.getFlags();
        if (tmpFlags == null) {
            tmpFlags = this.flags = new Flags();
        }
        if (set) {
            tmpFlags.add(fs);
        } else {
            tmpFlags.remove(fs);
        }
        this.updateField(HeaderFields.FLAGS);
    }

    @Override
    public void setAddresses(HeaderFields type, Address[] addresses) {
        if (!this.isAddressField(type)) {
            return;
        }
        OrderedCollection addressList = new OrderedCollection();
        for (int i = 0; addresses != null && i < addresses.length; ++i) {
            if (addressList.contains((Object)addresses[i])) continue;
            addressList.add((Object)addresses[i]);
        }
        if (addressList.count() == 0) {
            addressList = null;
        }
        this.addressLists.set((Object)type, (Object)addressList);
        this.updateField(type);
    }

    @Override
    public void setFrom(Address address) {
        this.setAddresses(HeaderFields.FROM, new Address[]{address});
    }

    @Override
    public void setRecipients(Message.RecipientType type, Address[] addresses) {
        HeaderFields fieldType = HeaderFields.TO;
        if (type == Message.RecipientType.CC) {
            fieldType = HeaderFields.CC;
        } else if (type == Message.RecipientType.BCC) {
            fieldType = HeaderFields.BCC;
        }
        this.setAddresses(fieldType, addresses);
    }

    @Override
    public void setReplyTo(Address[] addresses) {
        this.setAddresses(HeaderFields.REPLY_TO, addresses);
    }

    @Override
    public void setReceivedDate(Date date) {
        if (!com.sas.util.Util.equal((Object)date, (Object)this.receivedDate)) {
            Date oldValue = this.receivedDate;
            this.receivedDate = date;
            this.updateField(HeaderFields.RECEIVED_DATE);
            this.firePropertyChange("receivedDate", oldValue, this.receivedDate);
        }
    }

    @Override
    public void setSentDate(Date date) {
        if (!com.sas.util.Util.equal((Object)date, (Object)this.sentDate)) {
            Date oldValue = this.sentDate;
            this.sentDate = date;
            this.updateField(HeaderFields.SENT_DATE);
            this.firePropertyChange("sentDate", oldValue, this.sentDate);
        }
    }

    @Override
    public void setSubject(String subject) {
        if (!com.sas.util.Util.equal((Object)this.subject, (Object)subject)) {
            String oldValue = this.subject;
            this.subject = subject;
            this.updateField(HeaderFields.SUBJECT);
            this.firePropertyChange("subject", oldValue, this.subject);
        }
    }

    @Override
    public boolean isHeaderFieldVisible(HeaderFields type) {
        Component fieldComponent = (Component)this.fieldList.get((Object)type);
        if (fieldComponent != null) {
            return fieldComponent.isVisible();
        }
        return false;
    }

    @Override
    public void setHeaderFieldVisible(HeaderFields type, boolean v) {
        Component fieldComponent = (Component)this.fieldList.get((Object)type);
        Component labelComponent = (Component)this.labelList.get((Object)type);
        if (fieldComponent != null) {
            fieldComponent.setVisible(v);
        }
        if (labelComponent != null) {
            labelComponent.setVisible(v);
        }
        this.invalidate();
        java.awt.Container parent = this.getParent();
        if (parent != null) {
            parent.invalidate();
            parent.validate();
        }
    }

    @Override
    public boolean isHeaderFieldEditable(HeaderFields type) {
        Component headerField = (Component)this.fieldList.get((Object)type);
        if (headerField instanceof TextEditComposite) {
            return ((TextEditComposite)headerField).isEditable();
        }
        boolean editable = false;
        try {
            Class<?> headerClass = headerField.getClass();
            Method isEditableMethod = headerClass.getMethod("isEditable", null);
            Boolean editableObject = (Boolean)isEditableMethod.invoke((Object)headerField, null);
            editable = editableObject;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return editable;
    }

    @Override
    public void setHeaderFieldEditable(HeaderFields type, boolean e) {
        Component headerField = (Component)this.fieldList.get((Object)type);
        if (headerField instanceof TextEditComposite) {
            ((TextEditComposite)headerField).setEditable(e);
        } else {
            try {
                Class<?> headerClass = headerField.getClass();
                Method setEditableMethod = headerClass.getMethod("setEditable", Boolean.TYPE);
                setEditableMethod.invoke((Object)headerField, new Boolean(e));
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getHeaderFieldLabel(HeaderFields type) {
        StringDataInterface label = (StringDataInterface)this.labelList.get((Object)type);
        return label.getText();
    }

    @Override
    public void setHeaderFieldLabel(HeaderFields type, String text) {
        StringDataInterface label = (StringDataInterface)this.labelList.get((Object)type);
        label.setText(text);
    }

    @Override
    public IconInterface getFlagIcon(Flags.Flag flag) {
        return (IconInterface)this.iconList.get((Object)flag);
    }

    @Override
    public void setFlagIcon(Flags.Flag flag, IconInterface icon) {
        this.iconList.set((Object)flag, (Object)icon);
        this.updateField(HeaderFields.FLAGS);
    }
}

