/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import com.sas.mail.RB;
import com.sas.text.Message;
import jakarta.activation.CommandInfo;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import java.awt.Component;
import java.io.IOException;

public class Attachment {
    private Object content;
    private String contentType;
    private String name;
    private DataSource dataSource;
    private DataHandler dataHandler;
    private Component editComponent;
    private Component viewComponent;

    public Attachment(DataHandler dh, String attachmentName) {
        this.dataHandler = dh;
        this.dataSource = dh.getDataSource();
        if (this.dataSource == null) {
            this.contentType = this.dataHandler.getContentType();
            try {
                this.content = this.dataHandler.getContent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.name = attachmentName;
        }
    }

    public Attachment(DataSource ds) {
        this.dataSource = ds;
    }

    public Attachment(Object content, String type, String name) {
        this.content = content;
        this.contentType = type;
        this.name = name;
    }

    public String toString() {
        Message msg = new Message(RB.getResources(), "Attachment.attachmentToString.txt", (Object)this.getName(), (Object)this.getContentType());
        return msg.toString();
    }

    public Object getContent() {
        return this.content;
    }

    public String getContentType() {
        if (this.dataSource != null) {
            return this.dataSource.getContentType();
        }
        return this.contentType;
    }

    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.dataSource != null) {
            return this.dataSource.getName();
        }
        return RB.getStringResource("Attachment.attachmentName.txt");
    }

    public void setName(String attachmentName) {
        this.name = attachmentName;
    }

    public Component getEditor() {
        if (this.editComponent == null) {
            DataHandler dh = this.dataHandler;
            if (dh == null && this.dataSource != null) {
                dh = new DataHandler(this.dataSource);
            }
            if (dh != null) {
                try {
                    CommandInfo editCommand = dh.getCommand("edit");
                    Object bean = dh.getBean(editCommand);
                    if (bean != null && bean instanceof Component) {
                        this.editComponent = (Component)bean;
                    }
                }
                catch (Exception e) {
                    this.editComponent = null;
                }
            }
        }
        return this.editComponent;
    }

    public Component getViewer() {
        if (this.viewComponent == null) {
            DataHandler dh = this.dataHandler;
            if (dh == null && this.dataSource != null) {
                dh = new DataHandler(this.dataSource);
            }
            if (dh != null) {
                try {
                    CommandInfo viewCommand = dh.getCommand("view");
                    Object bean = dh.getBean(viewCommand);
                    if (bean != null && bean instanceof Component) {
                        this.viewComponent = (Component)bean;
                    }
                }
                catch (Exception e) {
                    this.viewComponent = null;
                }
            }
        }
        return this.viewComponent;
    }
}

