/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.Component;
import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.io.RB;
import com.sas.io.WindowsPrinterPeer;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;

public class Printer
extends Component
implements NodeInterface,
PublicClonable {
    static final long serialVersionUID = 4725195575628470786L;
    protected transient WindowsPrinterPeer peer;
    public static final String RB_KEY = "Printer.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "comment"}, {"Description", "Brief Description of the printer."}}, {{"Name", "printerName"}, {"Description", "Name of the printer"}}, {{"Name", "leafNode"}, {"Hidden", "true"}, {"Description", "has Children."}}, {{"Name", "nodeText"}, {"Hidden", "true"}, {"Description", "Name of the printer."}}, {{"Name", "nodeExpandedText"}, {"Hidden", "true"}, {"Description", "Name of the printer."}}, {{"Name", "nodeType"}, {"Hidden", "true"}, {"Description", "Type of the node."}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Printer() {
        this.commonInit(null);
    }

    public Object clone() throws CloneNotSupportedException {
        Printer newData = (Printer)((Object)super.clone());
        return newData;
    }

    public Printer(String name) {
        this.commonInit(name);
    }

    protected void commonInit(String name) {
        String osName = System.getProperty(RB.getStringResource((String)"osName.txt"));
        if ((osName = osName.toLowerCase()).indexOf(RB.getStringResource((String)"win.txt")) >= 0) {
            this.peer = new WindowsPrinterPeer(name);
        } else if (osName.indexOf(RB.getStringResource((String)"unix.txt")) >= 0) {
            // empty if block
        }
    }

    public String getPrinterName() {
        return this.peer != null ? this.peer.getPrinterName() : null;
    }

    public String getComment() {
        return this.peer != null ? this.peer.getComment() : null;
    }

    public String getNodeType() {
        return this.peer != null ? this.peer.getNodeType() : null;
    }

    public String getNodeText() {
        return this.peer != null ? this.peer.getNodeText() : null;
    }

    public Hashtable getProperties() {
        return this.peer != null ? this.peer.getProperties() : new Hashtable();
    }

    public Hashtable getPropertyDescription() {
        return this.peer != null ? this.peer.getPropertyDescription() : null;
    }

    public Object getProperty(String name) {
        return this.peer != null ? this.peer.getProperty(name) : null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            if (this.peer != null) {
                this.commonInit(this.peer.getPrinterName());
            }
        }
        catch (Exception e) {
            this.peer = null;
        }
        stream.defaultReadObject();
    }

    public String getNodeExpandedText() {
        return this.peer != null ? this.peer.getNodeExpandedText() : null;
    }

    public int countNodeChildren(int maximumChildCount) {
        return this.getNodeChildCount();
    }

    public int getNodeChildCount() {
        return 0;
    }

    public boolean isLeafNode() {
        return true;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        return null;
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        return null;
    }

    public String toString() {
        return this.getPrinterName();
    }

    public IconInterface getDefaultIcon() {
        return new ImageView(Resources.getImage((String)"Printer"));
    }

    public IconInterface getExpandedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getSelectedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getExpandedSelectedIcon() {
        return this.getDefaultIcon();
    }
}

