/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.ModelInterface;
import com.sas.awt.Button;
import com.sas.awt.Container;
import com.sas.awt.ListBox;
import com.sas.awt.Panel;
import com.sas.awt.TextField;
import com.sas.awt.util.Util;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.io.FileList;
import com.sas.io.FileSystemList;
import com.sas.io.RB;
import com.sas.util.Countable;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.NodeView;
import com.sas.visuals.PushButton;
import com.sas.visuals.TreeView;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class FileListFiltersPanel
extends Panel
implements KeyListener,
MouseListener,
ContentsChangedListener,
ActionListener,
ItemListener {
    protected TextField textField;
    protected ListBox listBox;
    protected TreeView treeView;
    protected PushButton pushButton;
    protected Button button;
    protected FileSystemList fsl;
    protected FileList fl;
    protected String startingDirectories;
    protected ModelInterface itemsModel;
    protected boolean mouseDClicked = false;
    protected boolean isFile = false;
    public static final String RB_KEY = "FileListFiltersPanel.";

    public FileListFiltersPanel() {
        this.setInsets(new Insets(5, 5, 5, 5));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 3);
        layout.setHgap(5);
        this.setLayout((LayoutManager)layout);
        Panel filtersContainer = new Panel();
        filtersContainer.initialize();
        BaseBorder border1 = (BaseBorder)filtersContainer.getBorder();
        border1.setBackgroundColor(filtersContainer.getBackgroundColor());
        Util.configureGroupBoxBorder(border1, RB.getStringResource((String)RB_KEY, (String)"border1.txt"));
        filtersContainer.setInsets(new Insets(10, 10, 10, 10));
        AutoSizingGridLayout layout1 = new AutoSizingGridLayout(2, 1);
        layout1.setVgap(10);
        filtersContainer.setLayout((LayoutManager)layout1);
        this.textField = new TextField("", 19);
        this.textField.initialize();
        filtersContainer.add(this.textField);
        this.treeView = new TreeView();
        this.treeView.initialize();
        this.fl = new FileList();
        this.treeView.attachModel((ModelInterface)this.fl);
        Dimension d = new Dimension(160, 220);
        this.treeView.setPreferredSize(d);
        filtersContainer.add(this.treeView);
        this.add(filtersContainer);
        Container buttonContainer = new Container();
        buttonContainer.initialize();
        AutoSizingGridLayout layout1a = new AutoSizingGridLayout(3, 1);
        layout1a.setVgap(30);
        buttonContainer.setLayout((LayoutManager)layout1a);
        PushButton pb = new PushButton("        >        ");
        pb.initialize();
        pb.setVisible(false);
        buttonContainer.add(pb);
        PushButton pb1 = new PushButton("        >        ");
        pb1.initialize();
        pb1.setVisible(false);
        buttonContainer.add(pb1);
        this.pushButton = new PushButton("        >        ");
        this.pushButton.initialize();
        this.pushButton.setEnabled(false);
        buttonContainer.add(this.pushButton);
        this.add(buttonContainer);
        Panel modelContainer = new Panel();
        modelContainer.initialize();
        BaseBorder border2 = (BaseBorder)modelContainer.getBorder();
        border2.setBackgroundColor(modelContainer.getBackgroundColor());
        Util.configureGroupBoxBorder(border2, RB.getStringResource((String)RB_KEY, (String)"border2.txt"));
        modelContainer.setInsets(new Insets(10, 10, 10, 10));
        AutoSizingGridLayout layout2 = new AutoSizingGridLayout(2, 1);
        layout2.setVgap(10);
        modelContainer.setLayout((LayoutManager)layout2);
        this.listBox = new ListBox(17);
        this.listBox.initialize();
        Dimension d1 = new Dimension(160, 220);
        this.listBox.setPreferredSize(d1);
        modelContainer.add(this.listBox);
        Container button2Container = new Container();
        button2Container.initialize();
        AutoSizingGridLayout layout2a = new AutoSizingGridLayout(1, 2);
        layout2a.setHgap(35);
        layout2a.setVgap(20);
        button2Container.setLayout((LayoutManager)layout2a);
        Button button1 = new Button("   ");
        button1.initialize();
        button1.setVisible(false);
        button2Container.add(button1);
        this.button = new Button(RB.getStringResource((String)RB_KEY, (String)"button.txt"));
        this.button.initialize();
        this.button.setEnabled(false);
        button2Container.add(this.button);
        modelContainer.add(button2Container);
        this.add(modelContainer);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pushButton) {
            this.validateFilter(this.textField.getText());
        } else if (e.getSource() == this.button) {
            int[] indexes = this.listBox.getSelectedIndexes();
            if (indexes.length > 0) {
                for (int i = indexes.length - 1; i >= 0; --i) {
                    ((OrderedCollectionInterface)this.itemsModel).removeAt(indexes[i]);
                }
            }
        } else if (e.getSource() == this.treeView) {
            this.displayEntry();
        }
    }

    public void contentsChanged(ContentsChangedEvent e) {
        CollectionChangedInfo nevt = (CollectionChangedInfo)e;
        if (nevt.howChanged == HowChanged.ADDED) {
            this.pushButton.setEnabled(false);
            this.textField.setText(null);
            this.treeView.setSelectedItem(null);
            this.listBox.deselectAll();
        } else {
            this.button.setEnabled(false);
            this.listBox.requestFocus();
        }
        if (((Countable)this.itemsModel).count() > 0) {
            Enumeration enc = ((OrderedCollectionInterface)this.itemsModel).getItems();
            String filters = enc.nextElement().toString();
            while (enc.hasMoreElements()) {
                filters = filters + "," + enc.nextElement().toString();
            }
            this.setStartingDirectories(filters, false);
        } else {
            this.setStartingDirectories(null, false);
            this.button.setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.listBox)) {
            System.out.println(this.listBox.getSelectedItems().length + "   " + this.listBox.getSelectedItem());
            if (this.listBox.getSelectedItems().length == 0) {
                this.button.setEnabled(false);
            } else {
                this.button.setEnabled(true);
            }
        }
    }

    private void displayEntry() {
        NodeView nv = this.treeView.getSelectedNode();
        if (nv != null) {
            this.pushButton.setEnabled(true);
            String type = nv.getNodeType();
            String text = null;
            if (this.treeView.getSelectedItem() != null && this.treeView.getSelectedItem().equalsIgnoreCase("My Computer")) {
                text = "*";
                this.isFile = false;
            } else if (type.equalsIgnoreCase("Drive") || type.equalsIgnoreCase("Directory")) {
                text = this.treeView.getSelectedItem();
                this.isFile = false;
            } else if (type.equalsIgnoreCase("File")) {
                text = this.treeView.getSelectedItem();
                this.isFile = true;
            }
            if (text != null) {
                if (this.mouseDClicked) {
                    this.validateFilter(text);
                    this.mouseDClicked = false;
                } else {
                    this.textField.setText(text);
                }
            }
        }
    }

    public String getStartingDirectories() {
        return this.startingDirectories;
    }

    @Override
    public void initialize() {
        this.treeView.addActionListener(this);
        this.treeView.addMouseListener(this);
        this.pushButton.addActionListener(this);
        this.button.addActionListener(this);
        this.textField.addKeyListener(this);
        this.itemsModel = new OrderedCollection();
        this.listBox.setModelInterface(this.itemsModel);
        this.listBox.addItemListener(this);
        if (this.itemsModel instanceof ContentsChangedSource) {
            ((ContentsChangedSource)this.itemsModel).addContentsChangedListener((ContentsChangedListener)this);
        }
        this.treeView.requestFocus();
        this.listBox.setMultipleMode(true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 10) {
            this.pushButton.setEnabled(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.validateFilter(this.textField.getText());
        }
    }

    private void validateFilter(String text) {
        if (!text.endsWith("\\") && !this.isFile) {
            text = text + "\\";
        }
        if (!((OrderedCollectionInterface)this.itemsModel).contains((Object)text)) {
            ((OrderedCollectionInterface)this.itemsModel).add((Object)text);
        } else {
            this.listBox.setSelectedItem(text);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.mouseDClicked = e.getClickCount() > 1;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseDClicked = e.getClickCount() > 1;
        this.displayEntry();
    }

    public void setStartingDirectories(String passedFilters) {
        if (passedFilters != null) {
            this.startingDirectories = "";
            StringTokenizer st = new StringTokenizer(passedFilters, ",;");
            OrderedCollectionInterface im = (OrderedCollectionInterface)this.itemsModel;
            while (st.hasMoreElements()) {
                String item = st.nextToken().trim();
                if (im.contains((Object)item)) continue;
                im.add((Object)item);
            }
        } else {
            this.startingDirectories = null;
        }
    }

    public void setStartingDirectories(String createdFilters, boolean check) {
        if (!check) {
            this.startingDirectories = createdFilters;
            this.firePropertyChange("startingDirectories", null, this.startingDirectories);
        } else {
            this.setStartingDirectories(createdFilters);
        }
    }
}

