/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StringCollection;
import com.sas.io.File;
import com.sas.io.FileNodeComparator;
import com.sas.io.FileSystemList;
import com.sas.io.FilterPredicate;
import com.sas.io.RB;
import com.sas.models.NodeIcon;
import com.sas.models.NodeIconInterface;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.util.ApplyInterface;
import com.sas.util.Comparator;
import com.sas.util.PredicateInterface;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class FileList
extends Component
implements TreeInterface,
NodeIconInterface,
StaticOrderedCollectionInterface,
PropertyChangeListener {
    static final long serialVersionUID = -2998194936602024151L;
    protected static String environmentVariable;
    protected static OrderedCollection coc;
    private static OrderedCollection predCollection;
    protected static OrderedCollection driveCollection;
    protected static OrderedCollection pathCollection;
    protected static OrderedCollection newPathCollection;
    protected static boolean showFiles;
    protected static boolean showDirectories;
    protected static boolean sortSelected;
    private static Thread ft;
    private static Thread nt;
    private static NodeIcon _root;
    protected static final String RB_KEY = "FileList.";
    private String[] startingDirectories;
    private FilterPredicate[] filters;
    private PredicateInterface[] filterPredicates;
    private transient boolean listDrives;
    private boolean recursive;
    private transient boolean listFilled;
    private transient boolean childrenSet;
    protected transient OrderedCollection oc;
    protected transient StringCollection fileNameList;
    private transient ContentsChangedListenerList allContentsChangedListeners;
    protected ContentsChangedListener[] listenerList = null;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "_root"}, {"Hidden", "true"}}, {{"Name", "filterPredicates"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"filters.pd.txt")}}, {{"Name", "startingDirectories"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"startingDirectories.pd.txt")}, {"Property editor class", "com.sas.beans.editors._FiltersEditor"}}, {{"Name", "recursive"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"recursive.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        return ebi;
    }

    private void init() {
        if (this.oc == null) {
            this.oc = new OrderedCollection();
        }
        this.fileNameList = new StringCollection();
        this.childrenSet = false;
        this.listFilled = false;
        this.listDrives = false;
        this.recursive = true;
    }

    public void setDefaultValues() {
        super.setDefaultValues();
        this.init();
    }

    public FileList() {
        this.init();
    }

    public FileList(String startingDirs, String filters, boolean recursive) {
        this.setStartingDirectories(startingDirs);
        this.setFilters(filters);
        this.recursive = recursive;
        this.childrenSet = false;
    }

    public void setStartingDirectories(String startingDirs) {
        if (startingDirs != null && startingDirs.length() > 0) {
            this.listDrives = false;
        }
        String[] old = this.startingDirectories;
        if (startingDirs == null) {
            this.startingDirectories = null;
            return;
        }
        StringTokenizer st = new StringTokenizer(startingDirs, ",;");
        this.startingDirectories = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            this.startingDirectories[i++] = (String)st.nextElement();
        }
        if (this.anyPropertyChangeListeners()) {
            this.firePropertyChange("startingDirectories", old, this.startingDirectories);
        }
    }

    public String getStartingDirectories() {
        if (this.startingDirectories != null) {
            String s = "";
            int cnt = this.startingDirectories.length;
            for (int i = 0; i < cnt; ++i) {
                s = s + this.startingDirectories[i];
                if (i == cnt - 1) continue;
                s = s + ";";
            }
            return s;
        }
        return null;
    }

    public void setFilters(String fils) {
        if (fils != null && fils.length() > 0) {
            this.listDrives = false;
        }
        if (fils == null) {
            this.filterPredicates = null;
            return;
        }
        PredicateInterface[] old = this.filterPredicates;
        StringTokenizer st = new StringTokenizer(fils, ",;");
        this.filterPredicates = new PredicateInterface[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            this.filterPredicates[i++] = this.newFilterPredicate(st.nextElement());
        }
        if (this.anyPropertyChangeListeners()) {
            this.firePropertyChange("filterPredicates", old, this.filterPredicates);
        }
    }

    public String getFilters() {
        if (this.filterPredicates != null) {
            String s = "";
            int cnt = this.filterPredicates.length;
            for (int i = 0; i < cnt; ++i) {
                s = s + this.filterPredicates[i].toString();
                if (i == cnt - 1) continue;
                s = s + ";";
            }
            return s;
        }
        return "";
    }

    public PredicateInterface newFilterPredicate(Object predicateString) {
        return new FilterPredicate(predicateString);
    }

    public void setPredicates(PredicateInterface[] predicates) {
        for (int i = 0; i < predicates.length; ++i) {
            this.filterPredicates[i] = predicates[i];
        }
    }

    public synchronized Enumeration getItems() {
        if (this.isDesignTime()) {
            return new OrderedCollection().getItems();
        }
        this.fillList();
        return this.fileNameList.getItems();
    }

    private void fillList() {
        this.validateFilterPredicates();
        if (this.listDrives) {
            this.fileNameList = new StringCollection(this.startingDirectories);
        } else {
            this.fileNameList = new StringCollection();
            for (int i = 0; i < this.startingDirectories.length; ++i) {
                File f;
                String[] list;
                String path = this.startingDirectories[i];
                if (!path.endsWith(File.separator)) {
                    path = path + File.separator;
                }
                if ((list = (f = new File(path)).list()) == null) continue;
                block1: for (int k = 0; k < list.length; ++k) {
                    for (int j = 0; j < this.filterPredicates.length; ++j) {
                        File child = new File(path, list[k]);
                        if (!this.filterPredicates[j].predicate((Object)child) || child.isDirectory()) continue;
                        this.fileNameList.add(child.getPath());
                        continue block1;
                    }
                }
            }
        }
        this.listFilled = true;
    }

    public synchronized NodeInterface getRoot() {
        return this;
    }

    private void initializeChildren() {
        if (!this.childrenSet && !this.isDesignTime()) {
            this.validateFilterPredicates();
            this.oc.removeAll();
            for (int i = 0; i < this.startingDirectories.length; ++i) {
                String path = this.startingDirectories[i];
                FilteredNode f = new FilteredNode(path);
                f.setNodeText(f.getNodeExpandedText());
                this.oc.add((Object)f);
            }
            this.oc.sort((Comparator)FileNodeComparator.comparator);
            this.childrenSet = true;
        }
    }

    private void validateFilterPredicates() {
        boolean fillfsl = false;
        if (this.startingDirectories == null || this.startingDirectories.length == 0 || this.startingDirectories[0].equals("") || this.startingDirectories[0].equals("*")) {
            fillfsl = true;
            FileSystemList fsl = new FileSystemList();
            Enumeration enumer = fsl.getItems();
            this.startingDirectories = new String[fsl.count()];
            int i = 0;
            while (enumer.hasMoreElements()) {
                this.startingDirectories[i++] = (String)enumer.nextElement();
            }
        }
        if (this.filterPredicates == null || this.filterPredicates.length == 0 || this.filterPredicates[0].toString().equals("") || this.filterPredicates[0].toString().equals("*.*") || this.filterPredicates[0].toString().equals("*")) {
            this.filterPredicates = new PredicateInterface[1];
            this.filterPredicates[0] = this.newFilterPredicate("*");
            if (fillfsl) {
                this.listDrives = true;
            }
        }
    }

    public synchronized boolean isRecursive() {
        return this.recursive;
    }

    public synchronized void setRecursive(boolean recursive) {
        boolean old = recursive;
        this.recursive = recursive;
        if (this.anyPropertyChangeListeners()) {
            this.firePropertyChange("recursive", old ? Boolean.TRUE : Boolean.FALSE, recursive ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    public void fireContentsChanged(ContentsChangedEvent event) {
        if (this.allContentsChangedListeners != null) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged(event);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FileList newData = (FileList)super.clone();
        if (this.startingDirectories != null) {
            newData.startingDirectories = (String[])this.startingDirectories.clone();
        }
        if (this.filterPredicates != null) {
            newData.filterPredicates = (PredicateInterface[])this.filterPredicates.clone();
        }
        newData.oc = (OrderedCollection)this.oc.clone();
        if (this.fileNameList != null) {
            newData.fileNameList = (StringCollection)this.fileNameList.clone();
        }
        newData.allContentsChangedListeners = null;
        return newData;
    }

    public String getNodeExpandedText() {
        if (this.isDesignTime()) {
            return RB.getStringResource((String)RB_KEY, (String)"rootNode.txt");
        }
        String fil = this.getFilters().trim();
        if (fil.equals("*")) {
            return RB.getStringResource((String)RB_KEY, (String)"rootNode.txt");
        }
        return RB.getStringResource((String)RB_KEY, (String)"rootNode.txt") + "(" + fil + ")";
    }

    public String getNodeText() {
        return this.getNodeExpandedText();
    }

    public String getNodeType() {
        return "My Computer";
    }

    public int countNodeChildren(int maximumChildCount) {
        return this.getNodeChildCount();
    }

    public int getNodeChildCount() {
        this.initializeChildren();
        return this.oc.count();
    }

    public boolean isLeafNode() {
        this.initializeChildren();
        return this.oc.count() <= 0;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        return this.getNodeChildren(index, 1)[0];
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        this.initializeChildren();
        SimpleNodeInterface[] si = new SimpleNodeInterface[count];
        int cnt = startIndex + count;
        for (int i = 0; i < cnt; ++i) {
            si[i] = (SimpleNodeInterface)this.oc.get(startIndex++);
        }
        return si;
    }

    public IconInterface getDefaultIcon() {
        return new ImageView(Resources.getImage((String)"MyComputer"));
    }

    public IconInterface getExpandedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getSelectedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getExpandedSelectedIcon() {
        return this.getDefaultIcon();
    }

    public boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        this.refresh();
        return this.fileNameList.equals(orderedCollection);
    }

    public Object get(int index) {
        this.refresh();
        return this.fileNameList.get(index);
    }

    public int getIndex(Object element, int startIndex) {
        this.refresh();
        return this.fileNameList.getIndex(element, startIndex);
    }

    public Enumeration getItems(int start, int end) {
        this.refresh();
        return this.fileNameList.getItems(start, end);
    }

    public int getLastIndex(Object element, int startIndex) {
        this.refresh();
        return this.fileNameList.getLastIndex(element, startIndex);
    }

    public boolean contains(Object element) {
        this.refresh();
        return this.fileNameList.contains(element);
    }

    public int count() {
        this.refresh();
        return this.fileNameList.count();
    }

    public void apply(ApplyInterface action) {
        this.refresh();
        this.fileNameList.apply(action);
    }

    public void sort(Comparator comparator, int start, int end) {
        this.refresh();
        this.fileNameList.sort(comparator, start, end);
        this.fireContentsChanged((ContentsChangedEvent)new CollectionChangedInfo((Object)this, (Object)this.fileNameList, HowChanged.REORDERED));
    }

    public String toString() {
        return this.fileNameList.toString();
    }

    public void refresh() {
        if (!this.listFilled && !this.isDesignTime()) {
            this.fillList();
        }
    }

    public void refreshAlways() {
        this.childrenSet = false;
        this.initializeChildren();
        this.fillList();
        this.fireContentsChanged((ContentsChangedEvent)new CollectionChangedInfo((Object)this, (Object)this.fileNameList, HowChanged.REPLACED));
    }

    protected void sort(Comparator comparator) {
        this.sort(comparator, 0, this.fileNameList.count());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.init();
        stream.defaultReadObject();
    }

    static {
        showFiles = true;
        showDirectories = true;
        sortSelected = false;
        ft = null;
        nt = null;
    }

    class FilteredNode
    extends File {
        FilteredNode(String name) {
            super(name);
        }

        FilteredNode(String path, String name) {
            super(path, name);
        }

        @Override
        protected void initializeChildren() {
            if (this.need_refresh) {
                File t = this;
                String path = this.getPath();
                if ((long)path.indexOf(separator) < this.length()) {
                    t = new File(path + separator);
                }
                this.children.removeAll();
                String[] a = t.list();
                if (a != null) {
                    block0: for (int i = 0; i < a.length; ++i) {
                        for (int j = 0; j < FileList.this.filterPredicates.length; ++j) {
                            PredicateInterface fp = FileList.this.filterPredicates[j];
                            FilteredNode f = new FilteredNode(t.getPath(), a[i]);
                            if (FileList.this.recursive && f.isDirectory()) {
                                this.children.add((Object)f);
                                continue block0;
                            }
                            if ((FileList.this.recursive || f.isDirectory()) && (!FileList.this.recursive || f.isDirectory()) || !fp.predicate((Object)f)) continue;
                            this.children.add((Object)f);
                            continue block0;
                        }
                    }
                    this.children.sort((Comparator)FileNodeComparator.comparator);
                    this.need_refresh = false;
                }
            }
        }
    }
}

