/*
 * Decompiled with CFR 0.152.
 */
package com.sas.idesupport;

import com.sas.GlobalInfoTable;
import com.sas.text.Message;
import com.sas.util.validators.Validator;
import java.util.StringTokenizer;

public class PossibleClassNameValidator
extends Validator {
    protected static final String noClassNameSpecified = "PossibleClassNameValidator.noClassNameSpecified";
    protected static final String invalidJavaClassOrPackage = "PossibleClassNameValidator.invalidJavaClassOrPackage";
    protected static final String onlyString = "PossibleClassNameValidator.onlyString";
    protected static final String classNameCannotEndInDot = "PossibleClassNameValidator.classNameCannotEndInDot";
    protected static final String classNameCannotBeJavaKeyword = "PossibleClassNameValidator.classNameCannotBeJavaKeyword";
    protected static final String classNameCannotBeJavaLangClassName = "PossibleClassNameValidator.classNameCannotBeJavaLangClassName";
    protected static final int NO_CLASS_NAME_SPECIFIED = 0;
    protected static final int INVALID_JAVA_CLASS_OR_PACKAGE = 1;
    protected static final int ONLY_STRING = 2;
    protected static final int CLASS_NAME_CANNOT_END_IN_DOT = 3;
    protected static final int CLASS_NAME_CANNOT_BE_JAVA_KEYWORD = 4;
    protected static final int CLASS_NAME_CANNOT_BE_JAVA_LANG_CLASSNAME = 5;
    public static final String[] javaKeywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "byvalue", "case", "cast", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "future", "generic", "goto", "if", "implements", "import", "inner", "instanceof", "int", "interface", "long", "native", "new", "null", "operator", "outer", "package", "private", "protected", "public", "rest", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "var", "void", "volatile", "while"};

    public static boolean isJavaKeyword(String word) {
        word = word.intern();
        for (int i = 0; i < javaKeywords.length; ++i) {
            if (word != javaKeywords[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isJavaLangClass(String word) {
        String className = "java.lang." + word;
        try {
            GlobalInfoTable.loadClass((String)className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean isJavaWord(String word) {
        if (!Character.isJavaIdentifierStart(word.charAt(0))) {
            return false;
        }
        for (int i = 1; i < word.length(); ++i) {
            if (Character.isJavaIdentifierPart(word.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean validateValue(Object component, Object value) {
        if (value instanceof String) {
            String valueString = (String)value;
            if ((valueString = valueString.trim()).length() == 0) {
                this.setValidationMessage((Message)this.messages.get(0));
                this.setValidationMessageCode(noClassNameSpecified);
                return false;
            }
            if (PossibleClassNameValidator.isJavaKeyword(valueString)) {
                this.setValidationMessage((Message)this.messages.get(4));
                this.setValidationMessageCode(classNameCannotBeJavaKeyword);
                return false;
            }
            if (PossibleClassNameValidator.isJavaLangClass(valueString)) {
                this.setValidationMessage((Message)this.messages.get(5));
                this.setValidationMessageCode(classNameCannotBeJavaLangClassName);
                return false;
            }
            StringTokenizer words = new StringTokenizer(valueString, ".", true);
            boolean ignoreDot = false;
            while (words.hasMoreElements()) {
                String word = (String)words.nextElement();
                if (word.equals(".")) {
                    if (!ignoreDot) {
                        this.setValidationMessage((Message)this.messages.get(1));
                        this.setValidationMessageCode(invalidJavaClassOrPackage);
                        return false;
                    }
                } else if (word.length() == 0 || !PossibleClassNameValidator.isJavaWord(word) || PossibleClassNameValidator.isJavaKeyword(word)) {
                    this.setValidationMessage((Message)this.messages.get(1));
                    this.setValidationMessageCode(invalidJavaClassOrPackage);
                    return false;
                }
                ignoreDot = !ignoreDot;
            }
            if (ignoreDot) {
                return true;
            }
            this.setValidationMessage((Message)this.messages.get(3));
            this.setValidationMessageCode(classNameCannotEndInDot);
            return false;
        }
        this.setValidationMessage((Message)this.messages.get(2));
        this.setValidationMessageCode(onlyString);
        this.setValidationMessage((Message)this.messages.get(0));
        this.setValidationMessageCode(noClassNameSpecified);
        return false;
    }

    public void createValidationMessages() {
        this.messages.add(this.newValidationMessage("No class name specified"));
        this.messages.add(this.newValidationMessage("Invalid Java class or package name"));
        this.messages.add(this.newValidationMessage("PossibleClassNameValidator can only validate Strings"));
        this.messages.add(this.newValidationMessage("Class name cannot end in a dot"));
        this.messages.add(this.newValidationMessage("Class name cannot be a Java keyword"));
        this.messages.add(this.newValidationMessage("Class name cannot be a java.lang classname"));
    }
}

