/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;

public class VectorSegment
extends Element {
    public final NumericProperty beginX = new NumericProperty(this, true);
    public final NumericProperty beginY = new NumericProperty(this, true);
    public final NumericProperty beginZ = new NumericProperty(this, true);
    public final NumericProperty endX = new NumericProperty(this, true);
    public final NumericProperty endY = new NumericProperty(this, true);
    public final NumericProperty endZ = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final NumericProperty lineWidth = new NumericProperty(this, true);
    public final IntegerProperty arrowDirection = new IntegerProperty(this, true);
    public final IntegerProperty arrowShape = new IntegerProperty(this, true);
    public static final int ARROW_DIRECTION_IN = 0;
    public static final int ARROW_DIRECTION_OUT = 1;
    public static final int ARROW_DIRECTION_BOTH = 2;
    public static final int ARROW_DIRECTION_NONE = 3;
    public static final int ARROW_SHAPE_OPEN = 0;
    public static final int ARROW_SHAPE_CLOSED = 1;
    public static final int ARROW_SHAPE_FILLED = 2;
    public static final int ARROW_SHAPE_BARBED = 3;
    protected int stipplePattern;
    protected int stippleFactor;
    static final double[] origin = new double[]{0.0, 0.0, 0.0};
    static final double[] onePixel = new double[]{1.0, 1.0, 1.0};
    static final int arrowXpixels = 8;
    static final int arrowYpixels = 4;

    public VectorSegment() {
        super(new Transform());
        this.lineWidth.setValue(1.0);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        BoundingBox box = bBoxAction.getElementBoundingBox();
        bBoxAction.pt1.set(this.beginX.getValue(index), this.beginY.getValue(index), this.beginZ.getValue(index));
        box.union(bBoxAction.pt1);
        bBoxAction.pt1.set(this.endX.getValue(index), this.endY.getValue(index), this.endZ.getValue(index));
        box.union(bBoxAction.pt1);
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Channel channel = ba.getChannel();
        if (this.stippleFactor > 0) {
            channel.glEnable(6);
            channel.glLineStipple(this.stippleFactor, (short)this.stipplePattern);
        }
        double[] worldOrigin = new double[3];
        double[] worldPixel = new double[3];
        channel.gluUnProject(origin, worldOrigin);
        channel.gluUnProject(onePixel, worldPixel);
        double xPixel = worldPixel[0] - worldOrigin[0];
        double yPixel = worldPixel[1] - worldOrigin[1];
        double bx = 0.0;
        double by = 0.0;
        double bz = 0.0;
        double ex = 0.0;
        double ey = 0.0;
        double ez = 0.0;
        int direction = this.arrowDirection.getValue();
        if (direction == 0) {
            ex = this.beginX.getValue(index);
            ey = this.beginY.getValue(index);
            ez = this.beginZ.getValue(index);
            bx = this.endX.getValue(index);
            by = this.endY.getValue(index);
            bz = this.endZ.getValue(index);
        } else {
            bx = this.beginX.getValue(index);
            by = this.beginY.getValue(index);
            bz = this.beginZ.getValue(index);
            ex = this.endX.getValue(index);
            ey = this.endY.getValue(index);
            ez = this.endZ.getValue(index);
        }
        int shape = this.arrowShape.getValue();
        channel.glLineWidth((float)this.lineWidth.getValue(index));
        channel.glColor(this.color.getValue(index));
        Vec3d lengthVec = new Vec3d(ex - bx, ey - by, ez - bz);
        Vec3d rotationAxis = new Vec3d(1.0, 0.0, 0.0).cross(lengthVec);
        double length = Math.sqrt((ex - bx) * (ex - bx) + (ey - by) * (ey - by) + (ez - bz) * (ez - bz));
        double lineLength = length - 8.0 * xPixel;
        double angle = lengthVec.angle(new Vec3d(1.0, 0.0, 0.0)) * 57.29577951308232;
        channel.glPushMatrix();
        channel.glTranslate((float)bx, (float)by, (float)bz);
        channel.glRotate(angle, rotationAxis.x, rotationAxis.y, rotationAxis.z);
        channel.glBegin(1);
        if (direction == 2) {
            channel.glVertex(8.0 * xPixel, 0.0, 0.0);
        } else {
            channel.glVertex(0.0, 0.0, 0.0);
        }
        if (direction == 3) {
            channel.glVertex((float)length, 0.0, 0.0);
        } else {
            channel.glVertex((double)((float)length) - 8.0 * xPixel, 0.0, 0.0);
        }
        channel.glEnd();
        if (this.stippleFactor > 0) {
            channel.glDisable(6);
        }
        if (direction != 3) {
            double barbYlength;
            double barbXlength;
            double arrowYsize = 4.0 * yPixel;
            double arrowXsize = length - lineLength;
            if (shape == 0) {
                channel.glBegin(1);
                channel.glVertex((float)lineLength, (float)(-arrowYsize), 0.0);
                channel.glVertex((float)length, 0.0, 0.0);
                channel.glEnd();
                channel.glBegin(1);
                channel.glVertex((float)lineLength, (float)arrowYsize, 0.0);
                channel.glVertex((float)length, 0.0, 0.0);
                channel.glVertex((float)lineLength, 0.0, 0.0);
                channel.glEnd();
            } else if (shape == 1) {
                channel.glBegin(1);
                channel.glVertex((float)lineLength, (float)(-arrowYsize), 0.0);
                channel.glVertex((float)length, 0.0, 0.0);
                channel.glVertex((float)lineLength, (float)arrowYsize, 0.0);
                channel.glVertex((float)lineLength, (float)(-arrowYsize), 0.0);
                channel.glEnd();
            } else if (shape == 2) {
                channel.glBegin(2);
                channel.glVertex((float)lineLength, (float)(-arrowYsize), 0.0);
                channel.glVertex((float)length, 0.0, 0.0);
                channel.glVertex((float)lineLength, (float)arrowYsize, 0.0);
                channel.glEnd();
            } else if (shape == 3) {
                barbXlength = 1.5 * arrowXsize;
                barbYlength = 1.5 * arrowYsize;
                channel.glBegin(2);
                channel.glVertex((float)lineLength, 0.0, 0.0);
                channel.glVertex((double)((float)length) - barbXlength, (float)(-barbYlength), 0.0);
                channel.glVertex((float)lineLength, (float)(-arrowYsize), 0.0);
                channel.glEnd();
                channel.glBegin(2);
                channel.glVertex((float)lineLength, 0.0, 0.0);
                channel.glVertex((double)((float)length) - barbXlength, (float)barbYlength, 0.0);
                channel.glVertex((float)lineLength, (float)arrowYsize, 0.0);
                channel.glEnd();
                channel.glBegin(2);
                channel.glVertex((float)lineLength, (float)(-arrowYsize), 0.0);
                channel.glVertex((float)length, 0.0, 0.0);
                channel.glVertex((float)lineLength, (float)arrowYsize, 0.0);
                channel.glEnd();
            }
            if (direction == 2) {
                if (shape == 0) {
                    channel.glBegin(1);
                    channel.glVertex((float)arrowXsize, (float)(-arrowYsize), 0.0);
                    channel.glVertex(0.0, 0.0, 0.0);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex((float)arrowXsize, (float)arrowYsize, 0.0);
                    channel.glVertex(0.0, 0.0, 0.0);
                    channel.glVertex((float)arrowXsize, 0.0, 0.0);
                    channel.glEnd();
                } else if (shape == 1) {
                    channel.glBegin(1);
                    channel.glVertex((float)arrowXsize, (float)(-arrowYsize), 0.0);
                    channel.glVertex(0.0, 0.0, 0.0);
                    channel.glVertex((float)arrowXsize, (float)arrowYsize, 0.0);
                    channel.glVertex((float)arrowXsize, (float)(-arrowYsize), 0.0);
                    channel.glEnd();
                } else if (shape == 2) {
                    channel.glBegin(2);
                    channel.glVertex((float)arrowXsize, (float)(-arrowYsize), 0.0);
                    channel.glVertex(0.0, 0.0, 0.0);
                    channel.glVertex((float)arrowXsize, (float)arrowYsize, 0.0);
                    channel.glEnd();
                } else if (shape == 3) {
                    barbXlength = 1.5 * arrowXsize;
                    barbYlength = 1.5 * arrowYsize;
                    channel.glBegin(2);
                    channel.glVertex((float)arrowXsize, 0.0, 0.0);
                    channel.glVertex((float)barbXlength, (float)(-barbYlength), 0.0);
                    channel.glVertex((float)arrowXsize, (float)(-arrowYsize), 0.0);
                    channel.glEnd();
                    channel.glEnd();
                    channel.glBegin(2);
                    channel.glVertex((float)arrowXsize, 0.0, 0.0);
                    channel.glVertex((float)barbXlength, (float)barbYlength, 0.0);
                    channel.glVertex((float)arrowXsize, (float)arrowYsize, 0.0);
                    channel.glEnd();
                    channel.glBegin(2);
                    channel.glVertex((float)arrowXsize, (float)(-arrowYsize), 0.0);
                    channel.glVertex(0.0, 0.0, 0.0);
                    channel.glVertex((float)arrowXsize, (float)arrowYsize, 0.0);
                    channel.glEnd();
                }
            }
        }
        channel.glPopMatrix();
        channel.glLineWidth(1.0f);
    }

    public void setStipple(int pattern, int factor) {
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
    }

    public int getStipplePattern() {
        return this.stipplePattern;
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }
}

