/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ATriangleConnector;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.SelectDetail;
import com.sas.graphics.util.vtk.TriangleConnectorDetail;
import com.sas.graphics.util.vtk.VTKError;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;
import java.util.Stack;

public class TriangleConnector
extends ATriangleConnector {
    protected int count = 0;
    protected int pointCount;
    private float alpha = 1.0f;
    private boolean smooth = true;
    private int rowSampleSize = 1;
    private int columnSampleSize = 1;
    private Vec3d edge1 = new Vec3d();
    private Vec3d edge2 = new Vec3d();
    private Vec3d v1 = new Vec3d();
    private Vec3d v2 = new Vec3d();
    private Vec3d v3 = new Vec3d();
    private Vec3d v4 = new Vec3d();

    public TriangleConnector() {
        super(new Transform());
    }

    public void setRowSampleSize(int rowSampleSize) {
        this.rowSampleSize = rowSampleSize;
    }

    public int getRowSampleSize() {
        return this.rowSampleSize;
    }

    public void setColumnSampleSize(int columnSampleSize) {
        this.columnSampleSize = columnSampleSize;
    }

    public int getColumnSampleSize() {
        return this.columnSampleSize;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        initAction.pushValueCount();
        this.color.init(initAction);
        this.pointX.init(initAction);
        this.pointY.init(initAction);
        this.pointZ.init(initAction);
        this.pointCount = initAction.getValueCount();
        initAction.popValueCount();
        this.count = 0;
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        boolean detailsEnabled = false;
        Color myColor = new Color(0, 0, 0);
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int index = ba.getValueIndex();
        if (this.width == 0) {
            throw new VTKError("Cannot draw a Triangular Connected Surface without Width. Use setWidth method.");
        }
        try {
            detailsEnabled = this.selectDetailEnabled.getValue(index);
        }
        catch (MissingValueException e) {
            detailsEnabled = false;
        }
        channel.glPushAttrib(0);
        channel.glEdgeColor(this.edgeColor.getValue(index));
        channel.glPolygonMode(BuildAction.getJXDFillStyle(this.fillOn.getValue(index), this.edgeOn.getValue(index)));
        for (int i = 0; i < this.pointCount / this.width; i += this.rowSampleSize) {
            for (int j = 0; j < this.width; j += this.columnSampleSize) {
                index = i * this.width + j;
                try {
                    this.currRowPointX[this.count] = this.pointX.getValue(index);
                    this.currRowPointY[this.count] = this.pointY.getValue(index);
                    this.currRowPointZ[this.count] = this.pointZ.getValue(index);
                    this.currRowColor[this.count] = this.color.getValue(index);
                }
                catch (MissingValueException mve) {
                    this.currRowPointX[this.count] = Double.POSITIVE_INFINITY;
                    this.currRowPointY[this.count] = Double.POSITIVE_INFINITY;
                    this.currRowPointZ[this.count] = Double.POSITIVE_INFINITY;
                    this.currRowColor[this.count] = Color.black;
                }
                try {
                    myColor = this.color.getValue(index);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                channel.glColor(myColor, this.alpha);
                if (i > 0 && j > 0) {
                    double g1 = 1.0;
                    double g2 = 0.0;
                    this.v1.x = this.currRowPointX[this.count];
                    this.v1.y = this.currRowPointY[this.count];
                    this.v1.z = this.currRowPointZ[this.count];
                    Color c1 = this.currRowColor[this.count];
                    this.v2.x = this.currRowPointX[this.count - 1];
                    this.v2.y = this.currRowPointY[this.count - 1];
                    this.v2.z = this.currRowPointZ[this.count - 1];
                    Color c2 = this.currRowColor[this.count - 1];
                    this.v3.x = this.prevRowPointX[this.count - 1];
                    this.v3.y = this.prevRowPointY[this.count - 1];
                    this.v3.z = this.prevRowPointZ[this.count - 1];
                    Color c3 = this.prevRowColor[this.count - 1];
                    this.v4.x = this.prevRowPointX[this.count];
                    this.v4.y = this.prevRowPointY[this.count];
                    this.v4.z = this.prevRowPointZ[this.count];
                    Color c4 = this.prevRowColor[this.count];
                    if (Double.isInfinite(this.v1.x) || Double.isInfinite(this.v2.x) || Double.isInfinite(this.v3.x) || Double.isInfinite(this.v4.x)) {
                        g1 = Double.isInfinite(this.v2.x) || Double.isInfinite(this.v4.x) ? Double.POSITIVE_INFINITY : Vec3d.gradient((Vec3d)this.v2, (Vec3d)this.v4);
                        g2 = Double.isInfinite(this.v1.x) || Double.isInfinite(this.v3.x) ? Double.POSITIVE_INFINITY : Vec3d.gradient((Vec3d)this.v1, (Vec3d)this.v3);
                    } else {
                        g1 = Vec3d.gradient((Vec3d)this.v2, (Vec3d)this.v4);
                        g2 = Vec3d.gradient((Vec3d)this.v1, (Vec3d)this.v3);
                    }
                    if (Double.isInfinite(g1) || Double.isInfinite(g2)) {
                        if (Double.isInfinite(g1)) {
                            if (!Double.isInfinite(this.v2.x) || !Double.isInfinite(this.v4.x)) {
                                if (Double.isInfinite(this.v2.x)) {
                                    channel.glBegin(2);
                                    this.buildTriangle(channel, detailsEnabled, index, this.v1, c1, this.v3, c3, this.v4, c4);
                                    channel.glEnd();
                                } else if (Double.isInfinite(this.v4.x)) {
                                    channel.glBegin(2);
                                    this.buildTriangle(channel, detailsEnabled, index, this.v1, c1, this.v2, c2, this.v3, c3);
                                    channel.glEnd();
                                }
                            }
                        } else if (!(!Double.isInfinite(g2) || Double.isInfinite(this.v1.x) && Double.isInfinite(this.v3.x))) {
                            if (Double.isInfinite(this.v1.x)) {
                                channel.glBegin(2);
                                this.buildTriangle(channel, detailsEnabled, index, this.v2, c2, this.v3, c3, this.v4, c4);
                                channel.glEnd();
                            } else if (Double.isInfinite(this.v3.x)) {
                                channel.glBegin(2);
                                this.buildTriangle(channel, detailsEnabled, index, this.v2, c2, this.v4, c4, this.v1, c1);
                                channel.glEnd();
                            }
                        }
                    } else if (g1 < g2) {
                        channel.glBegin(2);
                        this.buildTriangle(channel, detailsEnabled, index, this.v2, c2, this.v3, c3, this.v4, c4);
                        channel.glEnd();
                        channel.glBegin(2);
                        this.buildTriangle(channel, detailsEnabled, index, this.v2, c2, this.v4, c4, this.v1, c1);
                        channel.glEnd();
                    } else {
                        channel.glBegin(2);
                        this.buildTriangle(channel, detailsEnabled, index, this.v1, c1, this.v2, c2, this.v3, c3);
                        channel.glEnd();
                        channel.glBegin(2);
                        this.buildTriangle(channel, detailsEnabled, index, this.v1, c1, this.v3, c3, this.v4, c4);
                        channel.glEnd();
                    }
                }
                if (j + this.columnSampleSize > this.width - 1) {
                    System.arraycopy(this.currRowPointX, 0, this.prevRowPointX, 0, this.width);
                    System.arraycopy(this.currRowPointY, 0, this.prevRowPointY, 0, this.width);
                    System.arraycopy(this.currRowPointZ, 0, this.prevRowPointZ, 0, this.width);
                    System.arraycopy(this.currRowColor, 0, this.prevRowColor, 0, this.width);
                    this.count = 0;
                    continue;
                }
                ++this.count;
            }
        }
        channel.glPopAttrib();
    }

    private void buildTriangle(Channel channel, boolean selectDetailsOn, int index, Vec3d v1, Color c1, Vec3d v2, Color c2, Vec3d v3, Color c3) {
        if (selectDetailsOn) {
            channel.glLoadName(new Integer(index));
        }
        this.edge1.set(v2.x - v1.x, v2.y - v1.y, v2.z - v1.z);
        this.edge2.set(v3.x - v1.x, v3.y - v1.y, v3.z - v1.z);
        Vec3d cross = this.edge1.cross(this.edge2);
        channel.glNormal(cross.x, cross.y, cross.z);
        channel.glColor(c1, this.alpha);
        channel.glVertex(v1.x, v1.y, v1.z);
        channel.glColor(c2, this.alpha);
        channel.glVertex(v2.x, v2.y, v2.z);
        channel.glColor(c3, this.alpha);
        channel.glVertex(v3.x, v3.y, v3.z);
    }

    @Override
    protected SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        int detailIndex = startIndex + entryLength - 1;
        Integer cellIndex = (Integer)nameStack.elementAt(detailIndex);
        return new TriangleConnectorDetail(cellIndex, this.width);
    }
}

