/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.Action;
import com.sas.graphics.util.vtk.MissingValueException;

public class Transform
extends ATransform {
    private Vec3d t = new Vec3d();
    private Vec3d c = new Vec3d();
    private Vec3d axis = new Vec3d();
    private Vec3d sOAxis = new Vec3d();
    private Vec3d s = new Vec3d();

    @Override
    public void push(Action action) {
        Channel channel = (Channel)action.getGraphicsContext();
        channel.glPushMatrix();
    }

    @Override
    public void pop(Action action) {
        Channel channel = (Channel)action.getGraphicsContext();
        channel.glPopMatrix();
    }

    @Override
    public void loadIdentity(Action action) {
        Channel channel = (Channel)action.getGraphicsContext();
        channel.glLoadIdentity();
    }

    @Override
    public void getMatrix(Action action, double[] matrix) {
        Channel channel = (Channel)action.getGraphicsContext();
        channel.glGetMatrix(matrix);
    }

    @Override
    public void apply(Action action) throws MissingValueException {
        boolean isScaleOrientation;
        Channel channel = (Channel)action.getGraphicsContext();
        int i = action.getValueIndex();
        this.t.x = this.translateX.getValue(i);
        this.t.y = this.translateY.getValue(i);
        this.t.z = this.translateZ.getValue(i);
        boolean isTranslation = !Transform.isZero(this.t.x, this.t.y, this.t.z);
        this.c.x = this.centerX.getValue(i);
        this.c.y = this.centerY.getValue(i);
        this.c.z = this.centerZ.getValue(i);
        boolean isCenter = !Transform.isZero(this.c.x, this.t.y, this.t.z);
        this.axis.x = this.rotationAxisX.getValue(i);
        this.axis.y = this.rotationAxisY.getValue(i);
        this.axis.z = this.rotationAxisZ.getValue(i);
        double angle = this.rotationAngle.getValue(i);
        boolean isRotation = !Transform.isZero(angle);
        this.s.x = this.scaleX.getValue(i);
        this.s.y = this.scaleY.getValue(i);
        this.s.z = this.scaleZ.getValue(i);
        boolean isScale = !Transform.isZero(this.s.x - 1.0, this.s.y - 1.0, this.s.z - 1.0);
        this.sOAxis.x = this.scaleOrientationAxisX.getValue(i);
        this.sOAxis.y = this.scaleOrientationAxisY.getValue(i);
        this.sOAxis.z = this.scaleOrientationAxisZ.getValue(i);
        double sOAngle = this.scaleOrientationAngle.getValue(i);
        boolean bl = isScaleOrientation = !Transform.isZero(sOAngle);
        if (isTranslation) {
            channel.glTranslate(this.t.x, this.t.y, this.t.z);
        }
        if (isCenter) {
            channel.glTranslate(this.c.x, this.c.y, this.c.z);
        }
        if (isRotation) {
            channel.glRotate(angle * 57.29577951308232, this.axis.x, this.axis.y, this.axis.z);
        }
        if (isScaleOrientation) {
            channel.glRotate(sOAngle * 57.29577951308232, this.sOAxis.x, this.sOAxis.y, this.sOAxis.z);
        }
        if (isScale) {
            channel.glScale(this.s.x, this.s.y, this.s.z);
        }
        if (isScaleOrientation) {
            channel.glRotate(-sOAngle * 57.29577951308232, this.sOAxis.x, this.sOAxis.y, this.sOAxis.z);
        }
        if (isCenter) {
            channel.glTranslate(-this.c.x, -this.c.y, -this.c.z);
        }
    }
}

