/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.NumericMap;
import com.sas.graphics.util.vtk.NumericMapper;
import com.sas.graphics.util.vtk.TextStyle;
import com.sas.graphics.util.vtk.jxd.Axis;
import com.sas.graphics.util.vtk.jxd.LineSegment;
import java.awt.Color;

public class RectangularAxis
extends Axis {
    private double lineOffset = 0.0;
    private Vec3d tempVec3d = new Vec3d();

    public RectangularAxis(NumericMapper aMapper, int anOrientation, int labelOrientation) {
        this();
        this.setLabels(aMapper.label);
        this.setLabelOffset(aMapper.uniqueValue);
        this.setOrientation(anOrientation);
        this.setLabelOrientation(labelOrientation);
    }

    public RectangularAxis(NumericMap aMap, int anOrientation, int labelOrientation) {
        this();
        this.setLabels(aMap.label);
        this.setLabelOffset(aMap.uniqueValue);
        this.setOrientation(anOrientation);
        this.setLabelOrientation(labelOrientation);
    }

    public RectangularAxis() {
        this.orientation = 1;
        this.axisSize = 1.0;
        this.setJustificationStyles();
    }

    public void setLineOffset(double lineOffset) {
        this.lineOffset = lineOffset;
    }

    @Override
    public double getLineOffset() {
        return this.lineOffset;
    }

    @Override
    protected void setJustificationStyles() {
        TextStyle label = this.style.getLabelStyle();
        TextStyle title = this.style.getTitleStyle();
        switch (this.orientation) {
            case 1: {
                label.setVerticalJustification(0);
                label.setHorizontalJustification(1);
                title.setHorizontalJustification(1);
                break;
            }
            case 2: {
                label.setHorizontalJustification(2);
                title.setHorizontalJustification(1);
                label.setVerticalJustification(1);
                title.setVerticalJustification(3);
                break;
            }
            case 3: {
                switch (this.labelOrientation) {
                    case 1: 
                    case 3: {
                        label.setHorizontalJustification(2);
                        title.setHorizontalJustification(2);
                        title.setVerticalJustification(0);
                        break;
                    }
                    case 2: {
                        label.setHorizontalJustification(2);
                        title.setHorizontalJustification(2);
                        title.setVerticalJustification(0);
                    }
                }
                label.setVerticalJustification(0);
            }
        }
        this.style.setLabelStyle(label);
        this.style.setTitleStyle(title);
    }

    @Override
    protected void orient(Vec3d v, double x, double y, double z, int direction) {
        switch (direction) {
            case 1: {
                if (this.labelOrientation == 3) {
                    v.set(x, z, y);
                    break;
                }
                v.set(x, y, z);
                break;
            }
            case 2: {
                if (this.labelOrientation == 3) {
                    v.set(z, x, y);
                    break;
                }
                v.set(y, x, z);
                break;
            }
            case 3: {
                if (this.labelOrientation == 1) {
                    v.set(y, z, x);
                    break;
                }
                v.set(z, y, x);
            }
        }
    }

    @Override
    protected double getDistance(int observation) {
        return this.axisSize;
    }

    @Override
    protected void move2Origin() {
        Vec3d v = new Vec3d();
        this.orient(v, this.origin, 0.0, 0.0);
        this.channel.glTranslate(v.x, v.y, v.z);
    }

    @Override
    protected void drawAxisLine(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width, BoundingBox bbox) {
        if (this.lineOffset != 0.0) {
            Vec3d v = this.tempVec3d;
            v.set(this.lineOffset, 0.0, 0.0);
            this.orient(v, v.x, v.y, v.z);
            beginX += v.x;
            beginY += v.y;
            beginZ += v.z;
            endX += v.x;
            endY += v.y;
            endZ += v.z;
        }
        this.drawLine(beginX, beginY, beginZ, endX, endY, endZ, color, width, bbox);
    }

    @Override
    protected void drawLine(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width, BoundingBox bbox) {
        Vec3d v = this.tempVec3d;
        if (bbox == null) {
            LineSegment.drawLineSegment(this.channel, beginX, beginY, beginZ, endX, endY, endZ, color, width, 0, 0);
        } else {
            v.set(beginX, beginY, beginZ);
            bbox.union(v);
            v.set(endX, endY, endZ);
            bbox.union(v);
        }
    }

    public static RectangularAxis getXAxis(NumericMapper aMapper, double length) {
        RectangularAxis axis = new RectangularAxis(aMapper, 1, 2);
        axis.setLength(length);
        return axis;
    }

    public static RectangularAxis getYAxis(NumericMapper aMapper, double length) {
        RectangularAxis axis = new RectangularAxis(aMapper, 2, 1);
        axis.setLength(length);
        return axis;
    }

    public static RectangularAxis getZAxis(NumericMapper aMapper, double length) {
        RectangularAxis axis = new RectangularAxis(aMapper, 3, 1);
        axis.setLength(length);
        return axis;
    }

    public static RectangularAxis getXAxis(NumericMap aMap, double length) {
        RectangularAxis axis = new RectangularAxis(aMap, 1, 2);
        axis.setLength(length);
        return axis;
    }

    public static RectangularAxis getYAxis(NumericMap aMap, double length) {
        RectangularAxis axis = new RectangularAxis(aMap, 2, 1);
        axis.setLength(length);
        return axis;
    }

    public static RectangularAxis getZAxis(NumericMap aMap, double length) {
        RectangularAxis axis = new RectangularAxis(aMap, 3, 1);
        axis.setLength(length);
        return axis;
    }
}

