/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.ARectangle;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class Rectangle
extends ARectangle {
    public Rectangle() {
        super(new Transform());
    }

    public static void drawRectangle(Channel channel, double sizeX, double sizeY, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, int origin) {
        double sXHalf = sizeX / 2.0;
        double sYHalf = sizeY / 2.0;
        Vec3d center = new Vec3d();
        ARectangle.computeCenter(sizeX, sizeY, origin, center);
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getJXDFillStyle(fillOn, edgeOn));
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        channel.glVertex(center.x - sXHalf, center.y - sYHalf);
        channel.glVertex(center.x + sXHalf, center.y - sYHalf);
        channel.glVertex(center.x + sXHalf, center.y + sYHalf);
        channel.glVertex(center.x - sXHalf, center.y + sYHalf);
        channel.glEnd();
        channel.glPopAttrib();
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Rectangle.drawRectangle(ba.getChannel(), this.sizeX.getValue(index), this.sizeY.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), this.edgeOn.getValue(index), this.fillOn.getValue(index), this.origin.getValue(index));
    }
}

