/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AAxis;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.TextStyle;
import com.sas.graphics.util.vtk.jxd.Axis;
import com.sas.graphics.util.vtk.jxd.Circle;
import java.awt.Color;

public class PolarAxis
extends Axis {
    public final NumericProperty radius = new NumericProperty(this, false);
    protected double startAngle = 0.0;
    boolean horizJustInvert;
    boolean vertJustInvert;
    static double[] ranges = new double[]{0.39269908169872414, 1.1780972450961724, 1.9634954084936207, 2.748893571891069, 3.5342917352885173, 4.319689898685965, 5.105088062083414, 5.890486225480862, 6.675884388878311};
    static int[] hJustification = new int[]{0, 0, 1, 2, 2, 2, 1, 0, 0, 0, 0, 1, 2};
    static int[] vJustification = new int[]{1, 3, 3, 3, 1, 0, 0, 0, 1, 1, 3, 3, 3};

    public PolarAxis() {
        this.radius.setValue(0.5);
        this.axisSize = 1.0;
        this.setOrientation(3);
        this.setJustificationStyles();
        this.titlePosition = 0;
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        initAction.pushValueCount();
        initAction.setValueCount(this.rawLabelCount);
        this.radius.init(initAction);
        initAction.popValueCount();
        if (this.style.getLabelStyle().isStagger()) {
            this.findAvailableSpace(1, false);
        }
    }

    @Override
    public void reset(AResetAction resetAction) {
        super.reset(resetAction);
        this.radius.reset(resetAction);
    }

    public void setStartAngle(double angle) {
        this.startAngle = angle;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setSize(double diameter) {
        this.setLength(diameter);
    }

    public double getSize() {
        return this.axisSize;
    }

    @Override
    protected void setJustificationStyles() {
        this.style.getTitleStyle().setHorizontalJustification(1);
        this.style.getTitleStyle().setVerticalJustification(0);
    }

    @Override
    protected double getDistance(int observation) {
        try {
            return this.radius.getValue(observation);
        }
        catch (MissingValueException mve) {
            return Double.NaN;
        }
    }

    @Override
    protected void move2Origin() {
        switch (this.orientation) {
            case 1: {
                this.channel.glTranslate(this.origin, 0.0, 0.0);
                this.channel.glRotate(90.0, 0.0, 1.0, 0.0);
                break;
            }
            case 2: {
                this.channel.glTranslate(0.0, this.origin, 0.0);
                this.channel.glRotate(-90.0, 1.0, 0.0, 0.0);
                break;
            }
            case 3: {
                this.channel.glTranslate(0.0, 0.0, this.origin);
            }
        }
    }

    @Override
    protected void drawAxisLine(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width, BoundingBox bbox) {
        double radius = Math.sqrt((endX -= beginX) * endX + (endY -= beginY) * endY + (endZ -= beginZ) * endZ);
        if (bbox == null) {
            Circle.drawCircle(this.channel, radius, color, color, true, false, 36);
        } else {
            Vec3d v = new Vec3d(beginX - radius, beginY - radius, 0.0);
            bbox.union(v);
            v.set(beginX + radius, beginY + radius, 0.0);
            bbox.union(v);
        }
    }

    @Override
    protected void positionTitle(Vec3d titleOrigin, double length) {
        switch (this.titlePosition) {
            default: {
                titleOrigin.x = 1.5707963267948966 - this.startAngle;
                break;
            }
            case 1: {
                titleOrigin.x = -this.startAngle;
                break;
            }
            case 2: {
                titleOrigin.x = -1.5707963267948966 - this.startAngle;
            }
        }
        this.orient(titleOrigin, titleOrigin.x, titleOrigin.y, titleOrigin.z);
    }

    @Override
    protected void orient(Vec3d v, double x, double y, double z, int direction) {
        double a = this.startAngle + x;
        double cosA = Math.cos(a);
        double sinA = Math.sin(a);
        double r = this.axisSize * 0.5;
        if (this.labelOrientation == this.orientation) {
            v.set(cosA * r, sinA * r, y);
        } else {
            v.set(cosA * (r - y), sinA * (r - y), 0.0);
        }
    }

    @Override
    protected void justify(AAxis.LabelAlignment alignment, TextStyle style) {
        int i;
        double offset = alignment.offset % (Math.PI * 2);
        if (offset < 0.0) {
            offset += Math.PI * 2;
        }
        for (i = 0; i < ranges.length && offset > ranges[i]; ++i) {
        }
        if (!this.primary) {
            i += 4;
        }
        this.justifyLabelH = hJustification[i];
        this.justifyLabelV = vJustification[i];
    }
}

