/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.ALineSegment;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class LineSegment
extends ALineSegment {
    public LineSegment() {
        super(new Transform());
    }

    public static void drawLineSegment(Channel channel, double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, double lineWidth, int stipplePat, int stippleFac) {
        if (stippleFac > 0) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFac, (short)stipplePat);
        }
        channel.glLineWidth((float)lineWidth);
        channel.glColor(color);
        channel.glBegin(1);
        channel.glVertex((float)beginX, (float)beginY, (float)beginZ);
        channel.glVertex((float)endX, (float)endY, (float)endZ);
        channel.glEnd();
        channel.glLineWidth(1.0f);
        if (stippleFac > 0) {
            channel.glDisable(6);
        }
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        double bx = this.beginX.getValue(index);
        double by = this.beginY.getValue(index);
        double bz = this.beginZ.getValue(index);
        double ex = this.endX.getValue(index);
        double ey = this.endY.getValue(index);
        double ez = this.endZ.getValue(index);
        LineSegment.drawLineSegment(ba.getChannel(), bx, by, bz, ex, ey, ez, this.color.getValue(index), this.lineWidth.getValue(index), this.stipplePattern, this.stippleFactor);
    }
}

