/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.ALineConnector;
import com.sas.graphics.util.vtk.Action;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.LineSegment;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class LineConnector
extends ALineConnector {
    protected Color myColor = ColorProperty.getDefaultColor();
    protected Color myFillColor = ColorProperty.getDefaultColor();
    protected float myLineWidth;

    public LineConnector() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        block12: {
            BuildAction ba = BuildAction.castBuildAction(buildAction);
            Channel channel = ba.getChannel();
            int index = ba.getValueIndex();
            if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointZ)) {
                try {
                    this.beginPointX = this.pointX.getValue(index);
                    this.beginPointY = this.pointY.getValue(index);
                    this.beginPointZ = this.pointZ.getValue(index);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                return;
            }
            try {
                this.myLineWidth = (float)this.lineWidth.getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            try {
                this.myColor = this.color.getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            try {
                this.myFillColor = this.fillColor.getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            try {
                this.endPointX = this.pointX.getValue(index);
                this.endPointY = this.pointY.getValue(index);
                this.endPointZ = this.pointZ.getValue(index);
                channel.glPushAttrib(0);
                channel.lineCapStyle(1);
                if (this.fillOn.getValue(index)) {
                    channel.glColor(this.myFillColor);
                    this.drawFillUnder(ba);
                }
                LineSegment.drawLineSegment(channel, this.beginPointX, this.beginPointY, this.beginPointZ, this.endPointX, this.endPointY, this.endPointZ, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                channel.glPopAttrib();
                this.beginPointX = this.endPointX;
                this.beginPointY = this.endPointY;
                this.beginPointZ = this.endPointZ;
            }
            catch (MissingValueException mve) {
                if (!this.skipMissing) break block12;
                this.beginPointX = Double.NaN;
                this.beginPointY = Double.NaN;
                this.beginPointZ = Double.NaN;
            }
        }
    }

    @Override
    protected void drawTrapezoid(Action action, int drawMode, Vec3d normal, Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4) {
        Channel channel = (Channel)action.getGraphicsContext();
        if (channel != null) {
            if (drawMode == 3) {
                channel.setExtrusionVector(this.depth.x, this.depth.y, this.depth.z);
            }
            channel.glBegin(drawMode);
            channel.glNormal(normal.x, normal.y, normal.z);
            channel.glVertex(v1.x, v1.y, v1.z);
            channel.glVertex(v2.x, v2.y, v2.z);
            channel.glVertex(v3.x, v3.y, v3.z);
            channel.glVertex(v4.x, v4.y, v4.z);
            channel.glVertex(v1.x, v1.y, v1.z);
            channel.glEnd();
        }
    }
}

