/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ALegend;
import com.sas.graphics.util.vtk.ColorMap;
import com.sas.graphics.util.vtk.ColorMapper;
import com.sas.graphics.util.vtk.LegendDetail;
import com.sas.graphics.util.vtk.LegendStyle;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.SelectDetail;
import com.sas.graphics.util.vtk.TextStyle;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.InitAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;
import java.awt.Font;
import java.util.Stack;

public class Legend
extends ALegend {
    protected Channel channel = null;
    private int labelCount;
    private int rangeCount;
    private double maxLabelLength = 0.0;
    private double maxLabelHeight = 0.0;
    private double[] maxColumnLabelLength = new double[5];
    private double[] labelLength = new double[5];
    private double[] labelHeight = new double[5];
    private String[] labelArray = new String[5];
    private double tmpWidth = Double.NaN;
    private double tmpHeight = Double.NaN;
    double titleMargin = 0.0;
    double labelMargin = 0.0;
    private boolean scaleFont = false;
    private double pixelWidth;
    private int numOfRows = 0;
    private int numOfColumns = 0;
    private boolean endLabelsOnly = true;
    private double[] titleInsets;
    static final int TOP = 0;
    static final int BOTTOM = 1;
    static final int LEFT = 2;
    static final int RIGHT = 3;
    static int q = 0;

    public Legend(ColorMapper mapper) {
        this();
        this.labels.connectFrom(mapper.label);
        this.colors.connectFrom(mapper.uniqueValue);
    }

    public Legend(ColorMap map) {
        this();
        this.labels.connectFrom(map.label);
        this.colors.connectFrom(map.uniqueValue);
    }

    public Legend() {
        super(new Transform());
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        this.labelCount = this.initLabels(initAction);
        this.rangeCount = this.isContinuous() ? this.labelCount - 1 : this.labelCount;
    }

    @Override
    protected int initLabels(AInitAction initAction) {
        int index;
        initAction.pushValueCount();
        this.labels.init(initAction);
        this.colors.init(initAction);
        this.markerTypes.init(initAction);
        int labelCount = initAction.getValueCount();
        initAction.popValueCount();
        this.channel = InitAction.castInitAction(initAction).getChannel();
        double[] origin = new double[]{0.0, 0.0, 0.0};
        double[] win = new double[3];
        double[] winpixel = new double[3];
        this.channel.gluProject(origin, win);
        win[0] = win[0] + 1.0;
        win[1] = win[1] + 1.0;
        this.channel.gluUnProject(win, winpixel);
        this.pixelWidth = winpixel[0];
        winpixel = null;
        origin = null;
        win = null;
        this.labelMargin = this.titleMargin = 4.0 * this.pixelWidth;
        if (labelCount <= 0) {
            return labelCount;
        }
        this.channel.glSelect2DFont(this.style.getLabelStyle().getFont());
        this.maxLabelLength = Double.NEGATIVE_INFINITY;
        this.maxLabelHeight = Double.NEGATIVE_INFINITY;
        this.tmpHeight = 0.0;
        this.tmpWidth = 0.0;
        if (this.labelLength.length < labelCount) {
            this.labelLength = new double[labelCount];
            this.labelHeight = new double[labelCount];
            this.labelArray = new String[labelCount];
            this.maxColumnLabelLength = new double[labelCount];
        }
        double geometryWidth = this.channel.glGetTextDescent() + this.channel.glGetTextAscent();
        if (this.isContinuous()) {
            for (index = 0; index < labelCount; ++index) {
                try {
                    this.labelArray[index] = this.labels.getValue(index);
                }
                catch (MissingValueException mve) {
                    this.labelArray[index] = new String("Missing");
                }
                this.labelLength[index] = this.channel.glGetTextWidth(this.labelArray[index]);
                this.labelHeight[index] = this.channel.glGetTextHeight(this.labelArray[index]);
                this.maxLabelLength = Math.max(this.labelLength[index], this.maxLabelLength);
                this.maxLabelHeight = Math.max(this.labelHeight[index], this.maxLabelHeight);
                if (this.isLayoutByRow()) {
                    this.tmpWidth = 2.0 * (this.labelLength[0] + this.labelLength[1]) + 4.0 * this.labelMargin;
                    this.tmpHeight = 2.0 * this.labelMargin + this.maxLabelHeight;
                    continue;
                }
                this.tmpWidth = this.maxLabelLength + 3.0 * this.labelMargin + geometryWidth;
                this.tmpHeight = 5.0 * this.maxLabelHeight + 2.0 * this.labelMargin + this.maxLabelHeight;
            }
        } else {
            int layoutCount = this.getLayoutCount();
            for (index = 0; index < labelCount; ++index) {
                try {
                    this.labelArray[index] = this.labels.getValue(index);
                    this.labelLength[index] = this.channel.glGetTextWidth(this.labelArray[index]);
                    this.labelHeight[index] = this.channel.glGetTextHeight(this.labelArray[index]);
                    this.maxLabelLength = Math.max(this.labelLength[index], this.maxLabelLength);
                    this.maxLabelHeight = Math.max(this.labelHeight[index], this.maxLabelHeight);
                    this.maxColumnLabelLength[index] = 0.0;
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            int rowOffset = 0;
            double w = 0.0;
            double h = 0.0;
            w = 0.0;
            h = 0.0;
            if (this.isLayoutByRow()) {
                if (layoutCount <= 0 || labelCount <= layoutCount) {
                    this.numOfRows = 1;
                    this.numOfColumns = labelCount;
                } else {
                    this.numOfRows = labelCount / layoutCount;
                    this.numOfColumns = layoutCount;
                    if (labelCount % layoutCount != 0) {
                        ++this.numOfRows;
                    }
                }
                for (index = 0; index < this.numOfRows; ++index) {
                    rowOffset = index * this.numOfColumns;
                    for (int j = 0; j < this.numOfColumns && rowOffset + j < this.labelLength.length; ++j) {
                        h = Math.max(h, this.labelHeight[rowOffset + j]);
                        this.maxColumnLabelLength[j] = Math.max(this.maxColumnLabelLength[j], this.labelLength[rowOffset + j]);
                    }
                    this.tmpHeight += h;
                    h = 0.0;
                }
                for (index = 0; index < this.numOfColumns; ++index) {
                    this.tmpWidth += this.maxColumnLabelLength[index] + geometryWidth + 3.0 * this.labelMargin;
                }
            } else {
                if (layoutCount <= 0 || labelCount <= layoutCount) {
                    this.numOfRows = labelCount;
                    this.numOfColumns = 1;
                } else {
                    this.numOfRows = layoutCount;
                    this.numOfColumns = labelCount / layoutCount;
                    if (labelCount % layoutCount != 0) {
                        ++this.numOfColumns;
                    }
                }
                for (index = 0; index < this.numOfRows; ++index) {
                    int j = index;
                    for (int c = 0; c < this.numOfColumns && j < this.labelLength.length; j += this.numOfRows, ++c) {
                        h = Math.max(h, this.labelHeight[j]);
                        this.maxColumnLabelLength[c] = Math.max(this.maxColumnLabelLength[c], this.labelLength[j]);
                    }
                    this.tmpHeight += h;
                    h = 0.0;
                }
                for (index = 0; index < this.numOfColumns; ++index) {
                    this.tmpWidth += this.maxColumnLabelLength[index] + geometryWidth + 3.0 * this.labelMargin;
                }
            }
            this.tmpHeight += this.labelMargin * (double)(this.numOfRows + 1);
        }
        return labelCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        int valueIndex = buildAction.getValueIndex();
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        this.channel = ba.getChannel();
        String titleStr = null;
        try {
            this.channel.glPushAttrib(0);
            if (this.style.isTitleOn()) {
                titleStr = this.title.getValue(valueIndex);
                Vec3d tp = this.addTitleDimensions(this.channel, titleStr, this.tmpWidth, this.tmpHeight, this.style);
                this.tmpWidth = tp.x;
                this.tmpHeight = tp.y;
            }
            if (this.style.isBorderOn()) {
                Vec3d bp = this.addBorderDimensions(this.tmpWidth, this.tmpHeight, this.style);
                this.tmpWidth = bp.x;
                this.tmpHeight = bp.y;
            }
            if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
                double w = this.getWidth();
                double h = this.getHeight();
                if (this.isLayoutByRow() || w > this.tmpWidth) {
                    this.tmpWidth = w;
                }
                if (!this.isLayoutByRow() || h > this.tmpHeight) {
                    this.tmpHeight = h;
                }
            }
            if (this.style.isBackgroundOn()) {
                this.channel.glNormal(0.0, 0.0, 1.0);
                this.drawBackground(this.tmpWidth, this.tmpHeight, this.style.getBackgroundColor());
                this.channel.glTranslate(0.0, 0.0, this.pixelWidth / 2.0);
            }
            this.titleInsets = this.drawTitleBorder(this.channel, this.tmpWidth, this.tmpHeight, titleStr, this.borderColor.getValue(valueIndex), this.borderLineColor.getValue(valueIndex), this.style);
            this.titleInsets[0] = this.titleInsets[0] + this.labelMargin;
            this.titleInsets[1] = this.titleInsets[1] + this.labelMargin;
            this.titleInsets[2] = this.titleInsets[2] + this.labelMargin;
            this.titleInsets[3] = this.titleInsets[3] + this.labelMargin;
            if (this.labelCount <= 0) {
                return;
            }
            double usableWidth = this.tmpWidth - (this.titleInsets[2] + this.titleInsets[3]);
            double usableHeight = this.tmpHeight - (this.titleInsets[0] + this.titleInsets[1]);
            if (usableHeight > 0.0 && usableWidth > 0.0) {
                if (this.isContinuous()) {
                    this.renderContinuous();
                } else {
                    this.renderDiscrete();
                }
            }
        }
        finally {
            this.channel.glPopAttrib();
        }
    }

    private void renderContinuous() throws MissingValueException {
        int i;
        double ilp;
        double iip;
        Vec3d delta = new Vec3d();
        Vec3d labelPosition = new Vec3d();
        Vec3d itemPosition = new Vec3d();
        double geometryHeight = 0.0;
        double geometryWidth = 0.0;
        double firstLabelPosition = 0.0;
        double lastLabelPosition = 0.0;
        TextStyle labelStyle = new TextStyle(this.style.getLabelStyle());
        Color edgeColor = this.style.getLabelStyle().getColor();
        double usableWidth = this.tmpWidth - (this.titleInsets[2] + this.titleInsets[3]);
        double usableHeight = this.tmpHeight - (this.titleInsets[0] + this.titleInsets[1]);
        delta.x = 0.0;
        delta.y = 0.0;
        delta.z = 0.0;
        labelPosition.z = 0.0;
        itemPosition.z = 0.0;
        labelStyle.setHorizontalJustification(0);
        labelStyle.setVerticalJustification(1);
        this.setLabelStyle(labelStyle);
        geometryHeight = geometryWidth = this.channel.glGetTextDescent() + this.channel.glGetTextAscent();
        if (this.isLayoutByRow()) {
            itemPosition.x = 0.0;
            geometryWidth = delta.x = (usableWidth -= this.labelLength[0] + this.labelLength[1] + this.labelMargin * 2.0) / (double)this.rangeCount;
            itemPosition.y = labelPosition.y = this.titleInsets[1] + usableHeight / 2.0;
            firstLabelPosition = this.titleInsets[2];
            itemPosition.x += firstLabelPosition + this.labelLength[0] + this.labelMargin + geometryWidth / 2.0;
            lastLabelPosition = firstLabelPosition + this.labelLength[0] + this.labelMargin + (double)this.rangeCount * geometryWidth + this.labelMargin;
        } else {
            geometryHeight = delta.y = usableHeight / (double)this.rangeCount;
            itemPosition.y = geometryHeight / 2.0 + this.titleInsets[1];
            double labelWidth = geometryWidth + this.labelMargin + this.maxLabelLength;
            itemPosition.x = this.titleInsets[2] + (usableWidth - labelWidth - this.labelMargin) / 2.0 + geometryWidth / 2.0;
            labelPosition.x = itemPosition.x + geometryWidth / 2.0 + this.labelMargin;
            labelPosition.y = itemPosition.y;
            firstLabelPosition = lastLabelPosition = labelPosition.x;
        }
        if (this.isLayoutByRow()) {
            iip = itemPosition.x;
            ilp = labelPosition.x;
        } else {
            iip = itemPosition.y;
            ilp = labelPosition.y;
        }
        boolean count = false;
        double xmin = itemPosition.x;
        double ymin = itemPosition.y;
        for (i = 0; i < this.rangeCount; ++i) {
            this.channel.glLoadName(new Integer(i));
            this.drawItem(itemPosition.x, itemPosition.y, geometryWidth, geometryHeight, this.colors.getValue(i), this.colors.getValue(i + 1));
            itemPosition.add(delta);
        }
        for (i = 0; i < this.labelCount; ++i) {
            this.channel.glLoadName(new Integer(i));
            if (!this.style.isLabelsOn()) continue;
            double currentLabelXPosition = 0.0;
            double currentLabelYPosition = 0.0;
            if (this.isLayoutByRow()) {
                currentLabelYPosition = labelPosition.y - geometryHeight;
                if (i == 0) {
                    currentLabelXPosition = firstLabelPosition;
                    if (this.rangeCount == 1 || this.endLabelsOnly) {
                        currentLabelYPosition += this.labelHeight[0] / 2.0 + geometryHeight / 2.0;
                    }
                } else if (i == this.labelCount - 1) {
                    currentLabelXPosition = lastLabelPosition;
                    if (this.rangeCount == 1 || this.endLabelsOnly) {
                        currentLabelYPosition += this.labelHeight[i] / 2.0 + geometryHeight / 2.0;
                    }
                } else if (!this.endLabelsOnly) {
                    currentLabelXPosition = labelPosition.x + this.labelLength[i] / 2.0;
                    if (this.rangeCount == 1 || this.endLabelsOnly) {
                        currentLabelYPosition -= geometryHeight;
                    }
                }
            } else if (i == 0) {
                currentLabelXPosition = firstLabelPosition;
                currentLabelYPosition = labelPosition.y + this.labelHeight[0] / 2.0 - geometryHeight / 2.0;
            } else if (i == this.labelCount - 1) {
                currentLabelXPosition = labelPosition.x;
                currentLabelYPosition = labelPosition.y - geometryHeight / 2.0 - this.labelHeight[i] / 2.0;
            } else if (!this.endLabelsOnly) {
                currentLabelXPosition = labelPosition.x;
                currentLabelYPosition = labelPosition.y - geometryHeight / 2.0;
            }
            if (i == 0 || i == this.labelCount - 1 || !this.endLabelsOnly) {
                this.drawLabel(this.labelArray[i], currentLabelXPosition, currentLabelYPosition, labelStyle, i);
            }
            labelPosition.add(delta);
        }
        if (edgeColor != null) {
            xmin -= geometryWidth / 2.0;
            ymin -= geometryHeight / 2.0;
            itemPosition.subtract(delta);
            double xmax = itemPosition.x + geometryWidth / 2.0;
            double ymax = itemPosition.y + geometryHeight / 2.0;
            this.channel.glColor(edgeColor);
            this.channel.glBegin(1);
            this.channel.glVertex(xmin, ymin);
            this.channel.glVertex(xmax, ymin);
            this.channel.glVertex(xmax, ymax);
            this.channel.glVertex(xmin, ymax);
            this.channel.glVertex(xmin, ymin);
            this.channel.glEnd();
        }
    }

    private void renderDiscrete() throws MissingValueException {
        double ilp;
        double iip;
        Vec3d delta = new Vec3d();
        Vec3d labelPosition = new Vec3d();
        Vec3d itemPosition = new Vec3d();
        double geometryHeight = 0.0;
        double geometryWidth = 0.0;
        double firstLabelPosition = 0.0;
        double lastLabelPosition = 0.0;
        TextStyle labelStyle = new TextStyle(this.style.getLabelStyle());
        Color edgeColor = this.style.getLabelStyle().getColor();
        double usableWidth = this.tmpWidth - (this.titleInsets[2] + this.titleInsets[3]);
        double usableHeight = this.tmpHeight - (this.titleInsets[0] + this.titleInsets[1]);
        delta.x = 0.0;
        delta.y = 0.0;
        delta.z = 0.0;
        labelPosition.z = 0.0;
        itemPosition.z = 0.0;
        labelStyle.setHorizontalJustification(0);
        labelStyle.setVerticalJustification(1);
        this.setLabelStyle(labelStyle);
        geometryHeight = geometryWidth = this.channel.glGetTextDescent() + this.channel.glGetTextAscent();
        double maxRowLabelLength = 0.0;
        for (int i = 0; i < this.numOfColumns; ++i) {
            maxRowLabelLength += this.maxColumnLabelLength[i];
        }
        double labelsWidth = maxRowLabelLength + (double)this.numOfColumns * (geometryWidth + this.labelMargin);
        itemPosition.x = usableWidth - labelsWidth;
        itemPosition.y = usableHeight - (double)this.numOfRows * (this.maxLabelHeight + (this.numOfRows == 1 ? 0.0 : this.labelMargin));
        itemPosition.x = itemPosition.x < 0.0 ? 0.0 : (itemPosition.x /= (double)(this.numOfColumns + 1));
        itemPosition.y = itemPosition.y < 0.0 ? 0.0 : (itemPosition.y /= (double)(this.numOfRows + 1));
        delta.x = itemPosition.x;
        delta.y = -1.0 * (itemPosition.y + geometryHeight + this.labelMargin);
        itemPosition.x += this.titleInsets[2] + geometryWidth / 2.0;
        itemPosition.y = this.tmpHeight - this.titleInsets[0] - geometryHeight / 2.0 - itemPosition.y;
        labelPosition.x = itemPosition.x + geometryWidth / 2.0 + this.labelMargin;
        labelPosition.y = itemPosition.y;
        if (this.isLayoutByRow()) {
            iip = itemPosition.x;
            ilp = labelPosition.x;
        } else {
            iip = itemPosition.y;
            ilp = labelPosition.y;
        }
        int count = 0;
        double xmin = itemPosition.x;
        double ymin = itemPosition.y;
        for (int i = 0; i < this.labelCount; ++i) {
            this.channel.glLoadName(new Integer(i));
            this.drawItem(itemPosition.x, itemPosition.y, geometryWidth, geometryHeight, this.colors.getValue(i), edgeColor, this.markerTypes.getValue(i));
            if (!this.style.isLabelsOn()) continue;
            this.drawLabel(this.labelArray[i], labelPosition.x, labelPosition.y, labelStyle, i);
            if (this.isLayoutByRow()) {
                if ((i + 1) % this.numOfColumns == 0) {
                    itemPosition.x = iip;
                    itemPosition.y += delta.y;
                    labelPosition.x = ilp;
                    labelPosition.y += delta.y;
                    continue;
                }
                itemPosition.x += delta.x + geometryWidth + this.labelMargin + this.maxColumnLabelLength[i % this.numOfColumns];
                labelPosition.x += delta.x + geometryWidth + this.labelMargin + this.maxColumnLabelLength[i % this.numOfColumns];
                continue;
            }
            if ((i + 1) % this.numOfRows == 0) {
                itemPosition.x += delta.x + geometryWidth + this.labelMargin + this.maxColumnLabelLength[count];
                itemPosition.y = iip;
                labelPosition.x += delta.x + geometryWidth + this.labelMargin + this.maxColumnLabelLength[count];
                labelPosition.y = ilp;
                ++count;
                continue;
            }
            itemPosition.y += delta.y;
            labelPosition.y += delta.y;
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        BoundingBox box = bBoxAction.getElementBoundingBox();
        this.channel = (Channel)bBoxAction.getGraphicsContext();
        Vec3d pSize = this.getPreferredSize(this.channel, bBoxAction.getValueIndex(), false);
        size.set(pSize.x, pSize.y, 0.0);
        center.set(pSize.x / 2.0, pSize.y / 2.0, 0.0);
        box.union(center, size);
    }

    public Vec3d getPreferredSize(Channel channel, int index) {
        return this.getPreferredSize(channel, index, true);
    }

    protected Vec3d getPreferredSize(Channel channel, int index, boolean initLegend) {
        if (initLegend) {
            new InitAction(channel).apply(this);
        }
        if (this.style.isTitleOn()) {
            String titleStr;
            try {
                titleStr = this.title.getValue(index);
            }
            catch (MissingValueException mve) {
                titleStr = new String();
            }
            Vec3d p = this.addTitleDimensions(channel, titleStr, this.tmpWidth, this.tmpHeight, this.style);
            if (this.style.isBorderOn()) {
                Vec3d bp = this.addBorderDimensions(p.x, p.y, this.style);
                p.x = bp.x;
                p.y = bp.y;
            }
            return p;
        }
        if (this.style.isBorderOn()) {
            Vec3d p = this.addBorderDimensions(this.tmpWidth, this.tmpHeight, this.style);
            return p;
        }
        Vec3d p = new Vec3d(this.tmpWidth, this.tmpHeight, 0.0);
        if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
            double w = this.getWidth();
            double h = this.getHeight();
            if (w > p.x) {
                p.x = w;
            }
            if (h > p.y) {
                p.y = h;
            }
        }
        return p;
    }

    Vec3d addBorderDimensions(double width, double height, LegendStyle legendStyle) {
        if (legendStyle.isBorderOn() && legendStyle.getBorderStyle() != 0) {
            double borderOffset = legendStyle.getBorderOffset();
            width += borderOffset;
            height += borderOffset;
        }
        return new Vec3d(width, height, 0.0);
    }

    Vec3d addTitleDimensions(Channel channel, String title, double width, double height, LegendStyle legendStyle) {
        if (legendStyle.isTitleOn()) {
            TextStyle titleStyle = legendStyle.getTitleStyle();
            channel.glSelect2DFont(titleStyle.getFont());
            double titleHeight = channel.glGetTextHeight(title);
            double titleWidth = channel.glGetTextWidth(title);
            double minTitleWidth = 0.0;
            double minTitleHeight = 0.0;
            int position = this.style.getTitlePosition();
            int hj = titleStyle.getHorizontalJustification();
            double titleOffset = titleHeight;
            switch (position) {
                case 0: 
                case 1: {
                    minTitleWidth = titleWidth + 4.0 * this.titleMargin;
                    minTitleHeight = titleHeight + 2.0 * this.labelMargin;
                    height += 2.0 * this.labelMargin + titleOffset;
                    break;
                }
                case 2: {
                    if (hj == 0 || hj == 2) {
                        minTitleWidth = titleHeight + 2.0 * this.labelMargin;
                        minTitleHeight = titleWidth + 4.0 * this.titleMargin;
                        width += 2.0 * this.labelMargin + titleOffset;
                        break;
                    }
                    minTitleWidth = titleWidth + 4.0 * this.titleMargin;
                    minTitleHeight = titleHeight + 2.0 * this.labelMargin;
                    height += 2.0 * this.labelMargin + titleOffset;
                }
            }
            height = Math.max(height, minTitleHeight);
            width = Math.max(width, minTitleWidth);
        }
        return new Vec3d(width, height, 0.0);
    }

    @Override
    protected void setLabelStyle(TextStyle labelStyle) {
        this.channel.glSelect2DFont(labelStyle.getFont());
        this.channel.glAlignment(labelStyle.getHorizontalJustification(), labelStyle.getVerticalJustification());
    }

    @Override
    protected void drawLabel(String label, double x, double y, TextStyle labelStyle, int index) {
        this.channel.glColor(labelStyle.getColor());
        this.channel.gl2DText(label, x, y, 0.0);
    }

    @Override
    protected void drawItem(double centerX, double centerY, double sizeX, double sizeY, Color startColor, Color endColor) {
        this.channel.glPolygonMode(3);
        this.channel.glNormal(0.0, 0.0, 1.0);
        this.channel.glBegin(2);
        this.channel.glColor(startColor);
        if (this.isLayoutByRow()) {
            this.channel.glVertex(centerX - sizeX / 2.0, centerY - sizeY / 2.0);
            this.channel.glVertex(centerX - sizeX / 2.0, centerY + sizeY / 2.0);
            this.channel.glColor(endColor);
            this.channel.glVertex(centerX + sizeX / 2.0, centerY + sizeY / 2.0);
            this.channel.glVertex(centerX + sizeX / 2.0, centerY - sizeY / 2.0);
        } else {
            this.channel.glVertex(centerX - sizeX / 2.0, centerY - sizeY / 2.0);
            this.channel.glVertex(centerX + sizeX / 2.0, centerY - sizeY / 2.0);
            this.channel.glColor(endColor);
            this.channel.glVertex(centerX + sizeX / 2.0, centerY + sizeY / 2.0);
            this.channel.glVertex(centerX - sizeX / 2.0, centerY + sizeY / 2.0);
        }
        this.channel.glEnd();
    }

    @Override
    protected void drawItem(double centerX, double centerY, double sizeX, double sizeY, Color color, Color edgeColor, int markerType) {
        this.channel.glColor(color);
        if (markerType != -1) {
            this.channel.setMarkerType(markerType);
            this.channel.setMarkerSize((int)(sizeX / this.pixelWidth));
            this.channel.glEdgeColor(Color.black);
            this.channel.glBegin(4);
            this.channel.glVertex(centerX, centerY);
            this.channel.glEnd();
        } else {
            if (edgeColor != null && !this.isContinuous()) {
                this.channel.glPolygonMode(4);
                this.channel.glEdgeColor(edgeColor);
            } else {
                this.channel.glPolygonMode(3);
            }
            this.channel.glNormal(0.0, 0.0, 1.0);
            this.channel.glBegin(2);
            this.channel.glVertex(centerX - sizeX / 2.0, centerY - sizeY / 2.0);
            this.channel.glVertex(centerX + sizeX / 2.0, centerY - sizeY / 2.0);
            this.channel.glVertex(centerX + sizeX / 2.0, centerY + sizeY / 2.0);
            this.channel.glVertex(centerX - sizeX / 2.0, centerY + sizeY / 2.0);
            this.channel.glEnd();
        }
    }

    protected double[] drawTitleBorder(Channel channel, double sizeX, double sizeY, String title, Color borderClr, Color borderLineClr, LegendStyle legendStyle) {
        double titleWidth = 0.0;
        double titleHeight = 0.0;
        String nTitle = title;
        double[] inset = new double[4];
        double[] borderInsets = new double[4];
        inset[3] = 0.0;
        inset[2] = 0.0;
        inset[1] = 0.0;
        inset[0] = 0.0;
        borderInsets[3] = 0.0;
        borderInsets[2] = 0.0;
        borderInsets[1] = 0.0;
        borderInsets[0] = 0.0;
        boolean titleOn = this.style.isTitleOn();
        boolean borderOn = this.style.isBorderOn();
        int position = this.style.getTitlePosition();
        TextStyle titleStyle = legendStyle.getTitleStyle();
        if (borderOn && legendStyle.getBorderStyle() != 0) {
            double offset = legendStyle.getBorderOffset();
            switch (legendStyle.getBorderVerticalJustification()) {
                default: {
                    inset[1] = offset;
                    borderInsets[1] = offset;
                    break;
                }
                case 0: {
                    inset[0] = offset;
                    borderInsets[0] = offset;
                }
            }
            switch (legendStyle.getBorderHorizontalJustification()) {
                default: {
                    inset[2] = offset;
                    borderInsets[2] = offset;
                    break;
                }
                case 2: {
                    inset[3] = offset;
                    borderInsets[3] = offset;
                }
            }
        }
        if (titleOn && title.length() > 0) {
            Font font = titleStyle.getFont();
            channel.glSelect2DFont(font);
            titleHeight = channel.glGetTextHeight(nTitle);
            titleWidth = channel.glGetTextWidth(nTitle);
            int angle = 0;
            double px = 0.0;
            double py = 0.0;
            double titleOffset = 0.0;
            int hj = titleStyle.getHorizontalJustification();
            int vj = titleStyle.getVerticalJustification();
            boolean closedBorder = false;
            switch (vj) {
                case 0: {
                    titleOffset = titleHeight;
                    closedBorder = true;
                    break;
                }
                default: {
                    titleOffset = titleHeight / 2.0;
                    break;
                }
                case 3: {
                    titleOffset = 0.0;
                    closedBorder = true;
                }
            }
            int thj = 1;
            int tvj = 1;
            switch (position) {
                case 0: {
                    tvj = 0;
                    inset[0] = inset[0] + titleHeight;
                    py = sizeY - borderInsets[0];
                    borderInsets[0] = borderInsets[0] + titleOffset;
                    break;
                }
                case 1: {
                    tvj = 3;
                    inset[1] = inset[1] + titleHeight;
                    py = borderInsets[1];
                    borderInsets[1] = borderInsets[1] + titleOffset;
                    break;
                }
                case 2: {
                    py = (sizeY - (borderInsets[1] + borderInsets[0])) / 2.0;
                    if (hj == 0) {
                        inset[2] = inset[2] + titleHeight;
                        angle = 90;
                        break;
                    }
                    if (hj == 2) {
                        inset[3] = inset[3] + titleHeight;
                        angle = 270;
                        break;
                    }
                    tvj = 0;
                    inset[0] = inset[0] + titleHeight;
                    py = sizeY - borderInsets[0];
                    borderInsets[0] = borderInsets[0] + titleOffset;
                }
            }
            switch (hj) {
                case 0: {
                    if (position != 2) {
                        px = borderInsets[2] + this.titleMargin * 2.0 + titleWidth / 2.0;
                        break;
                    }
                    thj = 0;
                    px = borderInsets[2];
                    borderInsets[2] = borderInsets[2] + titleOffset;
                    break;
                }
                case 2: {
                    if (position != 2) {
                        px = sizeX - (borderInsets[3] + this.titleMargin * 2.0 + titleWidth / 2.0);
                        break;
                    }
                    thj = 2;
                    px = sizeX - borderInsets[3];
                    borderInsets[3] = borderInsets[3] + titleOffset;
                    break;
                }
                default: {
                    px = sizeX / 2.0 + (borderInsets[2] - borderInsets[3]) / 2.0;
                }
            }
            if (borderOn) {
                switch (legendStyle.getBorderStyle()) {
                    case 1: {
                        this.drawBlock(channel, borderInsets, legendStyle.getBorderOffset(), sizeX, sizeY, borderClr, borderLineClr, legendStyle);
                        break;
                    }
                    case 2: {
                        this.drawShadow(channel, borderInsets, legendStyle.getBorderOffset(), sizeX, sizeY, borderClr, legendStyle);
                    }
                }
                channel.glColor(borderLineClr);
                channel.glBegin(1);
                channel.glVertex(borderInsets[2], borderInsets[1]);
                if (position == 1 && !closedBorder) {
                    channel.glVertex(px - titleWidth / 2.0 - this.titleMargin, borderInsets[1]);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(px + titleWidth / 2.0 + this.titleMargin / 2.0, borderInsets[1]);
                }
                channel.glVertex(sizeX - borderInsets[3], borderInsets[1]);
                if (position == 2 && hj == 2 && !closedBorder) {
                    channel.glVertex(sizeX - borderInsets[3], py - titleWidth / 2.0 - this.titleMargin);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(sizeX - borderInsets[3], py + titleWidth / 2.0 + this.titleMargin);
                }
                channel.glVertex(sizeX - borderInsets[3], sizeY - borderInsets[0]);
                if ((position == 0 || position == 2 && hj != 0 && hj != 2) && !closedBorder) {
                    channel.glVertex(px + titleWidth / 2.0 + this.titleMargin / 2.0, sizeY - borderInsets[0]);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(px - titleWidth / 2.0 - this.titleMargin, sizeY - borderInsets[0]);
                }
                channel.glVertex(borderInsets[2], sizeY - borderInsets[0]);
                if (position == 2 && hj == 0 && !closedBorder) {
                    channel.glVertex(borderInsets[2], py + titleWidth / 2.0 + this.titleMargin);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(borderInsets[2], py - titleWidth / 2.0 - this.titleMargin);
                }
                channel.glVertex(borderInsets[2], borderInsets[1]);
                channel.glEnd();
            }
            channel.glColor(titleStyle.getColor());
            channel.glTextAlign(thj, tvj);
            channel.gl2DText(nTitle, px, py, 0.0, angle);
        } else if (borderOn) {
            switch (legendStyle.getBorderStyle()) {
                case 1: {
                    this.drawBlock(channel, borderInsets, legendStyle.getBorderOffset(), sizeX, sizeY, borderClr, borderLineClr, legendStyle);
                    break;
                }
                case 2: {
                    this.drawShadow(channel, borderInsets, legendStyle.getBorderOffset(), sizeX, sizeY, borderClr, legendStyle);
                }
            }
            channel.glColor(borderLineClr);
            channel.glBegin(1);
            channel.glVertex(borderInsets[2], borderInsets[1]);
            channel.glVertex(sizeX - borderInsets[3], borderInsets[1]);
            channel.glVertex(sizeX - borderInsets[3], sizeY - borderInsets[0]);
            channel.glVertex(borderInsets[2], sizeY - borderInsets[0]);
            channel.glVertex(borderInsets[2], borderInsets[1]);
            channel.glEnd();
        }
        return inset;
    }

    double[] getTitleBorderInsets(Channel channel, String title, LegendStyle legendStyle) {
        double titleHeight = 0.0;
        String nTitle = title;
        double[] inset = new double[4];
        inset[3] = 0.0;
        inset[2] = 0.0;
        inset[1] = 0.0;
        inset[0] = 0.0;
        boolean titleOn = this.style.isTitleOn();
        boolean borderOn = this.style.isBorderOn();
        int position = this.style.getTitlePosition();
        TextStyle titleStyle = legendStyle.getTitleStyle();
        if (borderOn && legendStyle.getBorderStyle() != 0) {
            double offset = legendStyle.getBorderOffset();
            switch (legendStyle.getBorderVerticalJustification()) {
                default: {
                    inset[1] = offset;
                    break;
                }
                case 0: {
                    inset[0] = offset;
                }
            }
            switch (legendStyle.getBorderHorizontalJustification()) {
                default: {
                    inset[2] = offset;
                    break;
                }
                case 2: {
                    inset[3] = offset;
                }
            }
        }
        if (titleOn && title.length() > 0) {
            Font font = titleStyle.getFont();
            channel.glSelect2DFont(font);
            titleHeight = channel.glGetTextHeight(nTitle);
            int hj = titleStyle.getHorizontalJustification();
            switch (position) {
                case 0: {
                    inset[0] = inset[0] + titleHeight;
                    break;
                }
                case 1: {
                    inset[1] = inset[1] + titleHeight;
                    break;
                }
                case 2: {
                    if (hj == 0) {
                        inset[2] = inset[2] + titleHeight;
                        break;
                    }
                    if (hj == 2) {
                        inset[3] = inset[3] + titleHeight;
                        break;
                    }
                    inset[0] = inset[0] + titleHeight;
                }
            }
        }
        return inset;
    }

    private void drawBlock(Channel channel, double[] insets, double offset, double sizeX, double sizeY, Color borderClr, Color edgeClr, LegendStyle legendStyle) {
        int vj = legendStyle.getBorderVerticalJustification();
        int hj = legendStyle.getBorderHorizontalJustification();
        channel.glPushAttrib(0);
        channel.glPolygonMode(4);
        channel.glColor(borderClr);
        channel.glEdgeColor(edgeClr);
        block0 : switch (vj) {
            default: {
                switch (hj) {
                    default: {
                        channel.glBegin(2);
                        channel.glVertex(insets[2] - offset, insets[1] - offset);
                        channel.glVertex(sizeX - insets[3] - offset, insets[1] - offset);
                        channel.glVertex(sizeX - insets[3], insets[1]);
                        channel.glVertex(insets[2] - offset, insets[1]);
                        channel.glEnd();
                        channel.glBegin(2);
                        channel.glVertex(insets[2], insets[1]);
                        channel.glVertex(insets[2], sizeY - insets[0]);
                        channel.glVertex(insets[2] - offset, sizeY - insets[0] - offset);
                        channel.glVertex(insets[2] - offset, insets[1] - offset);
                        channel.glEnd();
                        break block0;
                    }
                    case 2: 
                }
                channel.glBegin(2);
                channel.glVertex(insets[2], insets[1]);
                channel.glVertex(insets[2] + offset, insets[1] - offset);
                channel.glVertex(sizeX - insets[3] + offset, insets[1] - offset);
                channel.glVertex(sizeX - insets[3], insets[1]);
                channel.glEnd();
                channel.glBegin(2);
                channel.glVertex(sizeX - insets[3], insets[1]);
                channel.glVertex(sizeX - insets[3] + offset, insets[1] - offset);
                channel.glVertex(sizeX - insets[3] + offset, sizeY - insets[0] - offset);
                channel.glVertex(sizeX - insets[3], sizeY - insets[0]);
                channel.glEnd();
                break;
            }
            case 0: {
                switch (hj) {
                    default: {
                        channel.glBegin(2);
                        channel.glVertex(insets[2], sizeY - insets[0]);
                        channel.glVertex(sizeX - insets[3], sizeY - insets[0]);
                        channel.glVertex(sizeX - insets[3] - offset, sizeY - insets[0] + offset);
                        channel.glVertex(insets[2] - offset, sizeY - insets[0] + offset);
                        channel.glEnd();
                        channel.glBegin(2);
                        channel.glVertex(insets[2] - offset, sizeY - insets[0] + offset);
                        channel.glVertex(insets[2] - offset, insets[1] + offset);
                        channel.glVertex(insets[2], insets[1]);
                        channel.glVertex(insets[2], sizeY - insets[0]);
                        channel.glEnd();
                        break block0;
                    }
                    case 2: 
                }
                channel.glBegin(2);
                channel.glVertex(sizeX - insets[3], sizeY - insets[0]);
                channel.glVertex(sizeX - insets[3], insets[1]);
                channel.glVertex(sizeX - insets[3] + offset, insets[1] + offset);
                channel.glVertex(sizeX - insets[3] + offset, sizeY - insets[0] + offset);
                channel.glEnd();
                channel.glBegin(2);
                channel.glVertex(sizeX - insets[3] + offset, sizeY - insets[0] + offset);
                channel.glVertex(insets[2] + offset, sizeY - insets[0] + offset);
                channel.glVertex(insets[2], sizeY - insets[0]);
                channel.glVertex(sizeX - insets[3], sizeY - insets[0]);
                channel.glEnd();
            }
        }
        channel.glPopAttrib();
    }

    private void drawShadow(Channel channel, double[] insets, double offset, double sizeX, double sizeY, Color color, LegendStyle legendStyle) {
        int vj = legendStyle.getBorderVerticalJustification();
        int hj = legendStyle.getBorderHorizontalJustification();
        channel.glColor(color);
        block0 : switch (vj) {
            default: {
                switch (hj) {
                    default: {
                        channel.glBegin(2);
                        channel.glVertex(insets[2] - offset, insets[1] - offset);
                        channel.glVertex(sizeX - insets[3] - offset, insets[1] - offset);
                        channel.glVertex(sizeX - insets[3] - offset, insets[1]);
                        channel.glVertex(insets[2], insets[1]);
                        channel.glVertex(insets[2], sizeY - insets[0] - offset);
                        channel.glVertex(insets[2] - offset, sizeY - insets[0] - offset);
                        channel.glEnd();
                        break block0;
                    }
                    case 2: 
                }
                channel.glBegin(2);
                channel.glVertex(insets[2] + offset, insets[1]);
                channel.glVertex(insets[2] + offset, insets[1] - offset);
                channel.glVertex(sizeX - insets[3] + offset, insets[1] - offset);
                channel.glVertex(sizeX - insets[3] + offset, sizeY - insets[0] - offset);
                channel.glVertex(sizeX - insets[3], sizeY - insets[0] - offset);
                channel.glVertex(sizeX - insets[3], insets[1]);
                channel.glEnd();
                break;
            }
            case 0: {
                switch (hj) {
                    default: {
                        channel.glBegin(2);
                        channel.glVertex(insets[2], sizeY - insets[0]);
                        channel.glVertex(sizeX - insets[3] - offset, sizeY - insets[0]);
                        channel.glVertex(sizeX - insets[3] - offset, sizeY - insets[0] + offset);
                        channel.glVertex(insets[2] - offset, sizeY - insets[0] + offset);
                        channel.glVertex(insets[2] - offset, insets[1] + offset);
                        channel.glVertex(insets[2], insets[1] + offset);
                        channel.glEnd();
                        break block0;
                    }
                    case 2: 
                }
                channel.glBegin(2);
                channel.glVertex(sizeX - insets[3], sizeY - insets[0]);
                channel.glVertex(sizeX - insets[3], insets[1] + offset);
                channel.glVertex(sizeX - insets[3] + offset, insets[1] + offset);
                channel.glVertex(sizeX - insets[3] + offset, sizeY - insets[0] + offset);
                channel.glVertex(insets[2] + offset, sizeY - insets[0] + offset);
                channel.glVertex(insets[2] + offset, sizeY - insets[0]);
                channel.glEnd();
            }
        }
    }

    @Override
    protected void drawBackground(double sizeX, double sizeY, Color backgroundColor) {
        this.channel.glColor(backgroundColor);
        this.channel.glBegin(2);
        this.channel.glVertex(0.0, 0.0, 0.0);
        this.channel.glVertex(sizeX, 0.0, 0.0);
        this.channel.glVertex(sizeX, sizeY, 0.0);
        this.channel.glVertex(0.0, sizeY, 0.0);
        this.channel.glVertex(0.0, 0.0, 0.0);
        this.channel.glEnd();
    }

    @Override
    protected SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        Integer labelIndex = (Integer)nameStack.elementAt(startIndex + entryLength - 1);
        if (labelIndex == null || labelIndex < 0) {
            return null;
        }
        LegendDetail legendDetail = new LegendDetail();
        legendDetail.setLabelIndex(labelIndex);
        return legendDetail;
    }

    public int getLabelCount() {
        InitAction ia = new InitAction(this.channel);
        this.labels.init(ia);
        return ia.getValueCount();
    }

    public void setEndLabelsOnly(boolean b) {
        this.endLabelsOnly = b;
    }

    public boolean isEndLabelsOnly() {
        return this.endLabelsOnly;
    }
}

