/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.jxd.Legend;
import com.sas.graphics.util.vtk.jxd.NetworkRoot;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;

public class JLegend
extends JComponent {
    private NetworkRoot networkRoot;
    private Channel channel = new Channel(this, 2);
    private Legend legend;

    public JLegend() {
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.channel.glDisable(1);
        this.channel.glDisable(5);
        this.channel.setBackbuffer(-1);
        this.networkRoot = new NetworkRoot(this.channel);
        this.setSize(10, 10);
    }

    public void setLegend(Legend legend) {
        if (legend != null) {
            this.legend = legend;
            this.networkRoot.removeAllElements();
            this.networkRoot.addElement(legend);
        }
    }

    public Legend getLegend() {
        return this.legend;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.channel.glViewport(width, height, this.getInsets());
        this.channel.glOrtho(0.0, width, 0.0, height, 1000.0, -1000.0);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.channel.setSingleBufferGraphics(g);
        if (this.legend != null) {
            Insets insets = this.getInsets();
            this.legend.setWidth(this.getSize().width - insets.left - insets.right - 1);
            this.legend.setHeight(this.getSize().height - insets.top - insets.bottom - 1);
            this.legend.transform.translateX.setValue(insets.left);
            this.legend.transform.translateY.setValue(insets.bottom + 1);
        }
        this.networkRoot.draw();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension();
        if (this.networkRoot != null && this.legend != null) {
            this.legend.setWidth(-1.0);
            this.legend.setHeight(-1.0);
            BoundingBox bbox = this.networkRoot.computeBoundingBox();
            Vec3d bboxSize = bbox.getSize();
            preferredSize.width = (int)Math.round(bboxSize.x);
            preferredSize.height = (int)Math.round(bboxSize.y);
        }
        return preferredSize;
    }
}

