/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.ACylinder;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class Cylinder
extends ACylinder {
    public static void drawCylinder(Channel channel, double radius, double height, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, boolean sideVisible, boolean topVisible, boolean bottomVisible, int origin, int precision, boolean sideEdgesVisible) {
        int i;
        if (x == null || z == null || precision != lastPrecision) {
            lastPrecision = precision;
            Cylinder.calculatePoints(lastPrecision);
        }
        double thgt = height / 2.0;
        double bhgt = -1.0 * thgt;
        Vec3d center = new Vec3d();
        ACylinder.computeCenter(radius, height, origin, center);
        channel.glTranslate(center.x, center.y, center.z);
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getJXDFillStyle(fillOn, edgeOn));
        channel.glBegin(2);
        if (topVisible) {
            channel.glNormal(0.0, 1.0, 0.0);
            for (int i2 = 0; i2 < x.length; ++i2) {
                channel.glVertex(x[i2] * radius, thgt, z[i2] * radius);
            }
            channel.glBound();
        }
        Vec3d v = new Vec3d();
        Vec3d w = new Vec3d();
        if (sideVisible) {
            for (i = 0; i < x.length - 1; ++i) {
                v.set(0.0, height, 0.0);
                w.set(x[i] * radius - x[i + 1] * radius, 0.0, z[i] * radius - z[i + 1] * radius);
                Vec3d crossVW = height >= 0.0 ? v.cross(w) : w.cross(v);
                channel.glNormal(crossVW.x, crossVW.y, crossVW.z);
                if (!sideEdgesVisible) {
                    channel.glEdgeFlag(true);
                }
                channel.glVertex(x[i] * radius, bhgt, z[i] * radius);
                if (!sideEdgesVisible) {
                    channel.glEdgeFlag(false);
                }
                channel.glVertex(x[i + 1] * radius, bhgt, z[i + 1] * radius);
                if (!sideEdgesVisible) {
                    channel.glEdgeFlag(true);
                }
                channel.glVertex(x[i + 1] * radius, thgt, z[i + 1] * radius);
                if (!sideEdgesVisible) {
                    channel.glEdgeFlag(false);
                }
                channel.glVertex(x[i] * radius, thgt, z[i] * radius);
                if (!sideEdgesVisible) {
                    channel.glEdgeFlag(true);
                }
                channel.glBound();
            }
        }
        if (bottomVisible) {
            channel.glNormal(0.0, -1.0, 0.0);
            for (i = x.length - 1; i >= 0; --i) {
                channel.glVertex(x[i] * radius, bhgt, z[i] * radius);
            }
            channel.glBound();
        }
        channel.glEnd();
        channel.glPopAttrib();
    }

    public Cylinder() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Cylinder.drawCylinder(ba.getChannel(), this.radius.getValue(index), this.height.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), this.edgeOn.getValue(index), this.fillOn.getValue(index), this.sideVisible.getValue(index), this.topVisible.getValue(index), this.bottomVisible.getValue(index), this.origin.getValue(index), this.precision.getValue(index), this.sideEdgesVisible.getValue(index));
    }
}

