/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.ACone;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class Cone
extends ACone {
    public static void drawCone(Channel channel, double radius, double height, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, boolean sideVisible, boolean bottomVisible, int origin, int precision) {
        int i;
        if (x == null || z == null || precision != lastPrecision) {
            lastPrecision = precision;
            Cone.calculatePoints(lastPrecision);
        }
        double thgt = height / 2.0;
        double bhgt = -1.0 * thgt;
        Vec3d center = new Vec3d();
        ACone.computeCenter(radius, height, origin, center);
        channel.glTranslate(center.x, center.y, center.z);
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getJXDFillStyle(fillOn, edgeOn));
        Vec3d v = new Vec3d();
        Vec3d w = new Vec3d();
        channel.glBegin(2);
        if (sideVisible) {
            for (i = x.length - 1; i > 0; --i) {
                v.set(-x[i] * radius, thgt - bhgt, -z[i] * radius);
                w.set(x[i - 1] * radius - x[i] * radius, 0.0, z[i - 1] * radius - z[i] * radius);
                Vec3d crossVW = height >= 0.0 ? v.cross(w) : w.cross(v);
                channel.glNormal(crossVW.x, crossVW.y, crossVW.z);
                channel.glVertex(x[i] * radius, bhgt, z[i] * radius);
                channel.glVertex(0.0, thgt, 0.0);
                channel.glVertex(x[i - 1] * radius, bhgt, z[i - 1] * radius);
                channel.glBound();
            }
        }
        if (bottomVisible) {
            channel.glNormal(0.0, bhgt - thgt, 0.0);
            for (i = 0; i < x.length; ++i) {
                channel.glVertex(x[i] * radius, bhgt, z[i] * radius);
            }
        }
        channel.glEnd();
        channel.glPopAttrib();
    }

    public Cone() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Cone.drawCone(ba.getChannel(), this.bottomRadius.getValue(index), this.height.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), this.edgeOn.getValue(index), this.fillOn.getValue(index), this.sideVisible.getValue(index), this.bottomVisible.getValue(index), this.origin.getValue(index), this.precision.getValue(index));
    }
}

