/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.SelectEntry;
import com.sas.graphics.util.vtk.jxd.ResetAction;

public class BuildAction
extends ABuildAction {
    private boolean displayListCreate = true;
    private long displayListName;

    public BuildAction(Channel aChannel) {
        super(new ResetAction(aChannel), aChannel);
        this.getResetAction().setCompanionAction(this);
    }

    public Channel getChannel() {
        return (Channel)this.getGraphicsContext();
    }

    @Override
    public void apply(Element element) {
        Channel channel = this.getChannel();
        channel.glFrontFace(0);
        channel.glDisable(0);
        super.apply(element);
    }

    public static BuildAction castBuildAction(ABuildAction anABuildAction) {
        return (BuildAction)anABuildAction;
    }

    public void setDisplayListCreate(boolean onOrOff) {
        this.displayListCreate = onOrOff;
    }

    public boolean isDisplayListCreationEnabled() {
        return this.displayListCreate;
    }

    public void setDisplayListName(long name) {
        this.displayListName = name;
    }

    public long getDisplayListName() {
        return this.displayListName;
    }

    @Override
    public void pushName(Element e) {
        BuildAction.pushName(this.getChannel(), this.getValueIndex(), e);
    }

    @Override
    public void popName(Element e) {
        BuildAction.popName(this.getChannel(), e);
    }

    public static void pushName(Channel channel, int valueIndex, Element e) {
        SelectEntry entry = e.buildSelectEntry(valueIndex);
        channel.glPushName(entry);
        if (BuildAction.canHaveSelectDetails(e)) {
            channel.glPushName(null);
        }
    }

    public static void popName(Channel channel, Element e) {
        channel.glPopName();
        if (BuildAction.canHaveSelectDetails(e)) {
            channel.glPopName();
        }
    }

    public static int getJXDFillStyle(boolean fillOn, boolean edgeOn) {
        int result = 5;
        if (fillOn) {
            result = edgeOn ? 4 : 3;
        } else if (edgeOn) {
            result = 2;
        }
        return result;
    }
}

