/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.AAxisSet;
import com.sas.graphics.util.vtk.ANetworkRoot;
import com.sas.graphics.util.vtk.NumericMapper;
import com.sas.graphics.util.vtk.jxd.Grid;
import com.sas.graphics.util.vtk.jxd.NetworkRoot;
import com.sas.graphics.util.vtk.jxd.PolarAxis;
import com.sas.graphics.util.vtk.jxd.RectangularAxis;

public class AxisSet
extends AAxisSet {
    private static double fov = 45.0;
    private static double fovBy2inRadians = fov / 2.0 / radians2degrees;
    private static final double defaultAzimuth = 30.0;
    private static final double defaultIncline = -0.1;

    public AxisSet(ANetworkRoot root) {
        this.networkRoot = root;
    }

    public RectangularAxis newXAxis(NumericMapper aMapper) {
        RectangularAxis axis = RectangularAxis.getXAxis(aMapper, this.size.x);
        this.newXAxis(axis, aMapper);
        return axis;
    }

    public RectangularAxis newYAxis(NumericMapper aMapper) {
        RectangularAxis axis = RectangularAxis.getYAxis(aMapper, this.size.y);
        this.newYAxis(axis, aMapper);
        return axis;
    }

    public RectangularAxis newZAxis(NumericMapper aMapper) {
        RectangularAxis axis = RectangularAxis.getZAxis(aMapper, this.size.z);
        this.newZAxis(axis, aMapper);
        return axis;
    }

    public PolarAxis newPolarAxis(int orientation, NumericMapper aMapper) {
        PolarAxis axis = new PolarAxis();
        axis.setOrientation(orientation);
        this.newPolar(axis, aMapper);
        return axis;
    }

    public Grid newFloorGrid(NumericMapper horizMap, NumericMapper vertMap) {
        Grid grid = new Grid();
        this.newFloorGrid(grid, horizMap, vertMap);
        return grid;
    }

    public Grid newSideGrid(NumericMapper horizMap, NumericMapper vertMap) {
        Grid grid = new Grid();
        this.newSideGrid(grid, horizMap, vertMap);
        return grid;
    }

    public Grid newBackGrid(NumericMapper horizMap, NumericMapper vertMap) {
        Grid grid = new Grid();
        this.newBackGrid(grid, horizMap, vertMap);
        return grid;
    }

    @Override
    public void setView(double azimuth, double incline, double distance) {
        super.setView(azimuth, incline, distance);
        if (this.bbox == null) {
            this.getView();
            return;
        }
        Channel channel = ((NetworkRoot)this.networkRoot).getChannel();
        if (channel != null) {
            double[] view = channel.glGetDoublev(0);
            double aspectRatio = view[3] / view[2];
            Vec3d center = this.bbox.getCenter();
            if (this.perspective) {
                if (aspectRatio > 1.0) {
                    aspectRatio = 1.0 / aspectRatio;
                }
                channel.gluPerspective(fov, 1.0 / aspectRatio, 0.1, 20.0);
                channel.gluLookAt(center.x, center.y, center.z, distance, azimuth, incline, 0.0);
            } else {
                this.networkRoot.setObliqueView(this.bbox, fov, azimuth, incline);
            }
        }
    }

    public double[] getView() {
        return this.getView(30.0, -0.1);
    }

    public double[] getView(double azimuth, double incline) {
        double[] defView = new double[]{azimuth, incline, this.getGreatestDimension()};
        super.setView(defView[0], defView[1], defView[2]);
        Channel channel = ((NetworkRoot)this.networkRoot).getChannel();
        if (channel != null) {
            double[] viewport = channel.glGetDoublev(0);
            if (this.perspective) {
                channel.gluPerspective(fov, viewport[2] / viewport[3], 0.1, 20.0);
                channel.gluLookAt(0.0, 0.0, 0.0, defView[2], defView[0], defView[1], 0.0);
                this.bbox = this.networkRoot.computeBoundingBox();
                Vec3d s = this.bbox.getSize();
                Vec3d c = this.bbox.getCenter();
                this.bbox.setSize(s.x * 2.0 - this.size.x, s.y, s.z);
                this.bbox.setCenter(c.x - (s.x - this.size.x) / 2.0, c.y, c.z);
                defView[2] = this.networkRoot.setPerspectiveView(this.bbox, fov, defView[0], defView[1]);
            } else {
                channel.gluPerspective(fov, viewport[2] / viewport[3], 0.1, 20.0);
                channel.gluLookAt(0.0, 0.0, 0.0, defView[2], defView[0], defView[1], 0.0);
                this.bbox = this.networkRoot.computeBoundingBox();
                defView[0] = 0.0;
                defView[2] = this.networkRoot.setObliqueView(this.bbox, fov, defView[0], defView[1]);
            }
        }
        return defView;
    }
}

