/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.PropertyContainer;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVector;
import com.sas.graphics.util.vtk.VTKFormat;
import java.util.Hashtable;

public abstract class ValueMap
extends PropertyContainer
implements Pipe {
    private static final String defaultMissingLabel = null;
    private String missingValueLabel = defaultMissingLabel;
    private Hashtable missingValueLabelTable = new Hashtable();
    private VTKFormat format = null;
    private Formatter formatter = Formatter.defaultFormatter;
    private Pipe owner;
    protected StringVector labelVector = new StringVector();
    public final StringPipe label = this.labelVector;

    public ValueMap() {
        this.labelVector.setOwner(this);
    }

    public void setOwner(Pipe owner) {
        this.owner = owner;
    }

    public Pipe getOwner() {
        return this.owner;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    public Formatter getOwnerFormatter() {
        return this.owner == null ? this.formatter : this.owner.getFormatter();
    }

    public VTKFormat getFormat() {
        return this.format;
    }

    public void setFormat(VTKFormat format) {
        this.formatter = format == null ? Formatter.defaultFormatter : new Formatter(format);
        this.format = format;
        this.setModified();
    }

    protected boolean isUserSetFormat() {
        return this.format != null;
    }

    public void setMissingValueLabel(String s) {
        this.missingValueLabel = s;
        this.setModified();
    }

    public String getMissingValueLabel() {
        return this.missingValueLabel;
    }

    public void setMissingValueLabel(String s, MissingValues missingValue) {
        if (this.missingValueLabelTable == null) {
            this.missingValueLabelTable = new Hashtable();
        }
        this.missingValueLabelTable.put(missingValue, s);
        this.setModified();
    }

    public String getMissingValueLabel(MissingValues missingValue) {
        Object value;
        String result = null;
        if (this.missingValueLabelTable != null && (value = this.missingValueLabelTable.get(missingValue)) != null) {
            result = (String)value;
        }
        if (result == null) {
            result = this.missingValueLabel;
        }
        if (result == null) {
            result = "." + missingValue.toString();
        }
        return result;
    }
}

