/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;

public class VTKFormat {
    private MessageFormat mf;
    private StringBuffer buffer = new StringBuffer(32);
    private FieldPosition position = new FieldPosition(0);

    public VTKFormat() {
        this.mf = new MessageFormat("{0}");
    }

    public VTKFormat(String pattern) {
        this.mf = new MessageFormat(pattern);
    }

    public VTKFormat(String pattern, Format[] formats) {
        this.mf = new MessageFormat(pattern);
        this.setFormats(formats);
    }

    public VTKFormat(Format format) {
        this.mf = new MessageFormat("{0}");
        this.setFormat(0, format);
    }

    public static String format(Object argument, String pattern) {
        if (pattern == null) {
            pattern = new String("{0}");
        }
        Object[] arg = new Object[]{argument};
        String result = MessageFormat.format(pattern, arg);
        return result;
    }

    public static String format(Object[] arguments, String pattern) {
        String result;
        if (pattern == null) {
            StringBuffer defaultPattern = new StringBuffer();
            for (int i = 0; i < arguments.length; ++i) {
                defaultPattern.append('{');
                defaultPattern.append(i);
                defaultPattern.append("} ");
            }
            result = MessageFormat.format(defaultPattern.toString(), arguments);
        } else {
            result = MessageFormat.format(pattern, arguments);
        }
        return result;
    }

    public String format(Object argument) {
        Object[] arg = new Object[]{argument};
        this.buffer.setLength(0);
        return this.mf.format(arg, this.buffer, this.position).toString();
    }

    public String format(Object[] arguments) {
        this.buffer.setLength(0);
        return this.mf.format(arguments, this.buffer, this.position).toString();
    }

    public Object informat(String s) throws ParseException {
        return this.mf.parseObject(s);
    }

    public void setPattern(String pattern) {
        this.mf.applyPattern(pattern);
    }

    public String getPattern() {
        return this.mf.toPattern();
    }

    public Format[] getFormats() {
        return this.mf.getFormats();
    }

    public void setFormat(int variableIndex, Format format) {
        this.mf.setFormat(variableIndex, format);
    }

    public void setFormats(Format[] formats) {
        this.mf.setFormats(formats);
    }

    public String toString() {
        return this.mf.toPattern();
    }
}

