/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.vtk.Style;
import java.awt.Color;
import java.awt.Font;

public class TextStyle
extends Style {
    private Color color;
    private Font font;
    private double angle;
    private int horizontalJustification;
    private int verticalJustification;
    private boolean stagger;
    private boolean split;
    private boolean fit;
    private boolean truncate;

    public TextStyle() {
        this.color = Color.black;
        this.font = FontManager.getDefaultFont();
        this.angle = 0.0;
        this.horizontalJustification = 0;
        this.verticalJustification = 2;
        this.stagger = false;
        this.split = false;
        this.fit = false;
        this.truncate = false;
    }

    public TextStyle(TextStyle ts) {
        this.color = ts.color;
        this.font = ts.font;
        this.angle = ts.angle;
        this.horizontalJustification = ts.horizontalJustification;
        this.verticalJustification = ts.verticalJustification;
        this.stagger = ts.stagger;
        this.split = ts.split;
        this.fit = ts.fit;
        this.truncate = ts.truncate;
    }

    public void setColor(Color aColor) {
        if (aColor != null) {
            this.color = aColor;
        }
    }

    public void setFont(Font aFont) {
        if (aFont != null) {
            this.font = aFont;
        }
    }

    public void setAngle(double aAngle) {
        if (!Double.isNaN(aAngle)) {
            this.angle = aAngle;
        }
    }

    public void setHorizontalJustification(int hj) {
        if (hj >= 0 && hj <= 2) {
            this.horizontalJustification = hj;
        }
    }

    public void setVerticalJustification(int vj) {
        if (vj >= 0 && vj <= 3) {
            this.verticalJustification = vj;
        }
    }

    public void setStagger(boolean trueOrFalse) {
        this.stagger = trueOrFalse;
    }

    public void setSplit(boolean trueOrFalse) {
        this.split = trueOrFalse;
    }

    public void setFit(boolean trueOrFalse) {
        this.fit = trueOrFalse;
    }

    public void setTruncate(boolean trueOrFalse) {
        this.truncate = trueOrFalse;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public double getAngle() {
        return this.angle;
    }

    public int getHorizontalJustification() {
        return this.horizontalJustification;
    }

    public int getVerticalJustification() {
        return this.verticalJustification;
    }

    public boolean isStagger() {
        return this.stagger;
    }

    public boolean isSplit() {
        return this.split;
    }

    public boolean isFit() {
        return this.fit;
    }

    public boolean isTruncate() {
        return this.truncate;
    }
}

