/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.graphics.util.vtk.VTKRuntimeException;
import com.sas.graphics.util.vtk.Variable;
import com.sas.graphics.util.vtk.VariableException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

abstract class TableModelConnection
implements Pipe,
TableModelListener {
    protected TableModel data;
    protected int variableIndex;
    private int valueCount = 0;
    private String variableName = new String();
    private VTKFormat format;
    private Variable variable;

    @Override
    public void init(AInitAction initAction) {
        initAction.setValueCount(this.valueCount);
    }

    @Override
    public void reset(AResetAction resetAction) {
    }

    @Override
    public Formatter getFormatter() {
        return null;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public VTKFormat getFormat() {
        return this.format;
    }

    public TableModelConnection(Variable variable) {
        this.variable = variable;
    }

    protected abstract boolean columnTypeMatches(Class var1, StringBuffer var2);

    @Override
    public void tableChanged(TableModelEvent e) {
        this.variable.setModified(true);
    }

    public void connectFrom(TableModel data, int variableIndex) {
        if (data == null) {
            throw new RuntimeException("Attempt to connect a null data source.");
        }
        data.addTableModelListener(this);
        Class<?> columnType = data.getColumnClass(variableIndex);
        StringBuffer correctType = new StringBuffer();
        if (!this.columnTypeMatches(columnType, correctType)) {
            throw new VariableException("The Column identified by index " + String.valueOf(variableIndex) + " is not of type " + correctType + ".");
        }
        this.data = data;
        this.variableIndex = variableIndex;
        this.variableName = data.getColumnName(variableIndex);
        this.saveValueCount();
    }

    public void connectFrom(TableModel data, String variableName) {
        if (data == null) {
            throw new RuntimeException("Attempt to connect a null data source.");
        }
        this.connectFrom(data, TableModelConnection.nameToIndex(data, variableName));
    }

    public Object getTableValue(int index) {
        Object value = null;
        if (index < 0 || index >= this.valueCount) {
            throw new VTKRuntimeException("Value index out of range: index=" + index);
        }
        value = this.data.getValueAt(index, this.variableIndex);
        return value;
    }

    public void disconnect() {
        this.data = null;
        this.variableIndex = -1;
        this.valueCount = 0;
    }

    public boolean isMissing(int i) {
        Double d;
        Object o = this.getTableValue(i);
        boolean result = false;
        if (o == null || o instanceof MissingValues) {
            result = true;
        }
        if (o instanceof Double && (d = (Double)o).isNaN()) {
            result = true;
        }
        return result;
    }

    private void saveValueCount() {
        this.valueCount = this.data != null ? this.data.getRowCount() : 0;
    }

    public void setModified() {
        this.saveValueCount();
    }

    public static int nameToIndex(TableModel data, String name) {
        int result = -1;
        if (data != null) {
            for (int i = 0; i < data.getColumnCount(); ++i) {
                if (!name.equals(data.getColumnName(i))) continue;
                result = i;
                break;
            }
        }
        return result;
    }
}

